/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.constraints.resolution;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.ConstraintType;
import gg.essential.elementa.constraints.SuperConstraint;
import gg.essential.elementa.constraints.resolution.ConstraintResolverKt;
import gg.essential.elementa.constraints.resolution.DirectedAcyclicGraph;
import gg.essential.elementa.constraints.resolution.ResolverNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rJ\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgg/essential/elementa/constraints/resolution/ConstraintVisitor;", "", "graph", "Lgg/essential/elementa/constraints/resolution/DirectedAcyclicGraph;", "Lgg/essential/elementa/constraints/resolution/ResolverNode;", "component", "Lgg/essential/elementa/UIComponent;", "(Lgg/essential/elementa/constraints/resolution/DirectedAcyclicGraph;Lgg/essential/elementa/UIComponent;)V", "getComponent", "()Lgg/essential/elementa/UIComponent;", "currentConstraint", "Lgg/essential/elementa/constraints/SuperConstraint;", "currentConstraintType", "Lgg/essential/elementa/constraints/ConstraintType;", "setConstraint", "", "constraint", "type", "visitChildren", "visitParent", "visitSelf", "visitSibling", "index", "", "Elementa"})
@SourceDebugExtension(value={"SMAP\nConstraintVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstraintVisitor.kt\ngg/essential/elementa/constraints/resolution/ConstraintVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1849#2,2:67\n*S KotlinDebug\n*F\n+ 1 ConstraintVisitor.kt\ngg/essential/elementa/constraints/resolution/ConstraintVisitor\n*L\n58#1:67,2\n*E\n"})
public final class ConstraintVisitor {
    @NotNull
    private final DirectedAcyclicGraph<ResolverNode> graph;
    @NotNull
    private final UIComponent component;
    private SuperConstraint<?> currentConstraint;
    private ConstraintType currentConstraintType;

    public ConstraintVisitor(@NotNull DirectedAcyclicGraph<ResolverNode> graph, @NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter(graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.graph = graph;
        this.component = component2;
    }

    @NotNull
    public final UIComponent getComponent() {
        return this.component;
    }

    public final void setConstraint(@NotNull SuperConstraint<?> constraint, @NotNull ConstraintType type) {
        Intrinsics.checkNotNullParameter(constraint, (String)"constraint");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.currentConstraint = constraint;
        this.currentConstraintType = type;
    }

    public final void visitParent(@NotNull ConstraintType type) {
        ConstraintType constraintType;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (!this.component.getHasParent() || this.component instanceof Window || this.component.getParent() instanceof Window) {
            return;
        }
        SuperConstraint<?> superConstraint = this.currentConstraint;
        if (superConstraint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentConstraint");
            superConstraint = null;
        }
        if ((constraintType = this.currentConstraintType) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentConstraintType");
            constraintType = null;
        }
        this.graph.addEdge(new ResolverNode(this.component, superConstraint, constraintType), new ResolverNode(this.component.getParent(), ConstraintResolverKt.getConstraint(this.component.getParent().getConstraints(), type), type));
    }

    public final void visitSelf(@NotNull ConstraintType type) {
        ConstraintType constraintType;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        SuperConstraint<?> superConstraint = this.currentConstraint;
        if (superConstraint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentConstraint");
            superConstraint = null;
        }
        if ((constraintType = this.currentConstraintType) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentConstraintType");
            constraintType = null;
        }
        this.graph.addEdge(new ResolverNode(this.component, superConstraint, constraintType), new ResolverNode(this.component, ConstraintResolverKt.getConstraint(this.component.getConstraints(), type), type));
    }

    public final void visitSibling(@NotNull ConstraintType type, int index) {
        ConstraintType constraintType;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (!this.component.getHasParent()) {
            throw new IllegalStateException(StringsKt.trimIndent((String)"\n                Error during Elementa constraint validation: the current component has no parent,\n                but visitSibling was called. This shouldn't be possible -- if you are seeing this,\n                please notify an Elementa developer ASAP!\n            "));
        }
        UIComponent sibling = this.component.getParent().getChildren().get(index);
        SuperConstraint<?> superConstraint = this.currentConstraint;
        if (superConstraint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentConstraint");
            superConstraint = null;
        }
        if ((constraintType = this.currentConstraintType) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentConstraintType");
            constraintType = null;
        }
        ResolverNode resolverNode = new ResolverNode(this.component, superConstraint, constraintType);
        Intrinsics.checkNotNullExpressionValue((Object)sibling, (String)"sibling");
        this.graph.addEdge(resolverNode, new ResolverNode(sibling, ConstraintResolverKt.getConstraint(sibling.getConstraints(), type), type));
    }

    public final void visitChildren(@NotNull ConstraintType type) {
        ConstraintType constraintType;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        SuperConstraint<?> superConstraint = this.currentConstraint;
        if (superConstraint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentConstraint");
            superConstraint = null;
        }
        if ((constraintType = this.currentConstraintType) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentConstraintType");
            constraintType = null;
        }
        ResolverNode currNode = new ResolverNode(this.component, superConstraint, constraintType);
        Iterable $this$forEach$iv = this.component.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UIComponent it = (UIComponent)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.graph.addEdge(currNode, new ResolverNode(it, ConstraintResolverKt.getConstraint(it.getConstraints(), type), type));
        }
    }
}

