/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util.swing.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JButton;
import javax.swing.JLabel;

public class RoundBoi
extends JButton {
    private Color inner = new Color(33, 34, 38);
    private final Font font;
    private final String textStr;

    public RoundBoi(String buttonText2) {
        this.setFocusPainted(false);
        this.setContentAreaFilled(false);
        this.textStr = buttonText2;
        this.font = new JLabel().getFont().deriveFont(15.0f).deriveFont(1);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                RoundBoi.this.inner = new Color(1, 165, 82);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RoundBoi.this.inner = new Color(33, 34, 38);
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(this.getForeground());
        graphics.fill(new RoundRectangle2D.Double(0.0, 0.0, this.getBounds().width, this.getBounds().height, 16.0, 16.0));
        graphics.setColor(this.inner);
        graphics.fill(new RoundRectangle2D.Double(3.0, 3.0, this.getBounds().width - 6, this.getBounds().height - 6, 16.0, 16.0));
        graphics.setFont(this.font);
        FontMetrics fm = graphics.getFontMetrics();
        int x = this.getBounds().width - fm.stringWidth(this.textStr) >> 1;
        int y = (this.getBounds().height - fm.getHeight() >> 1) + fm.getAscent();
        graphics.setColor(new Color(187, 187, 187));
        graphics.drawString(this.textStr, x, y);
        graphics.dispose();
    }
}

