/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util.classloader;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public class IsolatedClassLoader
extends URLClassLoader {
    private final List<String> packageExclusions = new ArrayList<String>(Arrays.asList("java.", "javax.", "sun.", "jdk.", "org.apache.logging."));
    private final List<String> classExclusions = new ArrayList<String>();
    private final Map<String, Class<?>> classes = new ConcurrentHashMap();
    private Predicate<String> resourceFilter;
    private final ClassLoader delegateParent;

    public IsolatedClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, (ClassLoader)new EmptyClassLoader());
        this.delegateParent = parent;
    }

    public void addPackageExclusion(String packagePrefix) {
        this.packageExclusions.add(packagePrefix);
    }

    public void addClassExclusion(String className) {
        this.classExclusions.add(className);
    }

    public void setResourceFilter(Predicate<String> resourceFilter) {
        this.resourceFilter = resourceFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name2) throws ClassNotFoundException {
        Class<?> cls = this.classes.get(name2);
        if (cls != null) {
            return cls;
        }
        for (String exclusion : this.packageExclusions) {
            if (!name2.startsWith(exclusion)) continue;
            cls = this.delegateParent.loadClass(name2);
            this.classes.put(name2, cls);
            return cls;
        }
        for (String exclusion : this.classExclusions) {
            if (!name2.equals(exclusion)) continue;
            cls = this.delegateParent.loadClass(name2);
            this.classes.put(name2, cls);
            return cls;
        }
        Object object = this.getClassLoadingLock(name2);
        synchronized (object) {
            cls = this.findLoadedClass(name2);
            if (cls == null) {
                cls = this.findClassImpl(name2);
            }
            this.classes.put(name2, cls);
            return cls;
        }
    }

    @Override
    protected final Class<?> findClass(String name2) throws ClassNotFoundException {
        return this.loadClass(name2);
    }

    protected Class<?> findClassImpl(String name2) throws ClassNotFoundException {
        return super.findClass(name2);
    }

    @Override
    public URL getResource(String name2) {
        URL url = this.findResource(name2);
        if (url != null) {
            return url;
        }
        if (this.resourceFilter != null && this.resourceFilter.test(name2)) {
            return null;
        }
        return this.delegateParent.getResource(name2);
    }

    @Override
    public Enumeration<URL> getResources(String name2) throws IOException {
        if (this.resourceFilter != null && this.resourceFilter.test(name2)) {
            return super.getResources(name2);
        }
        return Iterators.asEnumeration((Iterator)Iterators.concat((Iterator)Iterators.forEnumeration(super.getResources(name2)), (Iterator)Iterators.forEnumeration(this.delegateParent.getResources(name2))));
    }

    static {
        IsolatedClassLoader.registerAsParallelCapable();
    }

    private static class EmptyClassLoader
    extends ClassLoader {
        private EmptyClassLoader() {
        }

        @Override
        protected Package getPackage(String name2) {
            return null;
        }

        @Override
        protected Package[] getPackages() {
            return null;
        }

        @Override
        protected Class<?> loadClass(String name2, boolean resolve) throws ClassNotFoundException {
            throw new ClassNotFoundException();
        }

        @Override
        public URL getResource(String name2) {
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name2) {
            return Collections.emptyEnumeration();
        }
    }
}

