/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import gg.essential.api.utils.JsonHolder;
import gg.essential.api.utils.mojang.Model;
import gg.essential.api.utils.mojang.Name;
import gg.essential.api.utils.mojang.Profile;
import gg.essential.api.utils.mojang.Property;
import gg.essential.api.utils.mojang.SkinResponse;
import gg.essential.lib.gson.Gson;
import gg.essential.lib.okhttp3.MediaType;
import gg.essential.lib.okhttp3.MultipartBody;
import gg.essential.lib.okhttp3.Request;
import gg.essential.lib.okhttp3.RequestBody;
import gg.essential.lib.okhttp3.Response;
import gg.essential.lib.okhttp3.ResponseBody;
import gg.essential.util.HttpUtils;
import gg.essential.util.UuidNameLookup;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u0013\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u00142\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0017J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00122\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J \u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lgg/essential/util/MojangAPI;", "Lgg/essential/api/utils/mojang/MojangAPI;", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "gson", "Lgg/essential/lib/gson/Gson;", "changeSkin", "Lgg/essential/api/utils/mojang/SkinResponse;", "accessToken", "", "uuid", "Ljava/util/UUID;", "model", "Lgg/essential/api/utils/mojang/Model;", "url", "getName", "Ljava/util/concurrent/CompletableFuture;", "getNameHistory", "", "Lgg/essential/api/utils/mojang/Name;", "getProfile", "Lgg/essential/api/utils/mojang/Profile;", "getUUID", "name", "uploadSkin", "file", "Ljava/io/File;", "essential-gui-essential"})
@SourceDebugExtension(value={"SMAP\nMojangAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MojangAPI.kt\ngg/essential/util/MojangAPI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1549#2:97\n1620#2,3:98\n1#3:101\n*S KotlinDebug\n*F\n+ 1 MojangAPI.kt\ngg/essential/util/MojangAPI\n*L\n44#1:97\n44#1:98,3\n*E\n"})
public final class MojangAPI
implements gg.essential.api.utils.mojang.MojangAPI {
    @NotNull
    public static final MojangAPI INSTANCE = new MojangAPI();
    private static final Logger LOGGER = LoggerFactory.getLogger(gg.essential.api.utils.mojang.MojangAPI.class);
    @NotNull
    private static final Gson gson = new Gson();

    private MojangAPI() {
    }

    @Override
    @Nullable
    public CompletableFuture<UUID> getUUID(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return UuidNameLookup.getUUID(name2);
    }

    @Override
    @Nullable
    public CompletableFuture<String> getName(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return UuidNameLookup.getName(uuid);
    }

    @Override
    @Deprecated(message="Name history has been removed from the Mojang API")
    @Nullable
    public List<Name> getNameHistory(@Nullable UUID uuid) {
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Profile getProfile(@NotNull UUID uuid) {
        Collection<Property> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        UuidNameLookup.Profile profile2 = UuidNameLookup.fetchProfileFromUUID(uuid);
        if (profile2 == null) {
            return null;
        }
        UuidNameLookup.Profile profile3 = profile2;
        String string = profile3.getId();
        String string2 = profile3.getName();
        List<UuidNameLookup.Property> list = profile3.getProperties();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getProperties(...)");
        Iterable iterable = list;
        String string3 = string2;
        String string4 = string;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UuidNameLookup.Property property2 = (UuidNameLookup.Property)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Property(it.getName(), it.getValue()));
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        String string5 = string3;
        String string6 = string4;
        return new Profile(string6, string5, list2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public SkinResponse changeSkin(@NotNull String accessToken, @NotNull UUID uuid, @NotNull Model model, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            String string;
            JsonHolder payload = new JsonHolder().put("variant", model.getVariant()).put("url", url);
            MediaType MEDIA_TYPE = MediaType.parse("application/json");
            RequestBody body = RequestBody.create(MEDIA_TYPE, payload.toString());
            Request request2 = new Request.Builder().url("https://api.minecraftservices.com/minecraft/profile/skins").header("Authorization", "Bearer " + accessToken).post(body).build();
            Closeable closeable = HttpUtils.getHttpClient().join().newCall(request2).execute();
            Throwable throwable = null;
            try {
                Response it = (Response)closeable;
                boolean bl = false;
                ResponseBody responseBody = it.body();
                Intrinsics.checkNotNull((Object)responseBody);
                string = responseBody.string();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String output = string;
            return gson.fromJson(output, SkinResponse.class);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while updating skin", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final SkinResponse uploadSkin(@NotNull String accessToken, @NotNull Model model, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            String string;
            MultipartBody multipartBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", "skin.png", RequestBody.create(MediaType.parse("image/png"), file)).addFormDataPart("variant", model.getVariant()).build();
            Intrinsics.checkNotNullExpressionValue((Object)multipartBody, (String)"build(...)");
            RequestBody body = multipartBody;
            Request request2 = new Request.Builder().url("https://api.minecraftservices.com/minecraft/profile/skins").header("Authorization", "Bearer " + accessToken).post(body).build();
            Closeable closeable = HttpUtils.getHttpClient().join().newCall(request2).execute();
            Throwable throwable = null;
            try {
                Response it = (Response)closeable;
                boolean bl = false;
                ResponseBody responseBody = it.body();
                Intrinsics.checkNotNull((Object)responseBody);
                string = responseBody.string();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String output = string;
            return gson.fromJson(output, SkinResponse.class);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while uploading a skin to Mojang", (Throwable)e);
            return null;
        }
    }
}

