/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.pingproxy;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import gg.essential.Essential;
import gg.essential.connectionmanager.common.packet.pingproxy.ClientPingProxyPacket;
import gg.essential.connectionmanager.common.packet.pingproxy.ServerPingProxyResponsePacket;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.sps.SpsAddress;
import gg.essential.util.MinecraftUtils;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u001d\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Ljava/util/UUID;", "uuid", "Lgg/essential/gui/elementa/state/v2/State;", "", "fetchWorldNameFromSPSHost", "(Ljava/util/UUID;)Lgg/essential/gui/elementa/state/v2/State;", "Essential 1.21.7-fabric"})
public final class SPSUtilsKt {
    @NotNull
    public static final State<String> fetchWorldNameFromSPSHost(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        Intrinsics.checkNotNullExpressionValue((Object)connectionManager, (String)"getConnectionManager(...)");
        ConnectionManager connectionManager2 = connectionManager;
        String address = new SpsAddress(uuid).toString();
        MutableState<Object> worldName = StateKt.mutableStateOf(null);
        connectionManager2.send(new ClientPingProxyPacket(address, 25565, MinecraftUtils.getCurrentProtocolVersion()), arg_0 -> SPSUtilsKt.fetchWorldNameFromSPSHost$lambda$0(worldName, arg_0));
        return worldName;
    }

    private static final void fetchWorldNameFromSPSHost$lambda$0(MutableState $worldName, Optional maybePacket) {
        Intrinsics.checkNotNullParameter((Object)$worldName, (String)"$worldName");
        Intrinsics.checkNotNullParameter((Object)maybePacket, (String)"maybePacket");
        String[] stringArray = maybePacket.orElse(null);
        ServerPingProxyResponsePacket serverPingProxyResponsePacket = stringArray instanceof ServerPingProxyResponsePacket ? (ServerPingProxyResponsePacket)stringArray : null;
        if (serverPingProxyResponsePacket == null) {
            return;
        }
        ServerPingProxyResponsePacket packet = serverPingProxyResponsePacket;
        try {
            JsonObject json2 = new JsonParser().parse(packet.getRawJson()).getAsJsonObject();
            String string = json2.get("description").getAsJsonObject().get("text").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            stringArray = new String[]{" - "};
            $worldName.set(CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)1), (CharSequence)" - ", null, null, (int)0, null, null, (int)62, null));
        }
        catch (Exception exception) {
            Essential.logger.warn("Failed to parse server info", (Throwable)exception);
        }
    }
}

