/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.notices;

import gg.essential.api.gui.NotificationBuilder;
import gg.essential.api.gui.Slot;
import gg.essential.elementa.UIComponent;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.notification.ExtensionsKt;
import gg.essential.gui.notification.Notifications;
import gg.essential.gui.notification.content.ConfirmDenyNotificationActionComponent;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.notices.FriendRequestToastNoticeListener;
import gg.essential.network.connectionmanager.notices.NoticeListener;
import gg.essential.network.connectionmanager.notices.NoticesManager;
import gg.essential.network.connectionmanager.notices.SocialMenuNewFriendRequestNoticeManager;
import gg.essential.notices.NoticeType;
import gg.essential.notices.model.Notice;
import gg.essential.util.EssentialGuiExtensionsKt;
import gg.essential.util.StringsKt;
import gg.essential.util.UUIDUtil;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\r\u0010\fJ\u000f\u0010\u000e\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lgg/essential/network/connectionmanager/notices/FriendRequestToastNoticeListener;", "Lgg/essential/network/connectionmanager/notices/NoticeListener;", "Lgg/essential/network/connectionmanager/ConnectionManager;", "connectionManager", "Lgg/essential/network/connectionmanager/notices/NoticesManager;", "noticeManager", "<init>", "(Lgg/essential/network/connectionmanager/ConnectionManager;Lgg/essential/network/connectionmanager/notices/NoticesManager;)V", "Lgg/essential/notices/model/Notice;", "notice", "", "noticeAdded", "(Lgg/essential/notices/model/Notice;)V", "noticeRemoved", "onConnect", "()V", "Lgg/essential/network/connectionmanager/ConnectionManager;", "Lgg/essential/network/connectionmanager/notices/NoticesManager;", "Essential 1.21.7-fabric"})
public final class FriendRequestToastNoticeListener
implements NoticeListener {
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final NoticesManager noticeManager;

    public FriendRequestToastNoticeListener(@NotNull ConnectionManager connectionManager, @NotNull NoticesManager noticeManager) {
        Intrinsics.checkNotNullParameter((Object)connectionManager, (String)"connectionManager");
        Intrinsics.checkNotNullParameter((Object)noticeManager, (String)"noticeManager");
        this.connectionManager = connectionManager;
        this.noticeManager = noticeManager;
    }

    @Override
    public void noticeAdded(@NotNull Notice notice) {
        Intrinsics.checkNotNullParameter((Object)notice, (String)"notice");
        if (notice.getType() != NoticeType.FRIEND_REQUEST_TOAST) {
            return;
        }
        Object object = notice.getMetadata().get("uuid");
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            return;
        }
        UUID uuid = UUID.fromString(string);
        CompletableFuture<String> completableFuture = UUIDUtil.getName(uuid);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"getName(...)");
        EssentialGuiExtensionsKt.thenAcceptOnMainThread(completableFuture, (Function1)new Function1<String, Unit>(this, notice, uuid){
            final /* synthetic */ FriendRequestToastNoticeListener this$0;
            final /* synthetic */ Notice $notice;
            final /* synthetic */ UUID $uuid;
            {
                this.this$0 = $receiver;
                this.$notice = $notice;
                this.$uuid = $uuid;
                super(1);
            }

            public final void invoke(String name2) {
                Notifications.INSTANCE.pushPersistentToast("Friend Request", "", (Function0<Unit>)((Function0)noticeAdded.1.INSTANCE), (Function0<Unit>)((Function0)noticeAdded.2.INSTANCE), (Function1<? super NotificationBuilder, Unit>)((Function1)new Function1<NotificationBuilder, Unit>(name2, this.this$0, this.$uuid){
                    final /* synthetic */ String $name;
                    final /* synthetic */ FriendRequestToastNoticeListener this$0;
                    final /* synthetic */ UUID $uuid;
                    {
                        this.$name = $name;
                        this.this$0 = $receiver;
                        this.$uuid = $uuid;
                        super(1);
                    }

                    public final void invoke(@NotNull NotificationBuilder $this$pushPersistentToast) {
                        Intrinsics.checkNotNullParameter((Object)$this$pushPersistentToast, (String)"$this$pushPersistentToast");
                        String string = this.$name;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"$name");
                        ExtensionsKt.markdownBody$default($this$pushPersistentToast, StringsKt.colored(string, EssentialPalette.TEXT_HIGHLIGHT) + " wants to be your friend.", null, 2, null);
                        ConfirmDenyNotificationActionComponent component3 = new ConfirmDenyNotificationActionComponent("Accept", "Decline", (Function0)new Function0<Unit>(this.this$0, this.$uuid){
                            final /* synthetic */ FriendRequestToastNoticeListener this$0;
                            final /* synthetic */ UUID $uuid;
                            {
                                this.this$0 = $receiver;
                                this.$uuid = $uuid;
                                super(0);
                            }

                            public final void invoke() {
                                FriendRequestToastNoticeListener.access$getConnectionManager$p(this.this$0).getRelationshipManager().acceptFriend(this.$uuid);
                                SocialMenuNewFriendRequestNoticeManager socialMenuNewFriendRequestNoticeManager = FriendRequestToastNoticeListener.access$getConnectionManager$p(this.this$0).getSocialMenuNewFriendRequestNoticeManager();
                                UUID uUID = this.$uuid;
                                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"$uuid");
                                socialMenuNewFriendRequestNoticeManager.clearUnseenFriendRequests(uUID);
                            }
                        }, (Function0)new Function0<Unit>(this.this$0, this.$uuid){
                            final /* synthetic */ FriendRequestToastNoticeListener this$0;
                            final /* synthetic */ UUID $uuid;
                            {
                                this.this$0 = $receiver;
                                this.$uuid = $uuid;
                                super(0);
                            }

                            public final void invoke() {
                                FriendRequestToastNoticeListener.access$getConnectionManager$p(this.this$0).getRelationshipManager().denyFriend(this.$uuid);
                                SocialMenuNewFriendRequestNoticeManager socialMenuNewFriendRequestNoticeManager = FriendRequestToastNoticeListener.access$getConnectionManager$p(this.this$0).getSocialMenuNewFriendRequestNoticeManager();
                                UUID uUID = this.$uuid;
                                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"$uuid");
                                socialMenuNewFriendRequestNoticeManager.clearUnseenFriendRequests(uUID);
                            }
                        }, null, $this$pushPersistentToast.getDismissNotification(), 16, null);
                        $this$pushPersistentToast.withCustomComponent(Slot.ICON, (UIComponent)EssentialPalette.ENVELOPE_9X7.create());
                        $this$pushPersistentToast.withCustomComponent(Slot.ACTION, (UIComponent)component3);
                    }
                }));
                FriendRequestToastNoticeListener.access$getNoticeManager$p(this.this$0).dismissNotice(this.$notice.getId());
            }
        });
    }

    @Override
    public void noticeRemoved(@NotNull Notice notice) {
        Intrinsics.checkNotNullParameter((Object)notice, (String)"notice");
    }

    @Override
    public void onConnect() {
    }

    public static final /* synthetic */ ConnectionManager access$getConnectionManager$p(FriendRequestToastNoticeListener $this) {
        return $this.connectionManager;
    }

    public static final /* synthetic */ NoticesManager access$getNoticeManager$p(FriendRequestToastNoticeListener $this) {
        return $this.noticeManager;
    }
}

