/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.media;

import com.google.common.collect.Sets;
import com.sparkuniverse.toolbox.chat.model.Channel;
import com.sparkuniverse.toolbox.util.DateTime;
import gg.essential.Essential;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.connectionmanager.common.packet.chat.ServerChatChannelMessagePacket;
import gg.essential.connectionmanager.common.packet.media.ClientMediaCreatePacket;
import gg.essential.connectionmanager.common.packet.media.ClientMediaDeleteRequestPacket;
import gg.essential.connectionmanager.common.packet.media.ClientMediaGetUploadUrlPacket;
import gg.essential.connectionmanager.common.packet.media.ClientMediaRequestPacket;
import gg.essential.connectionmanager.common.packet.media.ClientMediaUpdatePacket;
import gg.essential.connectionmanager.common.packet.media.ServerMediaPopulatePacket;
import gg.essential.connectionmanager.common.packet.media.ServerMediaUploadUrlPacket;
import gg.essential.connectionmanager.common.packet.response.ResponseActionPacket;
import gg.essential.event.render.RenderTickEvent;
import gg.essential.gui.NotificationsKt;
import gg.essential.gui.elementa.state.v2.ListKt;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.collections.MutableTrackedList;
import gg.essential.gui.elementa.state.v2.collections.TrackedList;
import gg.essential.gui.notification.Notifications;
import gg.essential.gui.screenshot.LocalScreenshot;
import gg.essential.gui.screenshot.ScreenshotId;
import gg.essential.gui.screenshot.ScreenshotInfo;
import gg.essential.gui.screenshot.ScreenshotOverlay;
import gg.essential.gui.screenshot.ScreenshotUploadToast;
import gg.essential.gui.screenshot.UtilsKt;
import gg.essential.gui.screenshot.action.PostScreenshotAction;
import gg.essential.gui.screenshot.components.ScreenshotComponentsKt;
import gg.essential.gui.screenshot.components.ScreenshotProviderManager;
import gg.essential.gui.screenshot.concurrent.PrioritizedCallable;
import gg.essential.gui.screenshot.concurrent.PriorityThreadPoolExecutor;
import gg.essential.gui.screenshot.handler.ScreenshotChecksumManager;
import gg.essential.gui.screenshot.handler.ScreenshotMetadataManager;
import gg.essential.gui.screenshot.providers.FileCachedWindowedImageProvider;
import gg.essential.gui.screenshot.providers.WindowProviderKt;
import gg.essential.handlers.io.DirectoryWatcher;
import gg.essential.handlers.io.FileSystemEvent;
import gg.essential.handlers.screenshot.ClientScreenshotMetadata;
import gg.essential.handlers.screenshot.FileSystemEventKt;
import gg.essential.handlers.screenshot.ScreenshotUploadUtil;
import gg.essential.image.imagescaling.ResampleOp;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.media.model.Media;
import gg.essential.media.model.MediaLocationMetadata;
import gg.essential.media.model.MediaMetadata;
import gg.essential.media.model.MediaVariant;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.chat.ChatManager;
import gg.essential.network.connectionmanager.handler.screenshot.ServerScreenshotListPacketHandler;
import gg.essential.network.connectionmanager.media.IScreenshotManager;
import gg.essential.network.connectionmanager.media.ScreenshotUploadException;
import gg.essential.sps.SpsAddress;
import gg.essential.universal.UDesktop;
import gg.essential.util.EssentialSounds;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.GuiUtil;
import gg.essential.util.HelpersKt;
import gg.essential.util.MinecraftUtils;
import gg.essential.util.Multithreading;
import gg.essential.util.TimeFormatKt;
import gg.essential.util.UUIDUtil;
import gg.essential.util.lwjgl3.Lwjgl3Loader;
import gg.essential.util.lwjgl3.api.NativeImageReader;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.util.ReferenceCounted;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_437;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenshotManager
implements NetworkedManager,
IScreenshotManager {
    private final MutableState<MutableTrackedList<Pair<String, String>>> localScreenshots = ListKt.mutableListStateOf(new Pair[0]);
    private final MutableState<MutableTrackedList<Media>> remoteScreenshots = ListKt.mutableListStateOf(new Media[0]);
    private final State<TrackedList<ScreenshotInfo>> screenshots;
    private final NativeImageReader nativeImageReader;
    private final Map<String, Media> uploadedScreenshots = new HashMap<String, Media>();
    private final ConnectionManager connectionManager;
    private final ScreenshotMetadataManager screenshotMetadataManager;
    private final Set<String> screenshotFiles = Sets.newConcurrentHashSet();
    private final PriorityThreadPoolExecutor backgroundExecutor = new PriorityThreadPoolExecutor(1);
    private final FileCachedWindowedImageProvider minResolutionProvider;
    private final ScreenshotChecksumManager screenshotChecksumManager;
    private final DirectoryWatcher screenshotFolderWatcher;
    private int latestScreenshotActionId = 0;
    private boolean suppressNextBufferSwap;

    public ScreenshotManager(ConnectionManager connectionManager, File baseDir, Lwjgl3Loader lwjgl3) {
        this.connectionManager = connectionManager;
        connectionManager.registerPacketHandler(ServerMediaPopulatePacket.class, new ServerScreenshotListPacketHandler(this));
        File metadataFolder = new File(baseDir, "screenshot-metadata");
        if (!metadataFolder.exists()) {
            Essential.logger.debug("Screenshot metadata directory not found. Creating...");
            try {
                Files.createDirectories(metadataFolder.toPath(), new FileAttribute[0]);
                Essential.logger.debug("Created screenshot metadata directory.");
            }
            catch (IOException e) {
                Essential.logger.error("Failed to create screenshot metadata directory.", (Throwable)e);
            }
        }
        this.nativeImageReader = lwjgl3.get(NativeImageReader.class);
        this.screenshotChecksumManager = new ScreenshotChecksumManager(HelpersKt.getScreenshotFolder(), new File(baseDir, "screenshot-checksum-caches.json"));
        this.screenshotMetadataManager = new ScreenshotMetadataManager(metadataFolder, this.screenshotChecksumManager);
        this.minResolutionProvider = ScreenshotProviderManager.Companion.createFileCachedBicubicProvider(ScreenshotProviderManager.minResolutionTargetResolution, this.backgroundExecutor, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, baseDir.toPath(), this.nativeImageReader, true);
        Multithreading.runAsync(this::preloadScreenshots);
        this.screenshotFolderWatcher = new DirectoryWatcher(HelpersKt.getScreenshotFolder().toPath(), false, 1L, TimeUnit.SECONDS);
        this.screenshotFolderWatcher.onBatchUpdate((Function1<? super List<FileSystemEvent>, Unit>)((Function1)this::flushFilesystemOperationsQueue));
        this.screenshots = HelpersKt.combinedOrderedScreenshotsState(this.screenshotMetadataManager, HelpersKt.getScreenshotFolder().toPath(), this.localScreenshots, this.remoteScreenshots);
    }

    @Override
    public void resetState() {
        this.uploadedScreenshots.clear();
        ListKt.clear(this.remoteScreenshots);
    }

    @Override
    public void onConnected() {
        this.resetState();
        this.connectionManager.send(new ClientMediaRequestPacket(null));
    }

    private void preloadScreenshots() {
        File[] files2 = HelpersKt.getScreenshotFolder().listFiles();
        if (files2 != null) {
            for (File file : files2) {
                if (!this.fileNameMatchesImage(file.getName())) continue;
                this.screenshotFiles.add(file.getName());
                this.precompute(file);
                this.getScreenshotMetadataManager().getMetadata(file);
                String checksum = this.screenshotChecksumManager.get(file);
                if (checksum == null) continue;
                ExtensionsKt.getExecutor(class_310.method_1551()).execute(() -> this.localScreenshots.set((MutableTrackedList<Pair<String, String>>)((Function1)list -> list.add(new Pair((Object)file.getName(), (Object)checksum)))));
            }
        }
    }

    private boolean fileNameMatchesImage(String fileName) {
        return fileName.endsWith(".png") && fileName.length() > 4;
    }

    public NativeImageReader getNativeImageReader() {
        return this.nativeImageReader;
    }

    @Override
    @NotNull
    public Path getScreenshotFolder() {
        return HelpersKt.getScreenshotFolder().toPath();
    }

    @Override
    @NotNull
    public State<TrackedList<ScreenshotInfo>> getScreenshots() {
        return this.screenshots;
    }

    public CompletableFuture<Media> upload(Path path) {
        return this.upload(path, this.screenshotMetadataManager.getOrCreateMetadata(path));
    }

    public CompletableFuture<Media> upload(Path path, ClientScreenshotMetadata metadata2) {
        return this.upload(path, metadata2, ScreenshotUploadToast.create());
    }

    public CompletableFuture<Media> upload(Path path, ClientScreenshotMetadata metadata2, Consumer<ScreenshotUploadToast.ToastProgress> progressConsumer) {
        Media existingMediaIfPresent = this.getUploadedMedia(path);
        if (existingMediaIfPresent != null) {
            return CompletableFuture.completedFuture(existingMediaIfPresent);
        }
        CompletableFuture<Media> uploadFuture = new CompletableFuture<Media>();
        this.connectionManager.send(new ClientMediaGetUploadUrlPacket(), packetOptional -> {
            Packet packet = packetOptional.orElse(null);
            if (!(packet instanceof ServerMediaUploadUrlPacket)) {
                if (packet == null) {
                    uploadFuture.completeExceptionally(new ScreenshotUploadException("No response"));
                } else {
                    uploadFuture.completeExceptionally(new ScreenshotUploadException("Unexpected response: " + String.valueOf(packet)));
                }
            } else {
                progressConsumer.accept(new ScreenshotUploadToast.ToastProgress.Step(25));
                Multithreading.runAsync(() -> this.upload(path, metadata2, (ServerMediaUploadUrlPacket)packet, progressConsumer, uploadFuture));
            }
        });
        uploadFuture.whenCompleteAsync((media, throwable) -> {
            if (throwable != null) {
                throwable.printStackTrace();
                if (throwable instanceof ScreenshotUploadException) {
                    progressConsumer.accept(new ScreenshotUploadToast.ToastProgress.Complete("Failed: " + throwable.getMessage(), false));
                } else {
                    progressConsumer.accept(new ScreenshotUploadToast.ToastProgress.Complete("Failed: An unknown error occurred", false));
                }
            }
        }, ExtensionsKt.getExecutor(class_310.method_1551()));
        return uploadFuture;
    }

    @Override
    public CompletableFuture<Media> uploadAndCopyLinkToClipboard(Path path) {
        return this.uploadAndCopyLinkToClipboard(path, this.screenshotMetadataManager.getOrCreateMetadata(path));
    }

    @Override
    public CompletableFuture<Media> uploadAndCopyLinkToClipboard(Path path, ClientScreenshotMetadata metadata2) {
        return this.uploadAndCopyLinkToClipboard(path, metadata2, ScreenshotUploadToast.create());
    }

    public CompletableFuture<Media> uploadAndCopyLinkToClipboard(Path path, ClientScreenshotMetadata metadata2, Consumer<ScreenshotUploadToast.ToastProgress> progressConsumer) {
        return this.uploadAndAcceptMedia(path, metadata2, progressConsumer, media -> this.copyLinkToClipboard((Media)media, progressConsumer));
    }

    @Override
    public CompletableFuture<Media> uploadAndShareLinkToChannels(List<Channel> channels, Path path) {
        return this.uploadAndShareLinkToChannels(channels, path, this.screenshotMetadataManager.getOrCreateMetadata(path));
    }

    @Override
    public CompletableFuture<Media> uploadAndShareLinkToChannels(List<Channel> channels, Path path, ClientScreenshotMetadata metadata2) {
        return this.uploadAndShareLinkToChannels(channels, path, metadata2, ScreenshotUploadToast.create());
    }

    public CompletableFuture<Media> uploadAndShareLinkToChannels(List<Channel> channels, Path path, ClientScreenshotMetadata metadata2, Consumer<ScreenshotUploadToast.ToastProgress> progressConsumer) {
        return this.uploadAndAcceptMedia(path, metadata2, progressConsumer, media -> this.shareLinkToChannels(channels, (Media)media, progressConsumer));
    }

    @Override
    public void copyLinkToClipboard(Media media) {
        this.copyLinkToClipboard(media, ScreenshotUploadToast.create());
    }

    private void copyLinkToClipboard(Media media, Consumer<ScreenshotUploadToast.ToastProgress> progressConsumer) {
        MediaVariant embed = media.getVariants().get("embed");
        if (embed == null) {
            progressConsumer.accept(new ScreenshotUploadToast.ToastProgress.Complete("Error: Media link not supplied", false));
            return;
        }
        UDesktop.setClipboardString((String)embed.getUrl());
        progressConsumer.accept(new ScreenshotUploadToast.ToastProgress.Complete("Link copied to clipboard", true));
    }

    @Override
    public void shareLinkToChannels(List<Channel> channels, Media media) {
        this.shareLinkToChannels(channels, media, ScreenshotUploadToast.create());
    }

    public void shareLinkToChannels(List<Channel> channels, Media media, Consumer<ScreenshotUploadToast.ToastProgress> progressConsumer) {
        MediaVariant embed = media.getVariants().get("embed");
        if (embed == null) {
            progressConsumer.accept(new ScreenshotUploadToast.ToastProgress.Complete("Error: Media link not supplied", false));
            return;
        }
        HashMap messageFutures2 = new HashMap();
        ChatManager chatManager = Essential.getInstance().getConnectionManager().getChatManager();
        for (Channel channel2 : channels) {
            CompletableFuture messageFuture = new CompletableFuture();
            messageFutures2.put(channel2, messageFuture);
            chatManager.sendMessage(channel2.getId(), embed.getUrl(), response2 -> messageFuture.complete(response2.isPresent() && response2.get() instanceof ServerChatChannelMessagePacket));
        }
        CompletableFuture.allOf(messageFutures2.values().toArray(new CompletableFuture[0])).whenCompleteAsync((ignored, throwable) -> {
            boolean anySucceeded = false;
            for (Map.Entry entry2 : messageFutures2.entrySet()) {
                if (((Boolean)((CompletableFuture)entry2.getValue()).join()).booleanValue()) {
                    anySucceeded = true;
                    continue;
                }
                ScreenshotUploadToast.create().accept(new ScreenshotUploadToast.ToastProgress.Complete("Error: Failed to share to " + ((Channel)entry2.getKey()).getName(), false));
            }
            if (anySucceeded) {
                progressConsumer.accept(new ScreenshotUploadToast.ToastProgress.Complete("Picture shared", true, channels));
            } else {
                progressConsumer.accept(new ScreenshotUploadToast.ToastProgress.Complete("Error: All the messages failed to send.", false));
            }
        }, ExtensionsKt.getExecutor(class_310.method_1551()));
    }

    public void screenshotsReceived(List<Media> screenshots) {
        if (screenshots == null) {
            return;
        }
        for (Media media : screenshots) {
            this.uploadedScreenshots.put(media.getId(), media);
            MutableTrackedList<Media> list = (MutableTrackedList<Media>)this.remoteScreenshots.getUntracked();
            int index2 = -1;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (!((Media)list.get(i2)).getId().equals(media.getId())) continue;
                index2 = i2;
                break;
            }
            list = index2 != -1 ? list.set(index2, media) : list.add(media);
            this.remoteScreenshots.set(list);
        }
    }

    private CompletableFuture<Media> uploadAndAcceptMedia(Path path, ClientScreenshotMetadata metadata2, Consumer<ScreenshotUploadToast.ToastProgress> progressConsumer, Consumer<Media> mediaConsumer) {
        CompletableFuture<Media> uploadFuture = this.upload(path, metadata2, progressConsumer);
        uploadFuture.whenCompleteAsync((media, throwable) -> {
            if (media != null) {
                mediaConsumer.accept((Media)media);
            }
        }, ExtensionsKt.getExecutor(class_310.method_1551()));
        return uploadFuture;
    }

    private void upload(Path path, @NotNull ClientScreenshotMetadata metadata2, ServerMediaUploadUrlPacket packet, Consumer<ScreenshotUploadToast.ToastProgress> progressConsumer, CompletableFuture<Media> uploadFuture) {
        try {
            if (ScreenshotUploadUtil.INSTANCE.httpUpload(packet.getUploadUrl(), FileUtils.readFileToByteArray((File)path.toFile()))) {
                progressConsumer.accept(new ScreenshotUploadToast.ToastProgress.Step(50));
                UUIDUtil.getName(metadata2.getAuthorId()).whenCompleteAsync((username, throwable) -> {
                    if (throwable != null) {
                        UUIDUtil.getName(UUIDUtil.getClientUUID()).whenCompleteAsync((username1, throwable1) -> {
                            if (throwable1 != null) {
                                uploadFuture.completeExceptionally(new ScreenshotUploadException("Unable to resolve current users username", (Throwable)throwable1));
                            } else {
                                this.completeUpload(metadata2, packet, progressConsumer, uploadFuture, (String)username1);
                            }
                        }, ExtensionsKt.getExecutor(class_310.method_1551()));
                    } else {
                        this.completeUpload(metadata2, packet, progressConsumer, uploadFuture, (String)username);
                    }
                }, ExtensionsKt.getExecutor(class_310.method_1551()));
            } else {
                uploadFuture.completeExceptionally(new ScreenshotUploadException("Unable to upload file to Cloudflare Images"));
            }
        }
        catch (IOException e) {
            uploadFuture.completeExceptionally(new ScreenshotUploadException("Unable to upload file to Cloudflare Images", e));
        }
    }

    private void completeUpload(@NotNull ClientScreenshotMetadata metadata2, ServerMediaUploadUrlPacket packet, Consumer<ScreenshotUploadToast.ToastProgress> progressConsumer, CompletableFuture<Media> uploadFuture, String username) {
        progressConsumer.accept(new ScreenshotUploadToast.ToastProgress.Step(75));
        DateTime time2 = metadata2.getEditTime() != null ? metadata2.getEditTime() : metadata2.getTime();
        String identifier2 = metadata2.getLocationMetadata().getIdentifier();
        SpsAddress spsAddress = identifier2 != null ? SpsAddress.parse(identifier2) : null;
        this.connectionManager.send(new ClientMediaCreatePacket(packet.getMediaId(), username + "'s Screenshot", "Captured " + TimeFormatKt.formatDateAndTime(time2.toInstant()), new MediaMetadata(metadata2.getAuthorId(), time2, new MediaLocationMetadata(metadata2.getLocationMetadata().getType().toNetworkType(), identifier2, spsAddress == null ? null : spsAddress.getHost()), metadata2.getFavorite(), metadata2.getEdited())), packetOptional -> {
            Packet packet1 = packetOptional.orElse(null);
            if (!(packet1 instanceof ServerMediaPopulatePacket)) {
                uploadFuture.completeExceptionally(new ScreenshotUploadException("Server gave unexpected response"));
            } else {
                uploadFuture.complete(((ServerMediaPopulatePacket)packet1).getMedias().get(0));
            }
            ClientScreenshotMetadata newMetadata = metadata2.withMediaId(packet.getMediaId());
            Multithreading.runAsync(() -> this.screenshotMetadataManager.updateMetadata(newMetadata));
        });
    }

    public ClientScreenshotMetadata getCurrentMetadata() {
        String identifier2 = "Unknown";
        ClientScreenshotMetadata.Location.Type type = ClientScreenshotMetadata.Location.Type.UNKNOWN;
        if (class_310.method_1551().method_1558() != null) {
            String address = class_310.method_1551().method_1558().field_3761;
            if (SpsAddress.parse(address) != null) {
                identifier2 = address;
                type = ClientScreenshotMetadata.Location.Type.SHARED_WORLD;
            }
            if ("Unknown".equals(identifier2)) {
                type = ClientScreenshotMetadata.Location.Type.MULTIPLAYER;
                identifier2 = class_310.method_1551().method_1558().field_3761;
            }
        } else {
            String currentWorldFile = MinecraftUtils.INSTANCE.getWorldName();
            if (currentWorldFile != null) {
                identifier2 = currentWorldFile;
                type = ClientScreenshotMetadata.Location.Type.SINGLE_PLAYER;
            } else {
                class_437 guiScreen = GuiUtil.INSTANCE.openedScreen();
                if (guiScreen != null) {
                    identifier2 = GuiUtil.INSTANCE.getScreenName(guiScreen);
                    type = ClientScreenshotMetadata.Location.Type.MENU;
                }
            }
        }
        return new ClientScreenshotMetadata(UUIDUtil.getClientUUID(), new DateTime(System.currentTimeMillis()), "checksum", null, new ClientScreenshotMetadata.Location(type, identifier2), false, false, Collections.emptySet(), null);
    }

    public void saveScreenshotAsync(RenderedImage img, File imgFile, ClientScreenshotMetadata sourceMetadata) {
        Multithreading.runAsync(() -> {
            try {
                String checksum = this.saveScreenshot(img, imgFile);
                ClientScreenshotMetadata metadata2 = ScreenshotComponentsKt.cloneWithNewChecksum(sourceMetadata, checksum);
                this.handleNewScreenshot(imgFile, metadata2, true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public CompletableFuture<Void> saveDownloadedImageAsync(RenderedImage img) {
        CompletableFuture<Void> future2 = new CompletableFuture<Void>();
        Multithreading.runAsync(() -> {
            try {
                File imgFile = this.getDownloadedName(new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()));
                this.saveScreenshot(img, imgFile);
                future2.complete(null);
            }
            catch (IOException e) {
                future2.completeExceptionally(e);
                throw new RuntimeException(e);
            }
        });
        return future2;
    }

    private File getDownloadedName(String name2) {
        int i2 = 0;
        File file1;
        while ((file1 = new File(HelpersKt.getScreenshotFolder(), "saved_" + name2 + (String)(i2 == 0 ? "" : "_" + i2) + ".png")).exists()) {
            ++i2;
        }
        return file1;
    }

    private void precompute(File source) {
        this.backgroundExecutor.submit(new PrecomputeTask(source, this.minResolutionProvider));
    }

    public void handleNewScreenshot(File imgFile, ClientScreenshotMetadata metadata2, boolean showOverlay) {
        this.screenshotChecksumManager.set(imgFile, metadata2.getChecksum());
        this.screenshotMetadataManager.updateMetadata(metadata2);
        this.screenshotFiles.add(imgFile.getName());
        ExtensionsKt.getExecutor(class_310.method_1551()).execute(() -> this.localScreenshots.set((MutableTrackedList<Pair<String, String>>)((Function1)list -> list.add(new Pair((Object)imgFile.getName(), (Object)metadata2.getChecksum())))));
        this.precompute(imgFile);
        if (showOverlay) {
            ExtensionsKt.getExecutor(class_310.method_1551()).execute(() -> ScreenshotOverlay.INSTANCE.push(imgFile));
        }
        ExtensionsKt.getExecutor(class_310.method_1551()).execute(() -> {
            int currentId = ++this.latestScreenshotActionId;
            Multithreading.scheduleOnMainThread(() -> {
                if (currentId != this.latestScreenshotActionId) {
                    return;
                }
                PostScreenshotAction.current().run(imgFile);
            }, 600L, TimeUnit.MILLISECONDS);
        });
    }

    private String saveScreenshot(RenderedImage image2, File destination) throws IOException {
        ByteArrayOutputStream os2 = new ByteArrayOutputStream();
        ImageIO.write(image2, "png", os2);
        byte[] data = os2.toByteArray();
        FileUtils.writeByteArrayToFile((File)destination, (byte[])data);
        return DigestUtils.md5Hex((byte[])data);
    }

    @Nullable
    public String getChecksum(File file) {
        return this.screenshotChecksumManager.get(file);
    }

    @Override
    public Collection<Media> getUploadedMedia() {
        return this.uploadedScreenshots.values();
    }

    public Media getUploadedMedia(String mediaId) {
        return this.uploadedScreenshots.get(mediaId);
    }

    @NotNull
    public List<Path> getUploadedLocalPathsCache(String mediaId) {
        ClientScreenshotMetadata metadata2 = this.screenshotMetadataManager.getMetadataCache(mediaId);
        if (metadata2 == null) {
            return Collections.emptyList();
        }
        return this.screenshotChecksumManager.getPathsForChecksum(metadata2.getChecksum());
    }

    public Media getUploadedMedia(Path path) {
        ClientScreenshotMetadata metadata2 = this.screenshotMetadataManager.getOrCreateMetadata(path);
        for (String mediaId : metadata2.getMediaIds()) {
            Media media = this.getUploadedMedia(mediaId);
            if (media == null) continue;
            return media;
        }
        return null;
    }

    @Override
    public ClientScreenshotMetadata setFavorite(Path path, boolean favorite) {
        ClientScreenshotMetadata metadata2 = this.screenshotMetadataManager.getOrCreateMetadata(path).withFavorite(favorite);
        this.screenshotMetadataManager.updateMetadata(metadata2);
        return metadata2;
    }

    @Override
    public ClientScreenshotMetadata setFavorite(Media media, boolean favorite) {
        this.connectionManager.send(new ClientMediaUpdatePacket(media.getId(), null, null, favorite), maybeReply -> {
            Packet reply = maybeReply.orElse(null);
            if (reply instanceof ServerMediaPopulatePacket) {
                return;
            }
            Essential.logger.error("Failed to update favorite state of {}: {}", (Object)media.getId(), (Object)reply);
        });
        media.getMetadata().setFavorite(favorite);
        return new ClientScreenshotMetadata(media);
    }

    @Override
    public ScreenshotMetadataManager getScreenshotMetadataManager() {
        return this.screenshotMetadataManager;
    }

    private Unit flushFilesystemOperationsQueue(List<FileSystemEvent> events2) {
        List<FileSystemEvent> items2 = FileSystemEventKt.filterRedundancy(events2);
        MutableTrackedList<Pair> list = (MutableTrackedList<Pair>)this.localScreenshots.getUntracked();
        block5: for (FileSystemEvent event : items2) {
            String name2 = event.getPath().getFileName().toString();
            if (!this.fileNameMatchesImage(name2)) continue;
            block0 : switch (event.getEventType()) {
                case CREATE: {
                    if (!this.screenshotFiles.add(name2)) break;
                    String checksum = this.screenshotChecksumManager.get(event.getPath().toFile());
                    list = list.add(new Pair((Object)name2, (Object)checksum));
                    break;
                }
                case DELETE: {
                    if (!this.handleDelete(event.getPath().toFile(), true)) break;
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        if (!name2.equals(((Pair)list.get(i2)).component1())) continue;
                        list = list.removeAt(i2);
                        break block0;
                    }
                    continue block5;
                }
                case MODIFY: {
                    throw new AssertionError((Object)"MODIFY should have been replaced with DELETE+CREATE");
                }
            }
        }
        this.localScreenshots.set((MutableTrackedList<Pair<String, String>>)list);
        return Unit.INSTANCE;
    }

    @Override
    public void deleteFile(@NotNull Path path) {
        this.handleDelete(path.toFile(), false);
    }

    public boolean handleDelete(@NotNull File file, boolean external) {
        boolean mutated;
        File[] files2;
        File screenshot_cache = new File(Essential.getInstance().getBaseDir(), "screenshot-cache");
        if (screenshot_cache.exists() && (files2 = screenshot_cache.listFiles()) != null) {
            for (File directory : files2) {
                if (!directory.isDirectory()) continue;
                File downsampledCache = new File(directory, file.getName());
                downsampledCache.delete();
            }
        }
        if (mutated = this.screenshotFiles.remove(file.getName())) {
            MutableTrackedList list = (MutableTrackedList)this.localScreenshots.getUntracked();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (!((String)((Pair)list.get(i2)).component1()).equals(file.getName())) continue;
                this.localScreenshots.set(list.removeAt(i2));
                break;
            }
        }
        ScreenshotOverlay.INSTANCE.delete(file);
        if (external) {
            this.getScreenshotMetadataManager().handleExternalDelete(file.getName());
        } else {
            this.getScreenshotMetadataManager().deleteMetadata(file);
            file.delete();
        }
        return mutated;
    }

    @Override
    public void deleteMedia(String mediaId, Path localFile) {
        ClientScreenshotMetadata metadata2;
        this.uploadedScreenshots.remove(mediaId);
        MutableTrackedList list = (MutableTrackedList)this.remoteScreenshots.getUntracked();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!((Media)list.get(i2)).getId().equals(mediaId)) continue;
            this.remoteScreenshots.set(list.removeAt(i2));
            break;
        }
        if (localFile != null && (metadata2 = this.screenshotMetadataManager.getMetadata(localFile)) != null) {
            this.screenshotMetadataManager.updateMetadata(metadata2.withoutMediaId(mediaId));
        }
        this.connectionManager.send(new ClientMediaDeleteRequestPacket(mediaId), maybeReply -> {
            Packet reply = maybeReply.orElse(null);
            if (reply instanceof ResponseActionPacket && ((ResponseActionPacket)reply).isSuccessful()) {
                return;
            }
            Essential.logger.error("Failed to delete media with id {}: {}", (Object)mediaId, (Object)reply);
            Notifications.INSTANCE.push("Error Deleting Screenshot", "An unknown error occurred. Check logs for details");
        });
    }

    @Override
    @NotNull
    public List<Path> getOrderedPaths() {
        return HelpersKt.getOrderedPaths(this.screenshotFiles, HelpersKt.getScreenshotFolder().toPath(), (Function1<? super Path, ? extends DateTime>)((Function1)path -> UtilsKt.getImageTime(path, this.screenshotMetadataManager.getMetadata((Path)path), true)));
    }

    private File getEditedName(ScreenshotId source) {
        String base = source.getName().replaceFirst("(_edited(_\\d+)?)?\\.png", "");
        int i2 = 1;
        File file1;
        while ((file1 = new File(HelpersKt.getScreenshotFolder(), base + "_edited" + (String)(i2 == 1 ? "" : "_" + i2) + ".png")).exists()) {
            ++i2;
        }
        return file1;
    }

    @Override
    public File handleScreenshotEdited(@NotNull ScreenshotId source, @NotNull ClientScreenshotMetadata originalMetadata, @NotNull BufferedImage screenshot, boolean favorite) {
        File output = this.getEditedName(source);
        try {
            String checksum = this.saveScreenshot(screenshot, output);
            this.screenshotMetadataManager.updateMetadata(new ClientScreenshotMetadata(originalMetadata.getAuthorId(), originalMetadata.getTime(), checksum, new DateTime(System.currentTimeMillis()), originalMetadata.getLocationMetadata(), favorite, true, Collections.emptySet(), null));
            this.screenshotFiles.add(output.getName());
            ExtensionsKt.getExecutor(class_310.method_1551()).execute(() -> {
                this.localScreenshots.set((MutableTrackedList<Pair<String, String>>)((Function1)list -> list.add(new Pair((Object)output.getName(), (Object)checksum))));
                NotificationsKt.sendCheckmarkNotification("Picture saved as copy");
            });
            return output;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean hasOverlay() {
        return Notifications.INSTANCE.hasActiveNotifications() || ScreenshotOverlay.INSTANCE.hasActiveNotifications();
    }

    public void handleScreenshotKeyPressed() {
        if (this.hasOverlay()) {
            Notifications.INSTANCE.hide();
            ScreenshotOverlay.INSTANCE.hide();
            Essential.EVENT_BUS.register(new Object(){

                @Subscribe
                public void preBufferSwap(RenderTickEvent.Final event) {
                    ScreenshotManager.this.takeNow();
                    Notifications.INSTANCE.show();
                    ScreenshotOverlay.INSTANCE.show();
                    ScreenshotManager.this.suppressNextBufferSwap = true;
                    Essential.EVENT_BUS.unregister(this);
                }
            });
        } else {
            this.takeNow();
        }
    }

    public boolean suppressBufferSwap() {
        if (this.suppressNextBufferSwap) {
            this.suppressNextBufferSwap = false;
            return true;
        }
        return false;
    }

    private void takeNow() {
        class_310 mc = class_310.method_1551();
        if (EssentialConfig.INSTANCE.getScreenshotSounds()) {
            EssentialSounds.INSTANCE.playScreenshotSound();
        }
        class_318.method_1659((File)mc.field_1697, (class_276)mc.method_1522(), message2 -> this.screenshotMessageCallback((class_2561)message2));
    }

    private void screenshotMessageCallback(class_2561 component3) {
        if (EssentialConfig.INSTANCE.getEnableVanillaScreenshotMessage()) {
            class_310.method_1551().field_1705.method_1743().method_1812(component3);
        }
    }

    private static class PrecomputeTask
    extends PrioritizedCallable<Void> {
        private final File file;
        private final FileCachedWindowedImageProvider provider;

        public PrecomputeTask(File file, FileCachedWindowedImageProvider provider2) {
            super(Integer.MAX_VALUE, -1, 0);
            this.file = file;
            this.provider = provider2;
        }

        @Override
        public Void call() throws Exception {
            try {
                ResampleOp.isBackgroundTask.set(true);
                this.provider.setItems(Collections.singletonList(new LocalScreenshot(this.file.toPath())));
                this.provider.provide(WindowProviderKt.toSingleWindowRequest(0), Collections.emptySet()).values().forEach(ReferenceCounted::release);
                Void void_ = null;
                return void_;
            }
            finally {
                ResampleOp.isBackgroundTask.set(false);
            }
        }
    }
}

