/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.handler.upnp;

import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.packet.upnp.ServerUPnPSessionInviteAddPacket;
import gg.essential.gui.notification.HelpersKt;
import gg.essential.handlers.discord.DiscordIntegration;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.handler.PacketHandler;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.upnp.model.UPnPSession;
import gg.essential.util.Multithreading;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lgg/essential/network/connectionmanager/handler/upnp/ServerUPnPSessionInviteAddPacketHandler;", "Lgg/essential/network/connectionmanager/handler/PacketHandler;", "Lgg/essential/connectionmanager/common/packet/upnp/ServerUPnPSessionInviteAddPacket;", "<init>", "()V", "Lgg/essential/network/connectionmanager/ConnectionManager;", "connectionManager", "packet", "", "onHandle", "(Lgg/essential/network/connectionmanager/ConnectionManager;Lgg/essential/connectionmanager/common/packet/upnp/ServerUPnPSessionInviteAddPacket;)V", "", "Ljava/util/UUID;", "cooldowns", "Ljava/util/Set;", "Essential 1.21.7-fabric"})
public final class ServerUPnPSessionInviteAddPacketHandler
extends PacketHandler<ServerUPnPSessionInviteAddPacket> {
    @NotNull
    private final Set<UUID> cooldowns = new LinkedHashSet();

    @Override
    protected void onHandle(@NotNull ConnectionManager connectionManager, @NotNull ServerUPnPSessionInviteAddPacket packet) {
        Intrinsics.checkNotNullParameter((Object)connectionManager, (String)"connectionManager");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        UUID uUID = packet.getHostUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getHostUUID(...)");
        UUID hostUUID = uUID;
        SPSManager sPSManager = connectionManager.getSpsManager();
        Intrinsics.checkNotNullExpressionValue((Object)sPSManager, (String)"getSpsManager(...)");
        SPSManager spsManager = sPSManager;
        UPnPSession session = spsManager.getRemoteSession(hostUUID);
        if (session == null || !EssentialConfig.INSTANCE.getEssentialEnabled()) {
            return;
        }
        if (DiscordIntegration.INSTANCE.getPartyManager().shouldHideNotificationForHost(hostUUID)) {
            return;
        }
        if (this.cooldowns.contains(hostUUID)) {
            return;
        }
        this.cooldowns.add(hostUUID);
        Multithreading.scheduleOnMainThread(() -> ServerUPnPSessionInviteAddPacketHandler.onHandle$lambda$0(this, hostUUID), 7L, TimeUnit.SECONDS);
        HelpersKt.sendSpsInviteNotification(hostUUID);
    }

    private static final void onHandle$lambda$0(ServerUPnPSessionInviteAddPacketHandler this$0, UUID $hostUUID) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$hostUUID, (String)"$hostUUID");
        this$0.cooldowns.remove($hostUUID);
    }
}

