/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.handler.chat;

import com.sparkuniverse.toolbox.chat.enums.ChannelType;
import com.sparkuniverse.toolbox.chat.model.Channel;
import com.sparkuniverse.toolbox.chat.model.Message;
import gg.essential.api.gui.NotificationBuilder;
import gg.essential.api.gui.Slot;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.packet.chat.ServerChatChannelMessagePacket;
import gg.essential.gui.friends.SocialMenu;
import gg.essential.gui.notification.Notifications;
import gg.essential.gui.skin.SkinUtilsKt;
import gg.essential.lib.okhttp3.HttpUrl;
import gg.essential.mod.Model;
import gg.essential.mod.Skin;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.chat.ChatManager;
import gg.essential.network.connectionmanager.handler.PacketHandler;
import gg.essential.universal.USound;
import gg.essential.util.CachedAvatarImage;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.GuiUtil;
import gg.essential.util.UUIDUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class ServerChatChannelMessagePacketHandler
extends PacketHandler<ServerChatChannelMessagePacket> {
    @Override
    protected void onHandle(@NotNull ConnectionManager connectionManager, @NotNull ServerChatChannelMessagePacket packet) {
        ChatManager chatManager = connectionManager.getChatManager();
        List<@NotNull T> sortedMessages = Arrays.stream(packet.getMessages()).sorted(Comparator.comparing(message2 -> ((Message)message2).getCreatedAt()).reversed()).collect(Collectors.toList());
        for (Message message3 : sortedMessages) {
            boolean notification;
            Long lastReadMessageId;
            boolean isFromHistoryRequest;
            Optional<Channel> channelOptional = chatManager.getChannel(message3.getChannelId());
            if (!channelOptional.isPresent()) {
                return;
            }
            boolean bl = isFromHistoryRequest = packet.getPacketUniqueId() != null;
            Channel channel2 = channelOptional.get();
            if (chatManager.upsertMessageToChannel(channel2.getId(), message3, isFromHistoryRequest)) continue;
            boolean isRead = connectionManager.getUsingProtocol() >= 9 ? ((lastReadMessageId = channel2.getLastReadMessageId()) == null ? false : channel2.getLastReadMessageId() >= message3.getId()) : message3.isRead();
            if (isRead || message3.getSender().equals(UUIDUtil.getClientUUID()) || channel2.isMuted() || isFromHistoryRequest || !EssentialConfig.INSTANCE.getEssentialFull()) continue;
            HttpUrl url = HttpUrl.parse(message3.getContents());
            if (url != null && url.host().equals("essential.gg")) {
                List<String> pathSegments = url.pathSegments();
                if (pathSegments.size() > 2 && pathSegments.get(0).equals("skin")) {
                    Skin skin = new Skin(pathSegments.get(2), Model.byVariantOrDefault(pathSegments.get(1)));
                    UUID uuid = message3.getSender();
                    UUIDUtil.getName(uuid).thenAcceptAsync(name2 -> SkinUtilsKt.showSkinReceivedToast(skin, uuid, name2, channel2), ExtensionsKt.getExecutor(class_310.method_1551()));
                    continue;
                }
                if (pathSegments.size() > 1 && pathSegments.get(0).equals("gift")) continue;
            }
            if (!(notification = !(GuiUtil.INSTANCE.openedScreen() instanceof SocialMenu))) continue;
            UUID uuid = channel2.getType() == ChannelType.DIRECT_MESSAGE ? ExtensionsKt.getOtherUser(channel2) : message3.getSender();
            UUIDUtil.getName(uuid).thenAcceptAsync((Consumer)new NotificationHandler(channel2, message3), ExtensionsKt.getExecutor(class_310.method_1551()));
        }
    }

    static class NotificationHandler
    implements Consumer<String> {
        private final Channel channel;
        private final Message message;

        NotificationHandler(Channel channel2, Message message2) {
            this.channel = channel2;
            this.message = message2;
        }

        @Override
        public void accept(String name2) {
            boolean dm;
            boolean bl = dm = this.channel.getType() == ChannelType.DIRECT_MESSAGE;
            if (dm && EssentialConfig.INSTANCE.getMessageReceivedNotifications() || !dm && EssentialConfig.INSTANCE.getGroupMessageReceivedNotifications()) {
                String notificationTitle;
                String string = notificationTitle = dm ? name2 : String.format(Locale.ROOT, "%s [%s]", name2, this.channel.getName());
                if (EssentialConfig.INSTANCE.getMessageSound() && !EssentialConfig.INSTANCE.getStreamerMode()) {
                    USound.INSTANCE.playExpSound();
                }
                Notifications.INSTANCE.push(notificationTitle, this.message.getContents(), 4.0f, (Function0<Unit>)((Function0)() -> {
                    GuiUtil.openScreen(SocialMenu.class, () -> new SocialMenu(this.channel.getId()));
                    return Unit.INSTANCE;
                }), (Function0<Unit>)((Function0)() -> Unit.INSTANCE), (Function1<? super NotificationBuilder, Unit>)((Function1)notificationBuilder -> {
                    notificationBuilder.setTrimTitle(true);
                    notificationBuilder.setTrimMessage(true);
                    notificationBuilder.withCustomComponent(Slot.ICON, CachedAvatarImage.create(this.message.getSender()));
                    return Unit.INSTANCE;
                }));
            }
        }
    }
}

