/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.cosmetics;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapMaker;
import gg.essential.config.EssentialConfig;
import gg.essential.cosmetics.EquippedCosmetic;
import gg.essential.cosmetics.EquippedCosmeticId;
import gg.essential.elementa.state.v2.ReferenceHolder;
import gg.essential.gui.elementa.state.v2.ListCombinatorsKt;
import gg.essential.gui.elementa.state.v2.Observer;
import gg.essential.gui.elementa.state.v2.ReferenceHolderImpl;
import gg.essential.gui.elementa.state.v2.SetCombinatorsKt;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.collections.TrackedSet;
import gg.essential.gui.elementa.state.v2.combinators.StateKt;
import gg.essential.mod.Skin;
import gg.essential.mod.cosmetics.CosmeticSlot;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsData;
import gg.essential.network.connectionmanager.cosmetics.EquippedOutfitsManager;
import gg.essential.network.connectionmanager.cosmetics.StateBasedEquippedOutfitsManager;
import gg.essential.network.cosmetics.Cosmetic;
import gg.essential.util.IterableKt;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001c\u0010\u0004\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0007`\b\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00050\n\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\"\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00100\u00052\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0010*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u0012\u001a \u0012\u0004\u0012\u00020\u0007\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00100\u00050\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/StateBasedEquippedOutfitsManager;", "Lgg/essential/network/connectionmanager/cosmetics/EquippedOutfitsManager;", "cosmeticsData", "Lgg/essential/network/connectionmanager/cosmetics/CosmeticsData;", "managedPlayers", "Lgg/essential/gui/elementa/state/v2/State;", "Lgg/essential/gui/elementa/state/v2/collections/TrackedSet;", "Ljava/util/UUID;", "Lgg/essential/gui/elementa/state/v2/SetState;", "getEquippedCosmeticsStateFunc", "Lkotlin/Function1;", "Lgg/essential/network/connectionmanager/cosmetics/EquippedOutfitsManager$Outfit;", "(Lgg/essential/network/connectionmanager/cosmetics/CosmeticsData;Lgg/essential/gui/elementa/state/v2/State;Lkotlin/jvm/functions/Function1;)V", "refHolder", "Lgg/essential/elementa/state/v2/ReferenceHolder;", "skins", "", "Lgg/essential/mod/Skin;", "visibleCosmeticsStateCache", "", "Lgg/essential/mod/cosmetics/CosmeticSlot;", "Lgg/essential/cosmetics/EquippedCosmetic;", "getEquippedCosmeticsState", "playerId", "getSkin", "getVisibleCosmeticsState", "computeVisibleCosmetics", "Lgg/essential/gui/elementa/state/v2/Observer;", "outfit", "essential-gui-essential"})
@SourceDebugExtension(value={"SMAP\nStateBasedEquippedOutfitsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateBasedEquippedOutfitsManager.kt\ngg/essential/network/connectionmanager/cosmetics/StateBasedEquippedOutfitsManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n372#2,7:103\n1#3:110\n*S KotlinDebug\n*F\n+ 1 StateBasedEquippedOutfitsManager.kt\ngg/essential/network/connectionmanager/cosmetics/StateBasedEquippedOutfitsManager\n*L\n46#1:103,7\n*E\n"})
public final class StateBasedEquippedOutfitsManager
implements EquippedOutfitsManager {
    @NotNull
    private final CosmeticsData cosmeticsData;
    @NotNull
    private final Function1<UUID, State<EquippedOutfitsManager.Outfit>> getEquippedCosmeticsStateFunc;
    @NotNull
    private final ReferenceHolder refHolder;
    @NotNull
    private final Map<UUID, State<Map<CosmeticSlot, EquippedCosmetic>>> visibleCosmeticsStateCache;
    @NotNull
    private Map<UUID, Skin> skins;

    public StateBasedEquippedOutfitsManager(@NotNull CosmeticsData cosmeticsData, @NotNull State<? extends TrackedSet<UUID>> managedPlayers, @NotNull Function1<? super UUID, ? extends State<EquippedOutfitsManager.Outfit>> getEquippedCosmeticsStateFunc) {
        Intrinsics.checkNotNullParameter((Object)cosmeticsData, (String)"cosmeticsData");
        Intrinsics.checkNotNullParameter(managedPlayers, (String)"managedPlayers");
        Intrinsics.checkNotNullParameter(getEquippedCosmeticsStateFunc, (String)"getEquippedCosmeticsStateFunc");
        this.cosmeticsData = cosmeticsData;
        this.getEquippedCosmeticsStateFunc = getEquippedCosmeticsStateFunc;
        this.refHolder = new ReferenceHolderImpl();
        ConcurrentMap concurrentMap = new MapMaker().weakValues().makeMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"makeMap(...)");
        this.visibleCosmeticsStateCache = concurrentMap;
        this.skins = MapsKt.emptyMap();
        final State skinStates2 = ListCombinatorsKt.mapEach(SetCombinatorsKt.toList(managedPlayers), (Function1)new Function1<UUID, Pair<? extends UUID, ? extends State<? extends Skin>>>(this){
            final /* synthetic */ StateBasedEquippedOutfitsManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Pair<UUID, State<Skin>> invoke(@NotNull UUID uuid) {
                Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                return TuplesKt.to((Object)uuid, StateKt.map(this.this$0.getEquippedCosmeticsState(uuid), skinStates.1.INSTANCE));
            }
        });
        gg.essential.gui.elementa.state.v2.StateKt.effect(this.refHolder, (Function1<? super Observer, Unit>)((Function1)new Function1<Observer, Unit>(){

            public final void invoke(final @NotNull Observer $this$effect) {
                Intrinsics.checkNotNullParameter((Object)$this$effect, (String)"$this$effect");
                skins = IterableKt.associateNotNull((Iterable)$this$effect.invoke(skinStates2), (Function1)new Function1<Pair<? extends UUID, ? extends State<? extends Skin>>, Pair<? extends UUID, ? extends Skin>>(){

                    @Nullable
                    public final Pair<UUID, Skin> invoke(@NotNull Pair<UUID, ? extends State<Skin>> pair) {
                        Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                        UUID uuid = (UUID)pair.component1();
                        State skinState = (State)pair.component2();
                        Skin skin = (Skin)$this$effect.invoke(skinState);
                        if (skin == null) {
                            return null;
                        }
                        Skin skin2 = skin;
                        return TuplesKt.to((Object)uuid, (Object)skin2);
                    }
                });
            }
        }));
    }

    @Override
    @NotNull
    public State<EquippedOutfitsManager.Outfit> getEquippedCosmeticsState(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return (State)this.getEquippedCosmeticsStateFunc.invoke((Object)playerId);
    }

    @Override
    @NotNull
    public State<Map<CosmeticSlot, EquippedCosmetic>> getVisibleCosmeticsState(@NotNull UUID playerId) {
        State<Map<CosmeticSlot, EquippedCosmetic>> state2;
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Map<UUID, State<Map<CosmeticSlot, EquippedCosmetic>>> $this$getOrPut$iv = this.visibleCosmeticsStateCache;
        boolean $i$f$getOrPut = false;
        State<Map<CosmeticSlot, EquippedCosmetic>> value$iv = $this$getOrPut$iv.get(playerId);
        if (value$iv == null) {
            boolean bl = false;
            State<EquippedOutfitsManager.Outfit> outfitState = this.getEquippedCosmeticsState(playerId);
            State answer$iv = gg.essential.gui.elementa.state.v2.StateKt.memo((Function1)new Function1<Observer, Map<CosmeticSlot, ? extends EquippedCosmetic>>(this, outfitState){
                final /* synthetic */ StateBasedEquippedOutfitsManager this$0;
                final /* synthetic */ State<EquippedOutfitsManager.Outfit> $outfitState;
                {
                    this.this$0 = $receiver;
                    this.$outfitState = $outfitState;
                    super(1);
                }

                @NotNull
                public final Map<CosmeticSlot, EquippedCosmetic> invoke(@NotNull Observer $this$memo) {
                    Intrinsics.checkNotNullParameter((Object)$this$memo, (String)"$this$memo");
                    return StateBasedEquippedOutfitsManager.access$computeVisibleCosmetics(this.this$0, $this$memo, $this$memo.invoke(this.$outfitState));
                }
            });
            $this$getOrPut$iv.put(playerId, answer$iv);
            state2 = answer$iv;
        } else {
            state2 = value$iv;
        }
        return state2;
    }

    private final Map<CosmeticSlot, EquippedCosmetic> computeVisibleCosmetics(Observer $this$computeVisibleCosmetics, EquippedOutfitsManager.Outfit outfit) {
        boolean cosmeticsHidden = (Boolean)$this$computeVisibleCosmetics.invoke((State)EssentialConfig.INSTANCE.getDisableCosmeticsState());
        boolean emotesHidden = (Boolean)$this$computeVisibleCosmetics.invoke((State)EssentialConfig.INSTANCE.getDisableEmotesState());
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry<CosmeticSlot, EquippedCosmeticId> entry2 : outfit.getCosmetics().entrySet()) {
            Cosmetic cosmetic2;
            Object v0;
            EquippedCosmeticId value;
            CosmeticSlot slot;
            block2: {
                slot = entry2.getKey();
                value = entry2.getValue();
                if (!StateBasedEquippedOutfitsManager.computeVisibleCosmetics$isVisible(cosmeticsHidden, emotesHidden, slot)) continue;
                Iterable iterable = $this$computeVisibleCosmetics.invoke(this.cosmeticsData.getCosmetics());
                for (Object t : iterable) {
                    Cosmetic it = (Cosmetic)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)value.getId())) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            if ((Cosmetic)v0 == null) continue;
            builder.put((Object)slot, (Object)new EquippedCosmetic(cosmetic2, value.getSettings()));
        }
        ImmutableMap immutableMap = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"build(...)");
        return (Map)immutableMap;
    }

    @Override
    @Nullable
    public Skin getSkin(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return this.skins.get(playerId);
    }

    private static final boolean computeVisibleCosmetics$isVisible(boolean cosmeticsHidden, boolean emotesHidden, CosmeticSlot slot) {
        if (Intrinsics.areEqual((Object)slot, (Object)CosmeticSlot.ICON)) {
            return true;
        }
        if (cosmeticsHidden && !Intrinsics.areEqual((Object)slot, (Object)CosmeticSlot.EMOTE)) {
            return false;
        }
        return !Intrinsics.areEqual((Object)slot, (Object)CosmeticSlot.EMOTE) || !emotesHidden;
    }

    public static final /* synthetic */ Map access$computeVisibleCosmetics(StateBasedEquippedOutfitsManager $this, Observer $receiver, EquippedOutfitsManager.Outfit outfit) {
        return $this.computeVisibleCosmetics($receiver, outfit);
    }
}

