/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager;

import com.google.common.primitives.Bytes;
import gg.essential.Essential;
import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.connectionmanager.common.packet.connection.ConnectionKeepAlivePacket;
import gg.essential.data.VersionInfo;
import gg.essential.handlers.CertChain;
import gg.essential.lib.websocket.client.DnsResolver;
import gg.essential.lib.websocket.client.WebSocketClient;
import gg.essential.lib.websocket.handshake.ServerHandshake;
import gg.essential.network.connectionmanager.CloseReason;
import gg.essential.network.connectionmanager.ConnectionCodec;
import gg.essential.network.connectionmanager.ConnectionManagerKt;
import gg.essential.network.connectionmanager.legacyjre.LegacyJre;
import gg.essential.network.connectionmanager.legacyjre.LegacyJreDnsResolver;
import gg.essential.network.connectionmanager.legacyjre.LegacyJreSocketFactory;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.LimitedExecutor;
import gg.essential.util.Multithreading;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
extends WebSocketClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(Connection.class);
    private static final Lazy<Function<String, SSLSocketFactory>> SSL_SOCKET_FACTORY_FACTORY = LazyKt.lazy(() -> {
        try {
            SSLSocketFactory factory2 = ((SSLContext)new CertChain().loadEmbedded().done().getFirst()).getSocketFactory();
            if (LegacyJre.IS_LEGACY_JRE_51 || LegacyJre.IS_LEGACY_JRE_74) {
                Essential.logger.info("Using LegacyJreSocketFactory");
                return host -> new LegacyJreSocketFactory(factory2, (String)host);
            }
            Essential.logger.info("Using Default JreSocketFactory");
            return host -> factory2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    });
    private static final Lazy<DnsResolver> DNS_RESOLVER = LazyKt.lazy(() -> {
        if (LegacyJre.IS_LEGACY_JRE_51) {
            Essential.logger.info("Using LegacyJreDnsResolver");
            return new LegacyJreDnsResolver();
        }
        Essential.logger.info("Using Default JreDnsResolver");
        return uri -> InetAddress.getByName(uri.getHost());
    });
    private static final URI CM_HOST_URI;
    @NotNull
    private final Executor sendExecutor = new LimitedExecutor(Multithreading.getPool(), 1, new ConcurrentLinkedQueue<Runnable>());
    @NotNull
    private final Callbacks callbacks;
    private final ConnectionCodec codec = new ConnectionCodec(this::log);
    private int usingProtocol = 1;
    private ScheduledFuture<?> timeoutTask;
    private static final int MAX_PROTOCOL = 8;
    private static final int MAX_LOGS = 10;
    private final Executor loggingExecutor = new LimitedExecutor(Multithreading.getPool(), 1, new ConcurrentLinkedQueue<Runnable>());
    private PrintStream logOut;
    private boolean logClosed;

    public Connection(@NotNull Callbacks callbacks) {
        super(CM_HOST_URI);
        this.callbacks = callbacks;
        this.setTcpNoDelay(true);
        this.setReuseAddr(true);
        this.setConnectionLostTimeout(0);
    }

    public int getUsingProtocol() {
        return this.usingProtocol;
    }

    public void close(@NotNull CloseReason closeReason) {
        this.close(closeReason.getCode(), closeReason.name());
    }

    @Override
    public void onOpen(@NotNull ServerHandshake serverHandshake) {
        this.usingProtocol = Integer.parseInt(serverHandshake.getFieldValue("Essential-Protocol-Version"));
        this.scheduleTimeout();
        this.log(out -> out.printf("{\"type\": \"OPEN\", \"version\": %d}\n", this.usingProtocol));
        this.callbacks.onOpen();
    }

    @Override
    public void onClosing(int code, @NotNull String reason, boolean remote) {
        this.onClosingOrClosed(code, reason, remote);
    }

    @Override
    public void onClose(int code, @NotNull String reason, boolean remote) {
        this.onClosingOrClosed(code, reason, remote);
    }

    private void onClosingOrClosed(int code, @NotNull String reason, boolean remote) {
        ScheduledFuture<?> timeoutTask = this.timeoutTask;
        if (timeoutTask != null) {
            timeoutTask.cancel(false);
            this.timeoutTask = null;
        }
        KnownCloseReason knownReason = reason.contains("Invalid status code received: 410") || reason.contains("Invalid status code received: 404") ? KnownCloseReason.OUTDATED : null;
        this.callbacks.onClose(new ConnectionManagerKt.CloseInfo(code, reason, remote, knownReason));
    }

    @Override
    public void close() {
        this.log(out -> {
            out.print("{\"type\": \"CLOSE\"}\n");
            out.close();
            this.logClosed = true;
        });
        super.close();
    }

    @Override
    public void onMessage(@NotNull String message2) {
    }

    @Override
    public void onMessage(@NotNull ByteBuffer byteBuffer) {
        Packet packet = this.codec.decode(byteBuffer.array());
        if (packet == null) {
            return;
        }
        this.onMessage(packet);
    }

    private void onMessage(Packet packet) {
        if (packet instanceof ConnectionKeepAlivePacket) {
            this.scheduleTimeout();
            ConnectionKeepAlivePacket response2 = new ConnectionKeepAlivePacket();
            response2.setUniqueId(packet.getPacketUniqueId());
            this.send(response2);
            return;
        }
        this.callbacks.onPacketAsync(packet);
    }

    @Override
    public void onError(@NotNull Exception e) {
        Essential.logger.error("Critical error occurred on connection management. ", (Throwable)e);
    }

    public void send(@NotNull Packet packet) {
        Packet fakeReplyPacket = packet.getFakeReplyPacket();
        if (fakeReplyPacket != null) {
            fakeReplyPacket.setUniqueId(packet.getPacketUniqueId());
            Multithreading.scheduleOnBackgroundThread(() -> this.onMessage(fakeReplyPacket), packet.getFakeReplyDelayMs(), TimeUnit.MILLISECONDS);
            return;
        }
        this.sendExecutor.execute(() -> this.doSend(packet));
    }

    private void doSend(Packet packet) {
        this.codec.encode(packet, this::send);
    }

    public void setupAndConnect(UUID uuid, String userName, byte[] secret) {
        byte[] colon = ":".getBytes(StandardCharsets.UTF_8);
        byte[] name2 = userName.getBytes(StandardCharsets.UTF_8);
        byte[] nameSecret = Bytes.concat((byte[][])new byte[][]{name2, colon, secret});
        String encoded = Base64.getEncoder().encodeToString(nameSecret);
        this.addHeader("Authorization", "Basic " + encoded);
        String protocolProperty = System.getProperty("essential.cm.protocolVersion");
        if (protocolProperty == null) {
            this.addHeader("Essential-Max-Protocol-Version", String.valueOf(8));
        } else {
            this.addHeader("Essential-Protocol-Version", protocolProperty);
        }
        this.addHeader("Essential-User-UUID", uuid.toString());
        this.addHeader("Essential-User-Name", userName);
        VersionInfo versionInfo = new VersionInfo();
        this.addHeader("Essential-Mod-Version", versionInfo.getEssentialVersion());
        this.addHeader("Essential-Mod-Commit", versionInfo.getEssentialCommit());
        this.addHeader("Essential-Mod-Branch", versionInfo.getEssentialBranch());
        try {
            this.setDnsResolver((DnsResolver)DNS_RESOLVER.getValue());
            if ("wss".equals(this.uri.getScheme())) {
                this.setSocketFactory((SocketFactory)((Function)SSL_SOCKET_FACTORY_FACTORY.getValue()).apply(this.uri.getHost()));
            }
            this.connect();
        }
        catch (Exception e) {
            Essential.logger.error("Error when connecting to Essential ConnectionManager.", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void scheduleTimeout() {
        ScheduledFuture<?> timeoutTask = this.timeoutTask;
        if (timeoutTask != null) {
            timeoutTask.cancel(false);
        }
        this.timeoutTask = Multithreading.getScheduledPool().schedule(() -> this.close(CloseReason.SERVER_KEEP_ALIVE_TIMEOUT), 60L, TimeUnit.SECONDS);
    }

    private void log(IOConsumer<PrintStream> consumer) {
        this.loggingExecutor.execute(() -> this.logSync(consumer));
    }

    private void logSync(IOConsumer<PrintStream> consumer) {
        if (this.logClosed) {
            return;
        }
        if (this.logOut == null) {
            Path folder = ExtensionsKt.getGlobalEssentialDirectory().resolve("infra-logs");
            Connection.cleanupLogs(folder);
            Path file = folder.resolve(Instant.now().toString().replace(':', '_') + ".log");
            try {
                Files.createDirectories(folder, new FileAttribute[0]);
                this.logOut = new PrintStream(Files.newOutputStream(file, new OpenOption[0]));
            }
            catch (IOException e) {
                LOGGER.error("Failed to create connection log file {}", (Object)file, (Object)e);
                return;
            }
        }
        try {
            consumer.accept(this.logOut);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write to connection log file", (Throwable)e);
        }
    }

    private static void cleanupLogs(Path folder) {
        List files2;
        try (Stream<Object> stream = Files.exists(folder, new LinkOption[0]) ? Files.list(folder) : Stream.empty();){
            files2 = stream.sorted(Comparator.comparing(file -> {
                try {
                    return Files.getLastModifiedTime(file, new LinkOption[0]);
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to get last modified time of {}", file, (Object)e);
                    return FileTime.from(Instant.EPOCH);
                }
            }).reversed()).collect(Collectors.toList());
        }
        catch (IOException e) {
            LOGGER.error("Failed to list files in {}", (Object)folder, (Object)e);
            return;
        }
        int count = 0;
        for (Path file2 : files2) {
            block29: {
                if (count >= 10) {
                    try {
                        Files.delete(file2);
                        break block29;
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to delete {}", (Object)file2, (Object)e);
                        continue;
                    }
                }
                if (file2.getFileName().toString().endsWith(".log")) {
                    Path gzFile = file2.resolveSibling(String.valueOf(file2.getFileName()) + ".gz");
                    try (OutputStream out = Files.newOutputStream(gzFile, new OpenOption[0]);
                         GZIPOutputStream gzOut = new GZIPOutputStream(out);){
                        Files.copy(file2, gzOut);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to write compressed file {}", (Object)gzFile, (Object)e);
                        throw new RuntimeException(e);
                    }
                    try {
                        Files.delete(file2);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to delete {}", (Object)file2, (Object)e);
                        continue;
                    }
                }
            }
            ++count;
        }
    }

    static {
        String defaultUri = "wss://connect.essential.gg/v1";
        URI uri = URI.create(System.getProperty("essential.cm.host", System.getenv().getOrDefault("ESSENTIAL_CM_HOST", defaultUri)));
        String[] knownHosts = new String[]{".essential.gg", ".modcore.dev"};
        boolean schemeGood = uri.getScheme().equals("wss");
        boolean hostGood = Arrays.stream(knownHosts).anyMatch(uri.getHost()::endsWith);
        if (!schemeGood || !hostGood) {
            Essential.logger.error("Potentially insecure ESSENTIAL_CM_HOST found, using default instead");
            uri = URI.create(defaultUri);
        }
        CM_HOST_URI = uri;
    }

    static interface Callbacks {
        public void onOpen();

        public void onPacketAsync(Packet var1);

        public void onClose(ConnectionManagerKt.CloseInfo var1);
    }

    static interface IOConsumer<T> {
        public void accept(T var1) throws IOException;
    }

    public static enum KnownCloseReason {
        OUTDATED;

    }
}

