/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model.collision;

import gg.essential.lib.kotgl.matrix.vectors.Vec3;
import gg.essential.lib.kotgl.matrix.vectors.Vectors;
import gg.essential.lib.kotgl.matrix.vectors.mutables.MutableVec3;
import gg.essential.lib.kotgl.matrix.vectors.mutables.MutableVectors;
import gg.essential.model.collision.CollisionProvider;
import gg.essential.model.collision.PlaneCollisionProviderKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J.\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgg/essential/model/collision/PlaneCollisionProvider;", "Lgg/essential/model/collision/CollisionProvider;", "pointOnPlane", "Lgg/essential/lib/kotgl/matrix/vectors/Vec3;", "normal", "(Ldev/folomeev/kotgl/matrix/vectors/Vec3;Ldev/folomeev/kotgl/matrix/vectors/Vec3;)V", "query", "Lkotlin/Pair;", "pos", "size", "", "offset", "Companion", "cosmetics"})
public final class PlaneCollisionProvider
implements CollisionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vec3 pointOnPlane;
    @NotNull
    private final Vec3 normal;
    @NotNull
    private static final PlaneCollisionProvider PlaneXZ = new PlaneCollisionProvider(Vectors.vecZero(), Vectors.vecUnitY());

    public PlaneCollisionProvider(@NotNull Vec3 pointOnPlane, @NotNull Vec3 normal) {
        Intrinsics.checkNotNullParameter((Object)pointOnPlane, (String)"pointOnPlane");
        Intrinsics.checkNotNullParameter((Object)normal, (String)"normal");
        this.pointOnPlane = pointOnPlane;
        this.normal = normal;
    }

    @Override
    @Nullable
    public Pair<Vec3, Vec3> query(@NotNull Vec3 pos, float size, @NotNull Vec3 offset) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        boolean topSide = Vectors.dot(pos, this.normal) > Vectors.dot(this.pointOnPlane, this.normal);
        MutableVec3 direction = MutableVectors.normalize(offset);
        float dirDotNorm = Vectors.dot(direction, this.normal);
        if ((double)Math.abs(dirDotNorm) < 0.001) {
            return null;
        }
        if (dirDotNorm > 0.0f == topSide) {
            return null;
        }
        MutableVec3 offsetPlane = MutableVectors.plusScaled(this.pointOnPlane, topSide ? size : -size, this.normal);
        float distanceToPlane = Vectors.dot(MutableVectors.minus(offsetPlane, pos), this.normal) / dirDotNorm;
        return Vectors.sqrLength(offset) < PlaneCollisionProviderKt.access$sqr(distanceToPlane) ? null : new Pair((Object)MutableVectors.times((Vec3)direction, distanceToPlane), (Object)this.normal);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgg/essential/model/collision/PlaneCollisionProvider$Companion;", "", "()V", "PlaneXZ", "Lgg/essential/model/collision/PlaneCollisionProvider;", "getPlaneXZ", "()Lgg/essential/model/collision/PlaneCollisionProvider;", "cosmetics"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PlaneCollisionProvider getPlaneXZ() {
            return PlaneXZ;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

