/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.mixinextras.injector.wrapmethod;

import gg.essential.lib.mixinextras.injector.wrapmethod.WrapMethod;
import gg.essential.lib.mixinextras.injector.wrapmethod.WrapMethodApplicatorExtension;
import gg.essential.lib.mixinextras.injector.wrapoperation.Operation;
import gg.essential.lib.mixinextras.service.MixinExtrasService;
import gg.essential.lib.mixinextras.sugar.impl.ShareInfo;
import gg.essential.lib.mixinextras.utils.CompatibilityHelper;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Annotations;

public class WrapMethodInjector
extends Injector {
    private final Type operationType;
    private final List<ShareInfo> shares;

    public WrapMethodInjector(InjectionInfo info) {
        super(info, "@WrapMethod");
        this.operationType = MixinExtrasService.getInstance().changePackage(Operation.class, Type.getType((String)CompatibilityHelper.getAnnotation((InjectionInfo)this.info).desc), WrapMethod.class);
        this.shares = new ArrayList<ShareInfo>();
    }

    protected void inject(Target target2, InjectionNodes.InjectionNode node) {
        this.checkTargetModifiers(target2, true);
        this.checkSignature(target2);
        this.info.addCallbackInvocation(this.methodNode);
        WrapMethodApplicatorExtension.offerWrapper(target2, this.methodNode, this.operationType, this.shares);
    }

    private void checkSignature(Target target2) {
        int argIndex;
        Injector.InjectorData handler = new Injector.InjectorData(target2, "method wrapper");
        String description2 = String.format("%s %s %s from %s", new Object[]{this.annotationType, handler, this, CompatibilityHelper.getMixin(this.info)});
        if (!this.returnType.equals((Object)target2.returnType)) {
            throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s targeting %s has an incorrect return type Expected %s but got %s!", description2, target2, target2.returnType, this.returnType));
        }
        for (argIndex = 0; argIndex < target2.arguments.length; ++argIndex) {
            Type theirType = target2.arguments[argIndex];
            if (argIndex >= this.methodArgs.length) {
                throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s targeting %s doesn't have enough parameters!", description2, target2));
            }
            Type ourType = this.methodArgs[argIndex];
            if (ourType.equals((Object)theirType)) continue;
            throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s targeting %s has a mismatching param at index %s! Expected %s but got %s", description2, target2, argIndex, theirType, ourType));
        }
        if (argIndex >= this.methodArgs.length || !this.methodArgs[argIndex++].equals((Object)this.operationType)) {
            throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s targeting %s is missing Operation parameter!", description2, target2));
        }
        List sugars = (List)Annotations.getValue((AnnotationNode)CompatibilityHelper.getAnnotation(this.info), (String)"sugars");
        if (sugars != null) {
            for (int i2 = 0; i2 < argIndex; ++i2) {
                AnnotationNode sugar = (AnnotationNode)sugars.get(i2);
                if (!MixinExtrasService.getInstance().isClassOwned(Type.getType((String)sugar.desc).getClassName())) continue;
                throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s targeting %s has sugar on a non-trailing param which is not allowed!", description2, target2));
            }
        }
        while (argIndex < this.methodArgs.length) {
            ShareInfo share;
            if (sugars == null || (share = ShareInfo.getOrCreate(target2, (AnnotationNode)sugars.get(argIndex), this.methodArgs[argIndex], CompatibilityHelper.getMixin(this.info).getMixin(), null)) == null) {
                throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s targeting %s has an excess parameter at index %s!", description2, target2, argIndex));
            }
            this.shares.add(share);
            ++argIndex;
        }
    }
}

