/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.ice.stun;

import gg.essential.data.VersionInfo;
import gg.essential.ice.stun.StunAttribute;
import gg.essential.ice.stun.StunAttributeType;
import gg.essential.ice.stun.StunClass;
import gg.essential.ice.stun.StunType;
import gg.essential.ice.stun.TransactionId;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 *2\u00020\u0001:\u0001*B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u001b\u001a\u0004\u0018\u0001H\u001c\"\n\b\u0000\u0010\u001c\u0018\u0001*\u00020\nH\u0086\b\u00a2\u0006\u0002\u0010\u001dJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J7\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0006\u0010#\u001a\u00020\u0011J\u0013\u0010$\u001a\u00020\u00152\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006+"}, d2={"Lgg/essential/ice/stun/StunMessage;", "", "type", "Lgg/essential/ice/stun/StunType;", "cls", "Lgg/essential/ice/stun/StunClass;", "transactionId", "Lgg/essential/ice/stun/TransactionId;", "attributes", "", "Lgg/essential/ice/stun/StunAttribute;", "(Lgg/essential/ice/stun/StunType;Lgg/essential/ice/stun/StunClass;Lgg/essential/ice/stun/TransactionId;Ljava/util/List;)V", "getAttributes", "()Ljava/util/List;", "getCls", "()Lgg/essential/ice/stun/StunClass;", "integrityProtectionKey", "", "getIntegrityProtectionKey", "()[B", "isIntegrityProtected", "", "()Z", "getTransactionId", "()Lgg/essential/ice/stun/TransactionId;", "getType", "()Lgg/essential/ice/stun/StunType;", "attribute", "T", "()Lgg/essential/ice/stun/StunAttribute;", "component1", "component2", "component3", "component4", "copy", "encode", "equals", "other", "hashCode", "", "toString", "", "Companion", "ice"})
@SourceDebugExtension(value={"SMAP\nStunMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StunMessage.kt\ngg/essential/ice/stun/StunMessage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,366:1\n37#1:368\n1#2:367\n1#2:369\n1549#3:370\n1620#3,3:371\n*S KotlinDebug\n*F\n+ 1 StunMessage.kt\ngg/essential/ice/stun/StunMessage\n*L\n43#1:368\n43#1:369\n92#1:370\n92#1:371,3\n*E\n"})
public final class StunMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StunType type;
    @NotNull
    private final StunClass cls;
    @NotNull
    private final TransactionId transactionId;
    @NotNull
    private final List<StunAttribute> attributes;
    @NotNull
    private static final String SOFTWARE = "essential.gg v" + new VersionInfo().getEssentialVersion();
    private static final int HEADER_SIZE = 20;
    @NotNull
    private static final byte[] MAGIC_COOKIE;

    public StunMessage(@NotNull StunType type, @NotNull StunClass cls, @NotNull TransactionId transactionId, @NotNull List<? extends StunAttribute> attributes) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)cls), (String)"cls");
        Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this.type = type;
        this.cls = cls;
        this.transactionId = transactionId;
        this.attributes = attributes;
        if (!this.type.isCompatible(this.cls)) {
            throw new IllegalArgumentException("Message type " + (Object)((Object)this.type) + " cannot be used with " + (Object)((Object)this.cls) + '.');
        }
    }

    @NotNull
    public final StunType getType() {
        return this.type;
    }

    @NotNull
    public final StunClass getCls() {
        return this.cls;
    }

    @NotNull
    public final TransactionId getTransactionId() {
        return this.transactionId;
    }

    @NotNull
    public final List<StunAttribute> getAttributes() {
        return this.attributes;
    }

    public final /* synthetic */ <T extends StunAttribute> T attribute() {
        StunAttribute stunAttribute;
        block1: {
            boolean $i$f$attribute = false;
            for (StunAttribute it : (Iterable)this.getAttributes()) {
                boolean bl = false;
                Intrinsics.reifiedOperationMarker((int)2, (String)"T");
                StunAttribute stunAttribute2 = it;
                if (stunAttribute2 == null) continue;
                stunAttribute = stunAttribute2;
                break block1;
            }
            stunAttribute = null;
        }
        return (T)stunAttribute;
    }

    public final boolean isIntegrityProtected() {
        return this.getIntegrityProtectionKey() != null;
    }

    @Nullable
    public final byte[] getIntegrityProtectionKey() {
        StunAttribute stunAttribute;
        block2: {
            StunMessage this_$iv = this;
            boolean $i$f$attribute = false;
            for (StunAttribute it$iv : (Iterable)this_$iv.getAttributes()) {
                StunAttribute stunAttribute2;
                boolean bl = false;
                StunAttribute stunAttribute3 = it$iv;
                if (!(stunAttribute3 instanceof StunAttribute.MessageIntegrity)) {
                    stunAttribute3 = null;
                }
                if ((stunAttribute2 = (StunAttribute)((StunAttribute.MessageIntegrity)stunAttribute3)) == null) continue;
                stunAttribute = stunAttribute2;
                break block2;
            }
            stunAttribute = null;
        }
        StunAttribute.MessageIntegrity messageIntegrity = (StunAttribute.MessageIntegrity)stunAttribute;
        return (byte[])(messageIntegrity != null ? messageIntegrity.getKey() : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] encode() {
        void $this$mapTo$iv$iv;
        List attributes = CollectionsKt.toMutableList((Collection)this.attributes);
        if (this.type != StunType.Send) {
            attributes.add(0, new StunAttribute.Software(SOFTWARE));
        }
        Iterable $this$map$iv = attributes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair;
            void attr;
            StunAttribute stunAttribute = (StunAttribute)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var12_19 = attr;
            if (var12_19 instanceof StunAttribute.MappedAddress) {
                throw new IllegalArgumentException("MappedAddress encoding not implemented.");
            }
            if (var12_19 instanceof StunAttribute.XorMappedAddress) {
                pair = new Pair((Object)StunAttributeType.XorMappedAddress, (Object)StunMessage.encode$encodeXorAddress(this, ((StunAttribute.XorMappedAddress)attr).getAddress()));
            } else if (var12_19 instanceof StunAttribute.Username) {
                pair = new Pair((Object)StunAttributeType.Username, (Object)StringsKt.encodeToByteArray((String)((StunAttribute.Username)attr).getUsername()));
            } else if (var12_19 instanceof StunAttribute.MessageIntegrity) {
                pair = new Pair((Object)StunAttributeType.MessageIntegrity, (Object)new byte[20]);
            } else {
                byte[] byArray;
                if (var12_19 instanceof StunAttribute.ErrorCode) {
                    throw new IllegalArgumentException("ErrorCode encoding not implemented.");
                }
                if (var12_19 instanceof StunAttribute.UnknownAttributes) {
                    throw new IllegalArgumentException("UnknownAttributes encoding not implemented.");
                }
                if (var12_19 instanceof StunAttribute.ChannelNumber) {
                    pair = new Pair((Object)StunAttributeType.ChannelNumber, (Object)StunMessage.encode$encodeInt((((StunAttribute.ChannelNumber)attr).getNumber-Mh2AYeg() & 0xFFFF) << 16));
                } else if (var12_19 instanceof StunAttribute.Lifetime) {
                    pair = new Pair((Object)StunAttributeType.Lifetime, (Object)StunMessage.encode$encodeInt(((StunAttribute.Lifetime)attr).getSeconds-pVg5ArA()));
                } else if (var12_19 instanceof StunAttribute.XorPeerAddress) {
                    pair = new Pair((Object)StunAttributeType.XorPeerAddress, (Object)StunMessage.encode$encodeXorAddress(this, ((StunAttribute.XorPeerAddress)attr).getAddress()));
                } else if (var12_19 instanceof StunAttribute.Data) {
                    pair = new Pair((Object)StunAttributeType.Data, (Object)((StunAttribute.Data)attr).getBytes());
                } else if (var12_19 instanceof StunAttribute.XorRelayedAddress) {
                    pair = new Pair((Object)StunAttributeType.XorRelayedAddress, (Object)StunMessage.encode$encodeXorAddress(this, ((StunAttribute.XorRelayedAddress)attr).getAddress()));
                } else if (var12_19 instanceof StunAttribute.RequestedTransport) {
                    byArray = new byte[]{17, 0, 0, 0};
                    pair = new Pair((Object)StunAttributeType.RequestedTransport, (Object)byArray);
                } else if (var12_19 instanceof StunAttribute.Priority) {
                    pair = new Pair((Object)StunAttributeType.Priority, (Object)StunMessage.encode$encodeInt(((StunAttribute.Priority)attr).getValue()));
                } else if (var12_19 instanceof StunAttribute.UseCandidate) {
                    pair = new Pair((Object)StunAttributeType.UseCandidate, (Object)new byte[0]);
                } else if (var12_19 instanceof StunAttribute.Software) {
                    pair = new Pair((Object)StunAttributeType.Software, (Object)StringsKt.encodeToByteArray((String)((StunAttribute.Software)attr).getValue()));
                } else if (var12_19 instanceof StunAttribute.TransactionTransmitCounter) {
                    byArray = new byte[]{0, 0, (byte)((StunAttribute.TransactionTransmitCounter)attr).getRequest(), (byte)((StunAttribute.TransactionTransmitCounter)attr).getResponse()};
                    pair = new Pair((Object)StunAttributeType.TransactionTransmitCounter, (Object)byArray);
                } else if (var12_19 instanceof StunAttribute.IceControlling) {
                    pair = new Pair((Object)StunAttributeType.IceControlling, (Object)StunMessage.encode$encodeLong(((StunAttribute.IceControlling)attr).getTiebreaker-s-VKNKU()));
                } else if (var12_19 instanceof StunAttribute.IceControlled) {
                    pair = new Pair((Object)StunAttributeType.IceControlled, (Object)StunMessage.encode$encodeLong(((StunAttribute.IceControlled)attr).getTiebreaker-s-VKNKU()));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            collection.add(pair);
        }
        List encodedAttrs = (List)destination$iv$iv;
        Object $this$encode_u24lambda_u242 = this;
        int n = 0;
        int t = ((StunMessage)$this$encode_u24lambda_u242).type.getId();
        int c = ((StunMessage)$this$encode_u24lambda_u242).cls.ordinal();
        int typeAndClass = (t & 0xF80) << 2 | (t & 0x70) << 1 | t & 0xF | (c & 2) << 7 | (c & 1) << 4;
        $this$encode_u24lambda_u242 = encodedAttrs;
        n = 0;
        Iterator<Object> iterator2 = $this$encode_u24lambda_u242.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t3 = iterator2.next();
            item$iv$iv = (Pair)t3;
            int n2 = n;
            boolean bl = false;
            int n3 = 4 + StunMessage.Companion.padToMultipleOf(((byte[])it.getSecond()).length, 4);
            n = n2 + n3;
        }
        int attrsLength = n;
        byte[] bytes = new byte[20 + attrsLength];
        bytes[0] = (byte)(typeAndClass >> 8);
        bytes[1] = (byte)typeAndClass;
        ArraysKt.copyInto$default((byte[])MAGIC_COOKIE, (byte[])bytes, (int)4, (int)0, (int)0, (int)12, null);
        ArraysKt.copyInto$default((byte[])this.transactionId.getBytes(), (byte[])bytes, (int)8, (int)0, (int)0, (int)12, null);
        int offset = 20;
        for (Pair pair : encodedAttrs) {
            byte[] key;
            StunAttribute.MessageIntegrity messageIntegrity;
            int verifiedLength;
            block41: {
                StunAttributeType type = (StunAttributeType)((Object)pair.component1());
                byte[] encodedAttr = (byte[])pair.component2();
                int attrLength = encodedAttr.length;
                bytes[offset] = (byte)(type.getId() >> 8);
                bytes[offset + 1] = (byte)type.getId();
                bytes[offset + 2] = (byte)(attrLength >> 8);
                bytes[offset + 3] = (byte)attrLength;
                ArraysKt.copyInto$default((byte[])encodedAttr, (byte[])bytes, (int)(offset += 4), (int)0, (int)0, (int)12, null);
                offset += StunMessage.Companion.padToMultipleOf(attrLength, 4);
                if (type != StunAttributeType.MessageIntegrity) continue;
                verifiedLength = offset - 24;
                int storedLength = offset;
                bytes[2] = (byte)(storedLength - 20 >> 8);
                bytes[3] = (byte)(storedLength - 20);
                for (StunAttribute it : (Iterable)attributes) {
                    boolean bl = false;
                    messageIntegrity = it instanceof StunAttribute.MessageIntegrity ? (StunAttribute.MessageIntegrity)it : null;
                    if (messageIntegrity == null) {
                        continue;
                    }
                    break block41;
                }
                messageIntegrity = null;
            }
            if (messageIntegrity == null) {
                throw new NoSuchElementException("No element of the collection was transformed to a non-null value.");
            }
            if (messageIntegrity.getKey() == null) {
                throw new IOException("Cannot encode MessageIntegrity without password.");
            }
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(key, "HmacSHA1"));
            mac.update(bytes, 0, verifiedLength);
            byte[] hmac = mac.doFinal();
            Intrinsics.checkNotNull((Object)hmac);
            ArraysKt.copyInto$default((byte[])hmac, (byte[])bytes, (int)(offset - 20), (int)0, (int)0, (int)12, null);
        }
        bytes[2] = (byte)(attrsLength >> 8);
        bytes[3] = (byte)attrsLength;
        return bytes;
    }

    @NotNull
    public final StunType component1() {
        return this.type;
    }

    @NotNull
    public final StunClass component2() {
        return this.cls;
    }

    @NotNull
    public final TransactionId component3() {
        return this.transactionId;
    }

    @NotNull
    public final List<StunAttribute> component4() {
        return this.attributes;
    }

    @NotNull
    public final StunMessage copy(@NotNull StunType type, @NotNull StunClass cls, @NotNull TransactionId transactionId, @NotNull List<? extends StunAttribute> attributes) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)cls), (String)"cls");
        Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        return new StunMessage(type, cls, transactionId, attributes);
    }

    public static /* synthetic */ StunMessage copy$default(StunMessage stunMessage, StunType stunType, StunClass stunClass, TransactionId transactionId, List list, int n, Object object) {
        if ((n & 1) != 0) {
            stunType = stunMessage.type;
        }
        if ((n & 2) != 0) {
            stunClass = stunMessage.cls;
        }
        if ((n & 4) != 0) {
            transactionId = stunMessage.transactionId;
        }
        if ((n & 8) != 0) {
            list = stunMessage.attributes;
        }
        return stunMessage.copy(stunType, stunClass, transactionId, list);
    }

    @NotNull
    public String toString() {
        return "StunMessage(type=" + (Object)((Object)this.type) + ", cls=" + (Object)((Object)this.cls) + ", transactionId=" + this.transactionId + ", attributes=" + this.attributes + ')';
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.cls.hashCode();
        result = result * 31 + this.transactionId.hashCode();
        result = result * 31 + ((Object)this.attributes).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StunMessage)) {
            return false;
        }
        StunMessage stunMessage = (StunMessage)other;
        if (this.type != stunMessage.type) {
            return false;
        }
        if (this.cls != stunMessage.cls) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.transactionId, (Object)stunMessage.transactionId)) {
            return false;
        }
        return Intrinsics.areEqual(this.attributes, stunMessage.attributes);
    }

    private static final byte[] encode$encodeXorAddress(StunMessage this$0, InetSocketAddress address) {
        int n;
        InetAddress inetAddress = address.getAddress();
        if (inetAddress instanceof Inet4Address) {
            n = 1;
        } else if (inetAddress instanceof Inet6Address) {
            n = 2;
        } else {
            throw new IOException("Unknown address family " + address.getAddress());
        }
        int family = n;
        int port = address.getPort();
        byte[] addressBytes = address.getAddress().getAddress();
        byte[] addressMask = ArraysKt.plus((byte[])MAGIC_COOKIE, (byte[])this$0.transactionId.getBytes());
        int n2 = addressBytes.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            addressBytes[i2] = (byte)(addressBytes[i2] ^ addressMask[i2]);
        }
        byte[] bytes = new byte[4 + addressBytes.length];
        bytes[1] = (byte)family;
        bytes[2] = (byte)((byte)(port >> 8) ^ MAGIC_COOKIE[0]);
        bytes[3] = (byte)((byte)port ^ MAGIC_COOKIE[1]);
        Intrinsics.checkNotNull((Object)addressBytes);
        ArraysKt.copyInto$default((byte[])addressBytes, (byte[])bytes, (int)4, (int)0, (int)0, (int)12, null);
        return bytes;
    }

    private static final byte[] encode$encodeInt(int value) {
        byte[] byArray = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)(value >> 0)};
        return byArray;
    }

    private static final byte[] encode$encodeLong(long value) {
        byte[] byArray = new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)(value >> 0)};
        return byArray;
    }

    static {
        byte[] byArray = new byte[]{33, 18, -92, 66};
        MAGIC_COOKIE = byArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JX\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062#\u0010\f\u001a\u001f\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00060\r2#\u0010\u0011\u001a\u001f\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00060\rJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u0006J\u0014\u0010\u0016\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgg/essential/ice/stun/StunMessage$Companion;", "", "()V", "HEADER_SIZE", "", "MAGIC_COOKIE", "", "SOFTWARE", "", "decode", "Lgg/essential/ice/stun/StunMessage;", "bytes", "getServerKey", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "user", "getClientKey", "Lgg/essential/ice/stun/TransactionId;", "tId", "looksLikeStun", "", "padToMultipleOf", "multipleOf", "ice"})
    @SourceDebugExtension(value={"SMAP\nStunMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StunMessage.kt\ngg/essential/ice/stun/StunMessage$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,366:1\n1#2:367\n643#3,5:368\n1549#4:373\n1620#4,3:374\n*S KotlinDebug\n*F\n+ 1 StunMessage.kt\ngg/essential/ice/stun/StunMessage$Companion\n*L\n316#1:368,5\n320#1:373\n320#1:374,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean looksLikeStun(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            if (bytes.length < 20) {
                return false;
            }
            if ((bytes[0] & 0xC0) != 0) {
                return false;
            }
            if ((bytes[3] & 3) != 0) {
                return false;
            }
            return Arrays.equals(ArraysKt.sliceArray((byte[])bytes, (IntRange)RangesKt.until((int)4, (int)8)), MAGIC_COOKIE);
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final StunMessage decode(@NotNull byte[] bytes, @NotNull Function1<? super String, byte[]> getServerKey, @NotNull Function1<? super TransactionId, byte[]> getClientKey) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter(getServerKey, (String)"getServerKey");
            Intrinsics.checkNotNullParameter(getClientKey, (String)"getClientKey");
            typeAndClass = (UByte.constructor-impl((byte)bytes[0]) & 255) << 8 | UByte.constructor-impl((byte)bytes[1]) & 255;
            if ((typeAndClass & 49152) != 0) {
                throw new IOException("First two bits of STUN message must be 0.");
            }
            msgTypeId = (typeAndClass & 15872) >> 2 | (typeAndClass & 224) >> 1 | typeAndClass & 15;
            msgClassId = (typeAndClass & 256) >> 7 | (typeAndClass & 16) >> 4;
            v0 = StunType.Companion.getById().get(msgTypeId);
            if (v0 == null) {
                throw new IOException("Unknown message type " + msgTypeId + '.');
            }
            msgType = v0;
            msgClass = (StunClass)StunClass.getEntries().get(msgClassId);
            if (!msgType.isCompatible(msgClass)) {
                throw new IOException("Message type " + (Object)msgType + " cannot be used with " + (Object)msgClass + '.');
            }
            length = (UByte.constructor-impl((byte)bytes[2]) & 255) << 8 | UByte.constructor-impl((byte)bytes[3]) & 255;
            if (length != this.padToMultipleOf(length, 4)) {
                throw new IOException("Invalid message length, must be multiple of 4 but was " + length + '.');
            }
            if (length > bytes.length - 20) {
                throw new IOException("Invalid message length, was " + length + " but only " + (bytes.length - 20) + " bytes remain.");
            }
            cookie = ArraysKt.sliceArray((byte[])bytes, (IntRange)RangesKt.until((int)4, (int)8));
            if (!Arrays.equals(cookie, StunMessage.access$getMAGIC_COOKIE$cp())) {
                v1 = new StringBuilder().append("Invalid magic cookie value ");
                v2 = Arrays.toString(cookie);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toString(...)");
                throw new IOException(v1.append(v2).toString());
            }
            transactionId = ArraysKt.sliceArray((byte[])bytes, (IntRange)RangesKt.until((int)8, (int)20));
            attributes = new ArrayList<E>();
            offset = new Ref.IntRef();
            offset.element = 20;
            block21: while (offset.element < length + 20) {
                attrType = (UByte.constructor-impl((byte)bytes[offset.element]) & 255) << 8 | UByte.constructor-impl((byte)bytes[offset.element + 1]) & 255;
                attrLength = (UByte.constructor-impl((byte)bytes[offset.element + 2]) & 255) << 8 | UByte.constructor-impl((byte)bytes[offset.element + 3]) & 255;
                offset.element += 4;
                v3 = attributes;
                v4 = StunAttributeType.Companion.getById().get(attrType);
                switch (v4 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v4.ordinal()]) {
                    case 1: {
                        v5 = new StunAttribute.MappedAddress(gg.essential.ice.stun.StunMessage$Companion.decode$decodeXorAddress(transactionId, bytes, offset, new byte[16]));
                        break;
                    }
                    case 2: {
                        v5 = new StunAttribute.XorMappedAddress(gg.essential.ice.stun.StunMessage$Companion.decode$decodeXorAddress$default(transactionId, bytes, offset, null, 8, null));
                        break;
                    }
                    case 3: {
                        if (attrLength > 512) {
                            throw new IOException("Invalid username, too long: " + attrLength);
                        }
                        v5 = new StunAttribute.Username(StringsKt.decodeToString((byte[])ArraysKt.sliceArray((byte[])bytes, (IntRange)RangesKt.until((int)offset.element, (int)(offset.element + attrLength)))));
                        break;
                    }
                    case 4: {
                        verifiedLength = offset.element - 4;
                        verifiedBytes = ArraysKt.sliceArray((byte[])bytes, (IntRange)RangesKt.until((int)0, (int)verifiedLength));
                        storedLength = offset.element + 20;
                        verifiedBytes[2] = (byte)(storedLength - 20 >> 8);
                        verifiedBytes[3] = (byte)(storedLength - 20);
                        if (!msgClass.isResponse()) ** GOTO lbl61
                        v6 = (byte[])getClientKey.invoke((Object)new TransactionId(transactionId));
                        ** GOTO lbl76
lbl61:
                        // 1 sources

                        var22_32 = attributes;
                        var26_40 = v3;
                        for (Object it : var22_32) {
                            $i$a$-firstNotNullOfOrNull-StunMessage$Companion$decode$key$username$1 = false;
                            v7 = it instanceof StunAttribute.Username != false ? (StunAttribute.Username)it : null;
                            it = v7 != null ? v7.getUsername() : null;
                            if (it == null) continue;
                            v8 = it;
                            ** GOTO lbl71
                        }
                        v8 = null;
lbl71:
                        // 2 sources

                        v3 = var26_40;
                        if (v8 == null) {
                            throw new IOException("Integrity protected requests must include a username.");
                        }
                        username = v8;
                        v6 = key = (byte[])getServerKey.invoke(username);
lbl76:
                        // 2 sources

                        if (key == null) {
                            attributes.add(new StunAttribute.MessageIntegrity(null));
                            break block21;
                        }
                        mac = Mac.getInstance("HmacSHA1");
                        mac.init(new SecretKeySpec(key, "HmacSHA1"));
                        mac.update(verifiedBytes);
                        hmac = mac.doFinal();
                        if (!Arrays.equals(hmac, ArraysKt.sliceArray((byte[])bytes, (IntRange)RangesKt.until((int)offset.element, (int)(offset.element + 20))))) {
                            throw new IOException("Invalid HMAC");
                        }
                        attributes.add(new StunAttribute.MessageIntegrity(key));
                        break block21;
                    }
                    case 5: {
                        cls = UByte.constructor-impl((byte)bytes[offset.element + 2]) & 255 & 7;
                        num = UByte.constructor-impl((byte)bytes[offset.element + 3]) & 255;
                        code = cls * 100 + num;
                        mac = StringsKt.decodeToString$default((byte[])bytes, (int)(offset.element + 4), (int)(offset.element + attrLength), (boolean)false, (int)4, null);
                        var26_40 = v3;
                        $i$f$takeWhile = false;
                        var23_33 = $this$takeWhile$iv.length();
                        for (index$iv = 0; index$iv < var23_33; ++index$iv) {
                            it = $this$takeWhile$iv.charAt(index$iv);
                            $i$a$-takeWhile-StunMessage$Companion$decode$message$1 = 0;
                            if (it != '\u0000') continue;
                            it = $this$takeWhile$iv;
                            $i$a$-takeWhile-StunMessage$Companion$decode$message$1 = 0;
                            v9 = it.substring($i$a$-takeWhile-StunMessage$Companion$decode$message$1, index$iv);
                            v10 = v9;
                            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"substring(...)");
                            ** GOTO lbl110
                        }
                        v10 = $this$takeWhile$iv;
lbl110:
                        // 2 sources

                        v3 = var26_40;
                        message = v10;
                        v5 = new StunAttribute.ErrorCode(code, (String)message);
                        break;
                    }
                    case 6: {
                        cls = (Iterable)RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)attrLength)), (int)2);
                        var26_40 = v3;
                        $i$f$map = false;
                        code = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        var21_30 = $this$mapTo$iv$iv.iterator();
                        while (var21_30.hasNext()) {
                            var23_33 = item$iv$iv = ((IntIterator)var21_30).nextInt();
                            var27_41 = destination$iv$iv;
                            $i$a$-map-StunMessage$Companion$decode$1 = false;
                            id = (UByte.constructor-impl((byte)bytes[offset.element + i]) & 255) << 8 | UByte.constructor-impl((byte)bytes[offset.element + i + 1]) & 255;
                            v11 = StunAttributeType.Companion.getById().get(id);
                            if (v11 == null) {
                                throw new IOException("Unknown attribute type " + id);
                            }
                            var27_41.add(v11);
                        }
                        v3 = var26_40;
                        var28_42 = (List)destination$iv$iv;
                        v5 = new StunAttribute.UnknownAttributes(var28_42);
                        break;
                    }
                    case 7: {
                        throw new IOException("CHANNEL-NUMBER decoding not supported");
                    }
                    case 8: {
                        v5 = new StunAttribute.Lifetime(UInt.constructor-impl((int)gg.essential.ice.stun.StunMessage$Companion.decode$decodeInt(bytes, offset)), null);
                        break;
                    }
                    case 9: {
                        v5 = new StunAttribute.XorPeerAddress(gg.essential.ice.stun.StunMessage$Companion.decode$decodeXorAddress$default(transactionId, bytes, offset, null, 8, null));
                        break;
                    }
                    case 10: {
                        v5 = new StunAttribute.Data(ArraysKt.sliceArray((byte[])bytes, (IntRange)RangesKt.until((int)offset.element, (int)(offset.element + attrLength))));
                        break;
                    }
                    case 11: {
                        v5 = new StunAttribute.XorRelayedAddress(gg.essential.ice.stun.StunMessage$Companion.decode$decodeXorAddress$default(transactionId, bytes, offset, null, 8, null));
                        break;
                    }
                    case 12: {
                        throw new IOException("REQUESTED-TRANSPORT decoding not supported");
                    }
                    case 13: {
                        v5 = new StunAttribute.Priority(gg.essential.ice.stun.StunMessage$Companion.decode$decodeInt(bytes, offset));
                        break;
                    }
                    case 14: {
                        v5 = StunAttribute.UseCandidate.INSTANCE;
                        break;
                    }
                    case 15: {
                        v5 = new StunAttribute.Software(StringsKt.decodeToString$default((byte[])bytes, (int)offset.element, (int)(offset.element + attrLength), (boolean)false, (int)4, null));
                        break;
                    }
                    case 16: {
                        v5 = new StunAttribute.TransactionTransmitCounter(bytes[offset.element + 2], bytes[offset.element + 3]);
                        break;
                    }
                    case 17: {
                        v5 = new StunAttribute.IceControlled(ULong.constructor-impl((long)gg.essential.ice.stun.StunMessage$Companion.decode$decodeLong(bytes, offset)), null);
                        break;
                    }
                    case 18: {
                        v5 = new StunAttribute.IceControlling(ULong.constructor-impl((long)gg.essential.ice.stun.StunMessage$Companion.decode$decodeLong(bytes, offset)), null);
                        break;
                    }
                    case -1: {
                        if (StunAttributeType.Companion.isComprehensionRequired(attrType)) {
                            throw new IOException("Unknown attribute type " + attrType);
                        }
                        offset.element += this.padToMultipleOf(attrLength, 4);
                        continue block21;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                v3.add(v5);
                offset.element += this.padToMultipleOf(attrLength, 4);
            }
            return new StunMessage(msgType, msgClass, new TransactionId(transactionId), attributes);
        }

        private final int padToMultipleOf(int $this$padToMultipleOf, int multipleOf) {
            return ($this$padToMultipleOf + multipleOf - 1) / multipleOf * multipleOf;
        }

        private static final InetSocketAddress decode$decodeXorAddress(byte[] transactionId, byte[] $bytes, Ref.IntRef offset, byte[] xorMask) {
            int n;
            int family = UByte.constructor-impl((byte)$bytes[offset.element + 1]) & 0xFF;
            switch (family) {
                case 1: {
                    n = 4;
                    break;
                }
                case 2: {
                    n = 16;
                    break;
                }
                default: {
                    throw new IOException("Unknown address family " + family);
                }
            }
            int addressBytes = n;
            int port = (UByte.constructor-impl((byte)((byte)($bytes[offset.element + 2] ^ xorMask[0]))) & 0xFF) << 8 | UByte.constructor-impl((byte)((byte)($bytes[offset.element + 3] ^ xorMask[1]))) & 0xFF;
            byte[] address = ArraysKt.sliceArray((byte[])$bytes, (IntRange)RangesKt.until((int)(offset.element + 4), (int)(offset.element + 4 + addressBytes)));
            int n2 = address.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                address[i2] = (byte)(address[i2] ^ xorMask[i2]);
            }
            return new InetSocketAddress(InetAddress.getByAddress(address), port);
        }

        static /* synthetic */ InetSocketAddress decode$decodeXorAddress$default(byte[] byArray, byte[] byArray2, Ref.IntRef intRef, byte[] byArray3, int n, Object object) {
            if ((n & 8) != 0) {
                byArray3 = ArraysKt.plus((byte[])MAGIC_COOKIE, (byte[])byArray);
            }
            return gg.essential.ice.stun.StunMessage$Companion.decode$decodeXorAddress(byArray, byArray2, intRef, byArray3);
        }

        private static final int decode$decodeInt(byte[] $bytes, Ref.IntRef offset) {
            return (($bytes[offset.element + 0] << 8 | UByte.constructor-impl((byte)$bytes[offset.element + 1]) & 0xFF) << 8 | UByte.constructor-impl((byte)$bytes[offset.element + 2]) & 0xFF) << 8 | UByte.constructor-impl((byte)$bytes[offset.element + 3]) & 0xFF;
        }

        private static final long decode$decodeLong(byte[] $bytes, Ref.IntRef offset) {
            return (((((((long)$bytes[offset.element + 0] << 8 | (long)UByte.constructor-impl((byte)$bytes[offset.element + 1]) & 0xFFL) << 8 | (long)UByte.constructor-impl((byte)$bytes[offset.element + 2]) & 0xFFL) << 8 | (long)UByte.constructor-impl((byte)$bytes[offset.element + 3]) & 0xFFL) << 8 | (long)UByte.constructor-impl((byte)$bytes[offset.element + 4]) & 0xFFL) << 8 | (long)UByte.constructor-impl((byte)$bytes[offset.element + 5]) & 0xFFL) << 8 | (long)UByte.constructor-impl((byte)$bytes[offset.element + 6]) & 0xFFL) << 8 | (long)UByte.constructor-impl((byte)$bytes[offset.element + 7]) & 0xFFL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[StunAttributeType.values().length];
                try {
                    nArray[StunAttributeType.MappedAddress.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StunAttributeType.XorMappedAddress.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StunAttributeType.Username.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StunAttributeType.MessageIntegrity.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StunAttributeType.ErrorCode.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StunAttributeType.UnknownAttributes.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StunAttributeType.ChannelNumber.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StunAttributeType.Lifetime.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StunAttributeType.XorPeerAddress.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StunAttributeType.Data.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StunAttributeType.XorRelayedAddress.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StunAttributeType.RequestedTransport.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StunAttributeType.Priority.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StunAttributeType.UseCandidate.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StunAttributeType.Software.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StunAttributeType.TransactionTransmitCounter.ordinal()] = 16;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StunAttributeType.IceControlled.ordinal()] = 17;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StunAttributeType.IceControlling.ordinal()] = 18;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

