/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers.discord.activity.provider.impl;

import gg.essential.handlers.discord.DiscordIntegration;
import gg.essential.handlers.discord.activity.ActivityState;
import gg.essential.handlers.discord.activity.provider.ActivityStateProvider;
import gg.essential.util.ServerType;
import gg.essential.util.UUIDUtil;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006R(\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00078\u0002@BX\u0082\u000e\u00a2\u0006\f\n\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lgg/essential/handlers/discord/activity/provider/impl/GameActivityStateProvider;", "Lgg/essential/handlers/discord/activity/provider/ActivityStateProvider;", "<init>", "()V", "Lgg/essential/handlers/discord/activity/ActivityState;", "provide", "()Lgg/essential/handlers/discord/activity/ActivityState;", "Lgg/essential/util/ServerType;", "value", "state", "Lgg/essential/util/ServerType;", "setState", "(Lgg/essential/util/ServerType;)V", "Essential 1.21.7-fabric"})
public final class GameActivityStateProvider
implements ActivityStateProvider {
    @Nullable
    private ServerType state;

    private final void setState(ServerType value) {
        boolean shouldRegenerateKey;
        ServerType castedField = this.state;
        boolean bl = castedField instanceof ServerType.Multiplayer ? !(value instanceof ServerType.Multiplayer) || !Intrinsics.areEqual((Object)((ServerType.Multiplayer)castedField).getAddress(), (Object)((ServerType.Multiplayer)value).getAddress()) : (castedField instanceof ServerType.SPS.Host ? !(value instanceof ServerType.SPS.Host) : (shouldRegenerateKey = false));
        if (shouldRegenerateKey) {
            DiscordIntegration.INSTANCE.regenerateSpsJoinKey();
        }
        this.state = value;
    }

    @Override
    @Nullable
    public ActivityState provide() {
        ActivityState activityState;
        this.setState(ServerType.Companion.current());
        ServerType state2 = this.state;
        if (state2 instanceof ServerType.Singleplayer) {
            activityState = ActivityState.Singleplayer.INSTANCE;
        } else if (state2 instanceof ServerType.Multiplayer) {
            activityState = new ActivityState.Multiplayer(((ServerType.Multiplayer)state2).getAddress());
        } else if (state2 instanceof ServerType.Realms) {
            activityState = ActivityState.Realm.INSTANCE;
        } else if (state2 instanceof ServerType.SPS.Guest) {
            UUID uuid = ((ServerType.SPS.Guest)state2).getHostUuid();
            String username = UUIDUtil.getName(uuid).join();
            Intrinsics.checkNotNull((Object)username);
            activityState = new ActivityState.SPSGuest(username);
        } else if (state2 instanceof ServerType.SPS.Host) {
            activityState = ActivityState.SPSHost.INSTANCE;
        } else if (state2 == null) {
            activityState = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return activityState;
    }
}

