/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.authlib.minecraft.MinecraftProfileTextures;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.ServicesKeyInfo;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.authlib.yggdrasil.ServicesKeyType;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import gg.essential.Essential;
import gg.essential.api.utils.JsonHolder;
import gg.essential.mod.Skin;
import gg.essential.network.connectionmanager.subscription.SubscriptionManager;
import gg.essential.util.UUIDUtil;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.Signature;
import java.util.Base64;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_310;
import sun.misc.Unsafe;

public class GameProfileManager
implements SubscriptionManager.Listener {
    public static final String SKIN_URL = "http://textures.minecraft.net/texture/%s";

    public static GameProfile handleGameProfile(GameProfile profile2, Skin skin) {
        if (skin == null) {
            return null;
        }
        Overwrites overwrites = new Overwrites(skin.getHash(), skin.getModel().getType(), null);
        Property property2 = profile2.getProperties().get((Object)"textures").stream().findFirst().orElse(null);
        if (property2 == null || ManagedTexturesProperty.hasOverwrites(property2, overwrites)) {
            return null;
        }
        return overwrites.apply(profile2);
    }

    public static String getSafeTexturesValue(GameProfile profile2) {
        Iterator textures;
        class_310 mc = class_310.method_1551();
        PropertyMap properties = null;
        try {
            if (!mc.method_1495().getTextures(profile2).equals((Object)MinecraftProfileTextures.EMPTY)) {
                properties = profile2.getProperties();
            }
        }
        catch (InsecurePublicKeyException insecurePublicKeyException) {
        }
        catch (Exception e) {
            Essential.logger.error("Error getting profile textures", (Throwable)e);
        }
        if (properties != null && (textures = properties.get((Object)"textures").iterator()).hasNext()) {
            return ((Property)textures.next()).value();
        }
        return "e30=";
    }

    public static void register(YggdrasilAuthenticationService authenticationService) throws ReflectiveOperationException {
        Field theUnsafeField = Unsafe.class.getDeclaredField("theUnsafe");
        theUnsafeField.setAccessible(true);
        Unsafe unsafe = (Unsafe)theUnsafeField.get(null);
        Field servicesKeySetField = YggdrasilAuthenticationService.class.getDeclaredField("servicesKeySet");
        long servicesKeySetOffset = unsafe.objectFieldOffset(servicesKeySetField);
        ServicesKeySet originalSet = (ServicesKeySet)unsafe.getObject(authenticationService, servicesKeySetOffset);
        ServicesKeySet wrapperSet = type -> {
            if (type != ServicesKeyType.PROFILE_PROPERTY) {
                return originalSet.keys(type);
            }
            return originalSet.keys(type).stream().map(TrustingServicesKeyInfo::new).collect(Collectors.toList());
        };
        unsafe.putObject(authenticationService, servicesKeySetOffset, wrapperSet);
    }

    public static class Overwrites {
        private final String skinHash;
        private final String skinType;
        private final String capeHash;

        public Overwrites(String skinHash, String skinType, String capeHash) {
            this.skinHash = skinHash;
            this.skinType = skinType;
            this.capeHash = capeHash;
        }

        public String apply(String originalValue, UUID id2) {
            String url;
            JsonHolder root = new JsonHolder(new String(Base64.getDecoder().decode(originalValue)));
            if (!root.optString("profileId").isEmpty() && !id2.equals(UUIDUtil.formatWithDashes(root.optString("profileId")))) {
                return originalValue;
            }
            JsonHolder textures = root.optOrCreateJsonHolder("textures");
            if (this.skinHash != null || this.skinType != null) {
                JsonHolder skin = textures.optOrCreateJsonHolder("SKIN");
                if (this.skinHash != null && !(url = skin.optString("url")).endsWith(this.skinHash)) {
                    skin.put("url", String.format(Locale.ROOT, GameProfileManager.SKIN_URL, this.skinHash));
                }
                if (this.skinType != null) {
                    if (this.skinType.equals("default")) {
                        skin.remove("metadata");
                    } else {
                        skin.optOrCreateJsonHolder("metadata").put("model", this.skinType);
                    }
                }
            }
            if (this.capeHash != null) {
                if (this.capeHash.isEmpty()) {
                    textures.remove("CAPE");
                } else {
                    JsonHolder cape = textures.optOrCreateJsonHolder("CAPE");
                    url = cape.optString("url");
                    if (!url.endsWith(this.capeHash)) {
                        cape.put("url", String.format(Locale.ROOT, GameProfileManager.SKIN_URL, this.capeHash));
                    }
                }
            }
            return Base64.getEncoder().encodeToString(root.toString().getBytes(StandardCharsets.UTF_8));
        }

        public GameProfile apply(GameProfile originalProfile) {
            LinkedHashMultimap properties = LinkedHashMultimap.create((Multimap)originalProfile.getProperties());
            properties.removeAll((Object)"textures");
            properties.put((Object)"textures", (Object)ManagedTexturesProperty.create(originalProfile, this));
            GameProfile updatedProfile = new GameProfile(originalProfile.getId(), originalProfile.getName());
            updatedProfile.getProperties().putAll((Multimap)properties);
            return updatedProfile;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Overwrites that = (Overwrites)o;
            return Objects.equals(this.skinHash, that.skinHash) && Objects.equals(this.skinType, that.skinType) && Objects.equals(this.capeHash, that.capeHash);
        }

        public int hashCode() {
            return Objects.hash(this.skinHash, this.skinType, this.capeHash);
        }
    }

    private static class ManagedTexturesProperty {
        private static final Map<Property, Overwrites> INSTANCES = new MapMaker().weakKeys().makeMap();

        private ManagedTexturesProperty() {
        }

        public static Property create(GameProfile originalProfile, Overwrites overwrites) {
            String value = overwrites.apply(GameProfileManager.getSafeTexturesValue(originalProfile), originalProfile.getId());
            Property property2 = new Property("textures", value, "trusted");
            INSTANCES.put(property2, overwrites);
            return property2;
        }

        public static boolean hasOverwrites(Property property2, Overwrites overwrites) {
            return overwrites.equals(INSTANCES.get(property2));
        }
    }

    private record TrustingServicesKeyInfo(ServicesKeyInfo inner) implements ServicesKeyInfo
    {
        public int keyBitCount() {
            return this.inner.keyBitCount();
        }

        public int signatureBitCount() {
            return this.inner.signatureBitCount();
        }

        public Signature signature() {
            return this.inner.signature();
        }

        public boolean validateProperty(Property property2) {
            return ManagedTexturesProperty.INSTANCES.containsKey(property2) || this.inner.validateProperty(property2);
        }
    }
}

