/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Pair;

public class CertChain {
    private final CertificateFactory cf = CertificateFactory.getInstance("X.509");
    private final KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());

    public CertChain() throws Exception {
        InputStream keystoreInputStream = null;
        Path ksPath = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
        keystoreInputStream = Files.newInputStream(ksPath, new OpenOption[0]);
        this.keyStore.load(keystoreInputStream, null);
    }

    public CertChain load(String filename) throws Exception {
        try (InputStream cert = CertChain.class.getResourceAsStream("/assets/essential/certs/" + filename + ".der");){
            BufferedInputStream caInput = new BufferedInputStream(cert);
            Certificate crt = this.cf.generateCertificate(caInput);
            this.keyStore.setCertificateEntry(filename, crt);
        }
        return this;
    }

    public CertChain loadEmbedded() throws Exception {
        return this.load("amazon-root-ca-1").load("baltimore-cybertrust-root").load("d-trust-root-class-3-ca-2-2009").load("digicert-global-root-ca").load("digicert-global-root-g2").load("globalsign-r4").load("gts-root-r1").load("gts-root-r2").load("gts-root-r3").load("gts-root-r4").load("isrgrootx1").load("microsoft-ecc-root-ca-2017").load("microsoft-rsa-root-ca-2017").load("sslcom/Sectigo-AAA-Root").load("sslcom/SSLcom-RootCA-ECC-384-R2").load("sslcom/SSLcom-RootCA-EV-ECC-384-R2").load("sslcom/SSLcom-RootCA-EV-RSA-4096-R2").load("sslcom/SSLcom-RootCA-EV-RSA-4096-R3").load("sslcom/SSLcom-RootCA-RSA-4096-R2").load("sslcom/SSLcom-TLS-Root-2022-ECC").load("sslcom/SSLcom-TLS-Root-2022-RSA").load("sslcom/SSLcomEVRootCertificationAuthorityECC").load("sslcom/SSLcomRootCertificationAuthorityECC").load("sslcom/SSLcomRootCertificationAuthorityRSA");
    }

    public Pair<SSLContext, TrustManager[]> done() throws Exception {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(this.keyStore);
        TrustManager[] trustManagers = tmf.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustManagers, null);
        return new Pair((Object)sslContext, (Object)trustManagers);
    }
}

