/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.friends.state;

import gg.essential.connectionmanager.common.enums.ProfileStatus;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.ReferenceHolderImpl;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.gui.friends.state.IStatusManager;
import gg.essential.gui.friends.state.IStatusStates;
import gg.essential.gui.friends.state.PlayerActivity;
import gg.essential.network.connectionmanager.profile.ProfileManager;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.sps.SpsAddress;
import gg.essential.upnp.model.UPnPSession;
import gg.essential.util.AddressUtil;
import gg.essential.util.EssentialGuiExtensionsKt;
import gg.essential.util.MinecraftUtils;
import gg.essential.util.UUIDUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010 R&\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00110!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lgg/essential/gui/friends/state/StatusStateManagerImpl;", "Lgg/essential/gui/friends/state/IStatusStates;", "Lgg/essential/gui/friends/state/IStatusManager;", "Lgg/essential/network/connectionmanager/profile/ProfileManager;", "profileManager", "Lgg/essential/network/connectionmanager/sps/SPSManager;", "spsManager", "<init>", "(Lgg/essential/network/connectionmanager/profile/ProfileManager;Lgg/essential/network/connectionmanager/sps/SPSManager;)V", "Ljava/util/UUID;", "uuid", "Lgg/essential/gui/friends/state/PlayerActivity;", "getActivity", "(Ljava/util/UUID;)Lgg/essential/gui/friends/state/PlayerActivity;", "Lgg/essential/gui/elementa/state/v2/State;", "getActivityState", "(Ljava/util/UUID;)Lgg/essential/gui/elementa/state/v2/State;", "Lgg/essential/gui/elementa/state/v2/MutableState;", "getWritableState", "(Ljava/util/UUID;)Lgg/essential/gui/elementa/state/v2/MutableState;", "host", "", "haveSpsSession", "(Ljava/util/UUID;)Z", "joinSession", "", "refreshActivity", "(Ljava/util/UUID;)V", "Lgg/essential/network/connectionmanager/profile/ProfileManager;", "Lgg/essential/gui/elementa/state/v2/ReferenceHolderImpl;", "refHolder", "Lgg/essential/gui/elementa/state/v2/ReferenceHolderImpl;", "Lgg/essential/network/connectionmanager/sps/SPSManager;", "", "statesMap", "Ljava/util/Map;", "Essential 1.21.7-fabric"})
@SourceDebugExtension(value={"SMAP\nStatusStateManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatusStateManagerImpl.kt\ngg/essential/gui/friends/state/StatusStateManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1747#2,3:120\n1855#2,2:123\n*S KotlinDebug\n*F\n+ 1 StatusStateManagerImpl.kt\ngg/essential/gui/friends/state/StatusStateManagerImpl\n*L\n45#1:120,3\n106#1:123,2\n*E\n"})
public final class StatusStateManagerImpl
implements IStatusStates,
IStatusManager {
    @NotNull
    private final ProfileManager profileManager;
    @NotNull
    private final SPSManager spsManager;
    @NotNull
    private final ReferenceHolderImpl refHolder;
    @NotNull
    private final Map<UUID, MutableState<PlayerActivity>> statesMap;

    public StatusStateManagerImpl(@NotNull ProfileManager profileManager, @NotNull SPSManager spsManager) {
        Intrinsics.checkNotNullParameter((Object)profileManager, (String)"profileManager");
        Intrinsics.checkNotNullParameter((Object)spsManager, (String)"spsManager");
        this.profileManager = profileManager;
        this.spsManager = spsManager;
        this.refHolder = new ReferenceHolderImpl();
        this.statesMap = new LinkedHashMap();
        this.profileManager.registerStateManager(this);
        this.spsManager.registerStateManager(this);
    }

    private final boolean haveSpsSession(UUID host) {
        boolean bl;
        block3: {
            Collection<UPnPSession> collection = this.spsManager.getRemoteSessions();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getRemoteSessions(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UPnPSession it = (UPnPSession)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getHostUUID(), (Object)host)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public State<PlayerActivity> getActivityState(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return this.getWritableState(uuid);
    }

    @Override
    @NotNull
    public PlayerActivity getActivity(@NotNull UUID uuid) {
        PlayerActivity playerActivity;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        ProfileStatus profileStatus = this.profileManager.getStatus(uuid);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)profileStatus), (String)"getStatus(...)");
        ProfileStatus status2 = profileStatus;
        Pair activity2 = this.profileManager.getActivity(uuid).orElse(null);
        switch (WhenMappings.$EnumSwitchMapping$0[status2.ordinal()]) {
            case 1: {
                playerActivity = new PlayerActivity.Offline(null);
                break;
            }
            case 2: {
                UUID uUID;
                if (activity2 == null) {
                    if (this.haveSpsSession(uuid)) {
                        playerActivity = new PlayerActivity.SPSSession(uuid, true);
                        break;
                    }
                    playerActivity = PlayerActivity.Online.INSTANCE;
                    break;
                }
                String address = (String)activity2.getSecond();
                Intrinsics.checkNotNull((Object)address);
                if (AddressUtil.isSpecialFormattedAddress(address)) {
                    return new PlayerActivity.OnlineWithDescription(address);
                }
                SpsAddress spsAddress = SpsAddress.Companion.parse(address);
                if (spsAddress != null && (uUID = spsAddress.getHost()) != null) {
                    UUID host = uUID;
                    boolean bl = false;
                    return new PlayerActivity.SPSSession(host, this.haveSpsSession(host));
                }
                playerActivity = new PlayerActivity.Multiplayer(address);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return playerActivity;
    }

    @Override
    public boolean joinSession(@NotNull UUID uuid) {
        String string;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        PlayerActivity activity2 = this.getActivity(uuid);
        if (activity2 instanceof PlayerActivity.Multiplayer) {
            string = ((PlayerActivity.Multiplayer)activity2).getServerAddress();
        } else if (activity2 instanceof PlayerActivity.SPSSession && ((PlayerActivity.SPSSession)activity2).getInvited()) {
            string = new SpsAddress(uuid).toString();
        } else {
            return false;
        }
        String address = string;
        CompletableFuture<String> completableFuture = UUIDUtil.getName(uuid);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"getName(...)");
        EssentialGuiExtensionsKt.thenAcceptOnMainThread(completableFuture, (Function1)new Function1<String, Unit>(address){
            final /* synthetic */ String $address;
            {
                this.$address = $address;
                super(1);
            }

            public final void invoke(String it) {
                Intrinsics.checkNotNull((Object)it);
                MinecraftUtils.connectToServer$default(MinecraftUtils.INSTANCE, it, this.$address, null, null, false, 28, null);
            }
        });
        return true;
    }

    private final MutableState<PlayerActivity> getWritableState(UUID uuid) {
        MutableState mutableState2 = this.statesMap.computeIfAbsent(uuid, arg_0 -> StatusStateManagerImpl.getWritableState$lambda$2((Function1)new Function1<UUID, MutableState<PlayerActivity>>(this, uuid){
            final /* synthetic */ StatusStateManagerImpl this$0;
            final /* synthetic */ UUID $uuid;
            {
                this.this$0 = $receiver;
                this.$uuid = $uuid;
                super(1);
            }

            @NotNull
            public final MutableState<PlayerActivity> invoke(@NotNull UUID it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StateKt.mutableStateOf(this.this$0.getActivity(this.$uuid));
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mutableState2, (String)"computeIfAbsent(...)");
        return mutableState2;
    }

    @Override
    public void refreshActivity(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.getWritableState(uuid).set(this.getActivity(uuid));
        Iterable $this$forEach$iv = this.statesMap.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it.getKey(), (Object)uuid)) {
                return;
            }
            PlayerActivity activity2 = (PlayerActivity)((MutableState)it.getValue()).getUntracked();
            if (!(activity2 instanceof PlayerActivity.SPSSession) || !Intrinsics.areEqual((Object)((PlayerActivity.SPSSession)activity2).getHost(), (Object)uuid)) continue;
            this.refreshActivity((UUID)it.getKey());
        }
    }

    private static final MutableState getWritableState$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MutableState)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProfileStatus.values().length];
            try {
                nArray[ProfileStatus.OFFLINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProfileStatus.ONLINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

