/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.elementa.essentialmarkdown.ext.colorattribute.internal;

import gg.essential.elementa.impl.commonmark.node.Node;
import gg.essential.elementa.impl.commonmark.node.Nodes;
import gg.essential.elementa.impl.commonmark.node.SourceSpans;
import gg.essential.elementa.impl.commonmark.node.Text;
import gg.essential.elementa.impl.commonmark.parser.delimiter.DelimiterProcessor;
import gg.essential.elementa.impl.commonmark.parser.delimiter.DelimiterRun;
import gg.essential.gui.elementa.essentialmarkdown.ext.colorattribute.ColorAttribute;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u000f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u0010\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lgg/essential/gui/elementa/essentialmarkdown/ext/colorattribute/internal/ColorAttributeDelimiterProcessor;", "Lgg/essential/elementa/impl/commonmark/parser/delimiter/DelimiterProcessor;", "()V", "closingTag", "", "openingTag", "getClosingCharacter", "", "getMinLength", "", "getOpeningCharacter", "isBraced", "", "node", "Lgg/essential/elementa/impl/commonmark/node/Node;", "isClosingTag", "isOpeningTag", "process", "opener", "Lgg/essential/elementa/impl/commonmark/parser/delimiter/DelimiterRun;", "closer", "essential-gui-elementa"})
@SourceDebugExtension(value={"SMAP\nColorAttributeDelimiterProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorAttributeDelimiterProcessor.kt\ngg/essential/gui/elementa/essentialmarkdown/ext/colorattribute/internal/ColorAttributeDelimiterProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1855#2,2:119\n*S KotlinDebug\n*F\n+ 1 ColorAttributeDelimiterProcessor.kt\ngg/essential/gui/elementa/essentialmarkdown/ext/colorattribute/internal/ColorAttributeDelimiterProcessor\n*L\n83#1:119,2\n*E\n"})
public final class ColorAttributeDelimiterProcessor
implements DelimiterProcessor {
    @NotNull
    private final String openingTag;
    @NotNull
    private final String closingTag;

    public ColorAttributeDelimiterProcessor() {
        this.openingTag = "color:";
        this.closingTag = "color";
    }

    public char getOpeningCharacter() {
        return '{';
    }

    public char getClosingCharacter() {
        return '}';
    }

    public int getMinLength() {
        return 1;
    }

    public int process(@NotNull DelimiterRun opener, @NotNull DelimiterRun closer) {
        Intrinsics.checkNotNullParameter((Object)opener, (String)"opener");
        Intrinsics.checkNotNullParameter((Object)closer, (String)"closer");
        Text openerNode = opener.getOpener();
        Node node = openerNode.getNext();
        Text text2 = node instanceof Text ? (Text)node : null;
        if (text2 == null) {
            return 0;
        }
        Text colorNode = text2;
        String string = colorNode.getLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiteral(...)");
        if (StringsKt.startsWith$default((String)string, (String)this.openingTag, (boolean)false, (int)2, null)) {
            Color color2;
            String string2 = colorNode.getLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLiteral(...)");
            String hexCode = StringsKt.removePrefix((String)string2, (CharSequence)this.openingTag);
            try {
                color2 = Color.decode(hexCode);
            }
            catch (NumberFormatException exception) {
                System.err.println("Invalid color code: " + hexCode);
                return 0;
            }
            Color color3 = color2;
            Intrinsics.checkNotNull((Object)color3);
            Color color4 = color3;
            ColorAttribute colorAttribute = new ColorAttribute(color4);
            SourceSpans sourceSpans = new SourceSpans();
            Node parent = openerNode.getParent();
            Node sibling = openerNode.getPrevious();
            Collection collection = CollectionsKt.listOf((Object)openerNode);
            Iterable iterable = Nodes.between((Node)((Node)openerNode), (Node)parent.getLastChild());
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"between(...)");
            List allNodes = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)iterable), (Iterable)(!Intrinsics.areEqual((Object)parent.getLastChild(), (Object)openerNode) ? CollectionsKt.listOf((Object)parent.getLastChild()) : CollectionsKt.emptyList()));
            int openingColorTags = 0;
            List nodesToColor = new ArrayList();
            for (Node node2 : allNodes) {
                Intrinsics.checkNotNull((Object)node2);
                nodesToColor.add(node2);
                sourceSpans.addAll(node2.getSourceSpans());
                if (!Intrinsics.areEqual((Object)node2, (Object)colorNode) && this.isOpeningTag(node2)) {
                    ++openingColorTags;
                }
                if (!this.isClosingTag(node2.getPrevious())) continue;
                if (openingColorTags == 0) break;
                --openingColorTags;
            }
            if (openingColorTags > 0) {
                return 0;
            }
            colorAttribute.setSourceSpans(sourceSpans.getSourceSpans());
            Iterable $this$forEach$iv = nodesToColor;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Node it = (Node)element$iv;
                boolean bl = false;
                colorAttribute.appendChild(it);
            }
            colorNode.unlink();
            if (sibling == null) {
                parent.prependChild((Node)colorAttribute);
            } else {
                sibling.insertAfter((Node)colorAttribute);
            }
            return 1;
        }
        if (this.isClosingTag((Node)colorNode)) {
            colorNode.unlink();
            return 1;
        }
        return 0;
    }

    private final boolean isBraced(Node node) {
        Node node2 = node;
        Node node3 = node2 != null ? node2.getPrevious() : null;
        Text text2 = node3 instanceof Text ? (Text)node3 : null;
        if (text2 == null) {
            return false;
        }
        Text previous = text2;
        Node node4 = node.getNext();
        Text text3 = node4 instanceof Text ? (Text)node4 : null;
        if (text3 == null) {
            return false;
        }
        Text next = text3;
        return Intrinsics.areEqual((Object)previous.getLiteral(), (Object)"{") && Intrinsics.areEqual((Object)next.getLiteral(), (Object)"}");
    }

    private final boolean isOpeningTag(Node node) {
        Object object = node instanceof Text ? (Text)node : null;
        return (object != null && (object = object.getLiteral()) != null ? StringsKt.startsWith$default((String)object, (String)this.openingTag, (boolean)false, (int)2, null) : false) && this.isBraced(node);
    }

    private final boolean isClosingTag(Node node) {
        Text text2 = node instanceof Text ? (Text)node : null;
        return Intrinsics.areEqual((Object)(text2 != null ? text2.getLiteral() : null), (Object)this.closingTag) && this.isBraced(node);
    }
}

