/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.account;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import gg.essential.handlers.account.WebAccountManager;
import gg.essential.lib.gson.Gson;
import gg.essential.lib.gson.GsonBuilder;
import gg.essential.lib.gson.JsonDeserializationContext;
import gg.essential.lib.gson.JsonDeserializer;
import gg.essential.lib.gson.JsonElement;
import gg.essential.lib.gson.JsonObject;
import gg.essential.lib.gson.JsonPrimitive;
import gg.essential.lib.gson.JsonSerializationContext;
import gg.essential.lib.gson.JsonSerializer;
import gg.essential.lib.gson.annotations.JsonAdapter;
import gg.essential.lib.okhttp3.FormBody;
import gg.essential.lib.okhttp3.MediaType;
import gg.essential.lib.okhttp3.Request;
import gg.essential.lib.okhttp3.RequestBody;
import gg.essential.lib.okhttp3.Response;
import gg.essential.lib.okhttp3.ResponseBody;
import gg.essential.util.HttpUtils;
import gg.essential.util.UUIDUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u0000 R2\u00020\u0001:\u0003RSTB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\f\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ%\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0012\u001a\u00020\u00112\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0015\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\u0014\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u000bJ\u0017\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u0018\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\u0014\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u000bJ3\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00192\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\u0014\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ#\u0010\u001e\u001a\u00020\t2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ1\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\t0\u00192\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b \u0010\u001bJ!\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b$\u0010%J\r\u0010'\u001a\u00020&\u00a2\u0006\u0004\b'\u0010\u0003JR\u00100\u001a\u00028\u0001\"\u0004\b\u0000\u0010(\"\u0004\b\u0001\u0010)*\u00020\u00072\u000e\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000*2!\u0010/\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b-\u0012\b\b.\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00028\u00010,H\u0002\u00a2\u0006\u0004\b0\u00101J\u0015\u00103\u001a\u0004\u0018\u00010#*\u000202H\u0002\u00a2\u0006\u0004\b3\u00104J9\u00108\u001a\u00020&*\u0004\u0018\u0001052!\u00107\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b-\u0012\b\b.\u0012\u0004\b\b(6\u0012\u0004\u0012\u00020&0,H\u0082\b\u00a2\u0006\u0004\b8\u00109J\u001b\u0010;\u001a\n :*\u0004\u0018\u00010\t0\t*\u00020\tH\u0002\u00a2\u0006\u0004\b;\u0010<R\u0018\u0010=\u001a\u0004\u0018\u0001058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u0013\u0010B\u001a\u0004\u0018\u00010?8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0018\u0010C\u001a\u0004\u0018\u0001058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bC\u0010>R$\u0010D\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bD\u0010E\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u0018\u0010J\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010KR\u0018\u0010L\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bL\u0010MR\u0018\u0010N\u001a\u0004\u0018\u0001058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\bN\u0010>R\u0018\u0010O\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bO\u0010MR\u0018\u0010P\u001a\u0004\u0018\u0001058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bP\u0010>R\u0018\u0010Q\u001a\u0004\u0018\u0001058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bQ\u0010>\u00a8\u0006U"}, d2={"Lgg/essential/gui/account/MicrosoftUserAuthentication;", "", "<init>", "()V", "Ljava/util/concurrent/CompletableFuture;", "Ljava/net/URI;", "future", "", "forceRefresh", "", "acquireAccessToken", "(Ljava/util/concurrent/CompletableFuture;Z)Ljava/lang/String;", "acquireAccessTokenViaOAuth", "(Ljava/util/concurrent/CompletableFuture;)Ljava/lang/String;", "codeVerifier", "acquireAuthorizationCode", "(Ljava/lang/String;Ljava/util/concurrent/CompletableFuture;)Ljava/lang/String;", "Lcom/mojang/authlib/GameProfile;", "acquireGameProfile", "(Ljava/util/concurrent/CompletableFuture;)Lcom/mojang/authlib/GameProfile;", "retry", "acquireMCToken", "acquireUri", "(Ljava/lang/String;)Ljava/net/URI;", "acquireXBLToken", "Lkotlin/Pair;", "acquireXSTSToken", "(Ljava/util/concurrent/CompletableFuture;Z)Lkotlin/Pair;", "", "props", "fetchAccessToken", "(Ljava/util/Map;)Ljava/lang/String;", "logIn", "uri", "content", "Lgg/essential/lib/gson/JsonObject;", "post", "(Ljava/lang/String;Ljava/lang/Object;)Lgg/essential/lib/gson/JsonObject;", "", "refreshRefreshToken", "P", "T", "Lkotlin/reflect/KMutableProperty0;", "invalidToken", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "func", "attempt", "(ZLkotlin/reflect/KMutableProperty0;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lgg/essential/lib/okhttp3/Request;", "execute", "(Lokhttp3/Request;)Lgg/essential/lib/gson/JsonObject;", "Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;", "token", "block", "ifValid", "(Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;Lkotlin/jvm/functions/Function1;)V", "kotlin.jvm.PlatformType", "urlEncode", "(Ljava/lang/String;)Ljava/lang/String;", "accessToken", "Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;", "Ljava/time/Instant;", "getExpiryTime", "()Ljava/time/Instant;", "expiryTime", "mcToken", "openUri", "Ljava/net/URI;", "getOpenUri", "()Ljava/net/URI;", "setOpenUri", "(Ljava/net/URI;)V", "profile", "Lcom/mojang/authlib/GameProfile;", "redirectUri", "Ljava/lang/String;", "refreshToken", "uhs", "xblToken", "xstsToken", "Companion", "LegacyTokenSerializer", "Token", "Essential 1.21.7-fabric"})
@SourceDebugExtension(value={"SMAP\nMicrosoftUserAuthentication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MicrosoftUserAuthentication.kt\ngg/essential/gui/account/MicrosoftUserAuthentication\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,323:1\n306#1,4:324\n306#1,4:335\n306#1,4:339\n306#1,4:343\n1#2:328\n125#3:329\n152#3,3:330\n215#3,2:333\n*S KotlinDebug\n*F\n+ 1 MicrosoftUserAuthentication.kt\ngg/essential/gui/account/MicrosoftUserAuthentication\n*L\n90#1:324,4\n170#1:335,4\n193#1:339,4\n217#1:343,4\n141#1:329\n141#1:330,3\n152#1:333,2\n*E\n"})
public final class MicrosoftUserAuthentication {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String redirectUri;
    @Nullable
    private Token accessToken;
    @JsonAdapter(value=LegacyTokenSerializer.class)
    @Nullable
    private Token refreshToken;
    @Nullable
    private Token xblToken;
    @Nullable
    private Token xstsToken;
    @Nullable
    private String uhs;
    @Nullable
    private Token mcToken;
    @Nullable
    private GameProfile profile;
    @Nullable
    private URI openUri;
    private static final boolean DEBUG = false;
    @NotNull
    public static final String CLIENT_ID = "e39cc675-eb52-4475-b5f8-82aaae14eeba";
    @NotNull
    private static final String SCOPE = "Xboxlive.signin Xboxlive.offline_access";
    @NotNull
    private static final String URL_OAUTH_START = "https://login.live.com/oauth20_authorize.srf";
    @NotNull
    private static final String URL_OAUTH_TOKEN = "https://login.live.com/oauth20_token.srf";
    @NotNull
    private static final String URL_XBL = "https://user.auth.xboxlive.com/user/authenticate";
    @NotNull
    private static final String URL_XSTS = "https://xsts.auth.xboxlive.com/xsts/authorize";
    @NotNull
    private static final String URL_MINECRAFT = "https://api.minecraftservices.com/authentication/login_with_xbox";
    @NotNull
    private static final String URL_PROFILE = "https://api.minecraftservices.com/minecraft/profile";
    @Nullable
    private static final MediaType JSON = MediaType.parse("application/json");

    @Nullable
    public final Instant getExpiryTime() {
        Token token = this.refreshToken;
        return token != null ? token.getExpires() : null;
    }

    @Nullable
    public final URI getOpenUri() {
        return this.openUri;
    }

    public final void setOpenUri(@Nullable URI uRI) {
        this.openUri = uRI;
    }

    @NotNull
    public final Pair<GameProfile, String> logIn(@NotNull CompletableFuture<URI> future2, boolean forceRefresh) {
        Intrinsics.checkNotNullParameter(future2, (String)"future");
        if (forceRefresh) {
            this.mcToken = null;
        }
        GameProfile profile2 = this.acquireGameProfile(future2);
        String token = MicrosoftUserAuthentication.acquireMCToken$default(this, future2, false, 2, null);
        return new Pair((Object)profile2, (Object)token);
    }

    public static /* synthetic */ Pair logIn$default(MicrosoftUserAuthentication microsoftUserAuthentication, CompletableFuture completableFuture, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return microsoftUserAuthentication.logIn(completableFuture, bl);
    }

    public final void refreshRefreshToken() {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        this.acquireAccessToken(completableFuture, true);
    }

    private final String acquireAccessToken(CompletableFuture<URI> future2, boolean forceRefresh) {
        if (!forceRefresh) {
            MicrosoftUserAuthentication microsoftUserAuthentication = this;
            Token $this$ifValid$iv = this.accessToken;
            boolean $i$f$ifValid = false;
            if ($this$ifValid$iv != null && !$this$ifValid$iv.getExpired()) {
                String it = $this$ifValid$iv.getValue();
                boolean bl = false;
                return it;
            }
        }
        Token token = this.refreshToken;
        if (token == null) {
            return this.acquireAccessTokenViaOAuth(future2);
        }
        Token refreshToken = token;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"grant_type", (Object)"refresh_token"), TuplesKt.to((Object)"refresh_token", (Object)refreshToken.getValue())};
        return this.fetchAccessToken(MapsKt.mapOf((Pair[])pairArray));
    }

    private final String acquireAccessTokenViaOAuth(CompletableFuture<URI> future2) {
        byte[] byArray;
        byte[] it = byArray = new byte[32];
        boolean bl = false;
        new SecureRandom().nextBytes(it);
        String codeVerifier = Base64.encodeBase64URLSafeString((byte[])byArray);
        Intrinsics.checkNotNull((Object)codeVerifier);
        String code = this.acquireAuthorizationCode(codeVerifier, future2);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"code_verifier", (Object)codeVerifier), TuplesKt.to((Object)"grant_type", (Object)"authorization_code"), TuplesKt.to((Object)"code", (Object)code)};
        return this.fetchAccessToken(MapsKt.mapOf((Pair[])pairArray));
    }

    private final String acquireAuthorizationCode(String codeVerifier, CompletableFuture<URI> future2) {
        this.redirectUri = WebAccountManager.INSTANCE.getMicrosoftRedirectUri();
        URI uri = this.acquireUri(codeVerifier);
        if (future2.isDone()) {
            throw new InvalidCredentialsException("Re-authentication with Microsoft required");
        }
        future2.complete(uri);
        this.openUri = uri;
        CompletableFuture<String> completableFuture = WebAccountManager.INSTANCE.getAuthorizationCodeFuture();
        String string = completableFuture != null ? completableFuture.join() : null;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final URI acquireUri(String codeVerifier) {
        void $this$mapTo$iv$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"client_id", (Object)CLIENT_ID), TuplesKt.to((Object)"prompt", (Object)"select_account"), TuplesKt.to((Object)"scope", (Object)SCOPE), TuplesKt.to((Object)"code_challenge_method", (Object)"S256"), TuplesKt.to((Object)"code_challenge", (Object)Base64.encodeBase64URLSafeString((byte[])DigestUtils.sha256((String)codeVerifier))), TuplesKt.to((Object)"response_type", (Object)"code"), TuplesKt.to((Object)"redirect_uri", (Object)this.redirectUri)};
        Map $this$map$iv = MapsKt.mapOf((Pair[])pairArray);
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            String value;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String key = (String)entry2.getKey();
            String string = value = (String)entry2.getValue();
            collection.add(key + "=" + (string != null ? this.urlEncode(string) : null));
        }
        String string = "https://login.live.com/oauth20_authorize.srf?" + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        return new URI(string);
    }

    private final String fetchAccessToken(Map<String, String> props) {
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"client_id", (Object)CLIENT_ID);
        pairArray[1] = TuplesKt.to((Object)"scope", (Object)SCOPE);
        String string = this.redirectUri;
        if (string == null) {
            string = "";
        }
        pairArray[2] = TuplesKt.to((Object)"redirect_uri", (Object)string);
        Map fullProps = MapsKt.plus(props, (Map)MapsKt.mapOf((Pair[])pairArray));
        FormBody.Builder formBody = new FormBody.Builder();
        Map $this$forEach$iv = fullProps;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry2 = element$iv = iterator2.next();
            boolean bl = false;
            String key = (String)entry2.getKey();
            String value = (String)entry2.getValue();
            formBody.add(key, value);
        }
        Request request2 = new Request.Builder().url(URL_OAUTH_TOKEN).header("Content-Type", "application/x-www-form-urlencoded").post(formBody.build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)request2, (String)"build(...)");
        JsonObject jsonObject = this.execute(request2);
        if (jsonObject == null) {
            throw new InvalidCredentialsException();
        }
        JsonObject response2 = jsonObject;
        String accessToken = response2.get("access_token").getAsString();
        String refreshToken = response2.get("refresh_token").getAsString();
        long expiresIn = response2.get("expires_in").getAsLong();
        Intrinsics.checkNotNull((Object)accessToken);
        Instant instant = Instant.now().plus(Duration.ofSeconds(expiresIn));
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
        this.accessToken = new Token(accessToken, instant);
        Intrinsics.checkNotNull((Object)refreshToken);
        Instant instant2 = Instant.now().plus(Duration.ofDays(90L));
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"plus(...)");
        this.refreshToken = new Token(refreshToken, instant2);
        return accessToken;
    }

    private final String acquireXBLToken(CompletableFuture<URI> future2, boolean retry) {
        MicrosoftUserAuthentication microsoftUserAuthentication = this;
        Token $this$ifValid$iv = this.xblToken;
        boolean $i$f$ifValid = false;
        if ($this$ifValid$iv != null && !$this$ifValid$iv.getExpired()) {
            String it = $this$ifValid$iv.getValue();
            boolean bl = false;
            return it;
        }
        String accessToken = this.acquireAccessToken(future2, false);
        Pair[] it = new Pair[3];
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"AuthMethod", (Object)"RPS"), TuplesKt.to((Object)"SiteName", (Object)"user.auth.xboxlive.com"), TuplesKt.to((Object)"RpsTicket", (Object)("d=" + accessToken))};
        it[0] = TuplesKt.to((Object)"Properties", (Object)MapsKt.mapOf((Pair[])pairArray));
        it[1] = TuplesKt.to((Object)"RelyingParty", (Object)"http://auth.xboxlive.com");
        it[2] = TuplesKt.to((Object)"TokenType", (Object)"JWT");
        JsonObject jsonObject = this.post(URL_XBL, MapsKt.mapOf((Pair[])it));
        if (jsonObject == null) {
            return (String)this.attempt(retry, (KMutableProperty0)new MutablePropertyReference0Impl(this){

                @Nullable
                public Object get() {
                    return MicrosoftUserAuthentication.access$getAccessToken$p((MicrosoftUserAuthentication)this.receiver);
                }

                public void set(@Nullable Object value) {
                    MicrosoftUserAuthentication.access$setAccessToken$p((MicrosoftUserAuthentication)this.receiver, (Token)value);
                }
            }, (Function1)new Function1<Boolean, String>(this, future2){
                final /* synthetic */ MicrosoftUserAuthentication this$0;
                final /* synthetic */ CompletableFuture<URI> $future;
                {
                    this.this$0 = $receiver;
                    this.$future = $future;
                    super(1);
                }

                @NotNull
                public final String invoke(boolean it) {
                    return MicrosoftUserAuthentication.access$acquireXBLToken(this.this$0, this.$future, it);
                }
            });
        }
        JsonObject response2 = jsonObject;
        String token = response2.get("Token").getAsString();
        Instant expires = Instant.parse(response2.get("NotAfter").getAsString());
        Intrinsics.checkNotNull((Object)token);
        Intrinsics.checkNotNull((Object)expires);
        this.xblToken = new Token(token, expires);
        return token;
    }

    static /* synthetic */ String acquireXBLToken$default(MicrosoftUserAuthentication microsoftUserAuthentication, CompletableFuture completableFuture, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return microsoftUserAuthentication.acquireXBLToken(completableFuture, bl);
    }

    private final Pair<String, String> acquireXSTSToken(CompletableFuture<URI> future2, boolean retry) {
        MicrosoftUserAuthentication microsoftUserAuthentication = this;
        Token $this$ifValid$iv = this.xstsToken;
        boolean $i$f$ifValid = false;
        if ($this$ifValid$iv != null && !$this$ifValid$iv.getExpired()) {
            String it = $this$ifValid$iv.getValue();
            boolean bl = false;
            String string = this.uhs;
            Intrinsics.checkNotNull((Object)string);
            return new Pair((Object)it, (Object)string);
        }
        String xblToken = MicrosoftUserAuthentication.acquireXBLToken$default(this, future2, false, 2, null);
        Pair[] it = new Pair[3];
        Pair[] bl = new Pair[]{TuplesKt.to((Object)"SandboxId", (Object)"RETAIL"), TuplesKt.to((Object)"UserTokens", (Object)CollectionsKt.listOf((Object)xblToken))};
        it[0] = TuplesKt.to((Object)"Properties", (Object)MapsKt.mapOf((Pair[])bl));
        it[1] = TuplesKt.to((Object)"RelyingParty", (Object)"rp://api.minecraftservices.com/");
        it[2] = TuplesKt.to((Object)"TokenType", (Object)"JWT");
        JsonObject jsonObject = this.post(URL_XSTS, MapsKt.mapOf((Pair[])it));
        if (jsonObject == null) {
            return (Pair)this.attempt(retry, (KMutableProperty0)new MutablePropertyReference0Impl(this){

                @Nullable
                public Object get() {
                    return MicrosoftUserAuthentication.access$getXblToken$p((MicrosoftUserAuthentication)this.receiver);
                }

                public void set(@Nullable Object value) {
                    MicrosoftUserAuthentication.access$setXblToken$p((MicrosoftUserAuthentication)this.receiver, (Token)value);
                }
            }, (Function1)new Function1<Boolean, Pair<? extends String, ? extends String>>(this, future2){
                final /* synthetic */ MicrosoftUserAuthentication this$0;
                final /* synthetic */ CompletableFuture<URI> $future;
                {
                    this.this$0 = $receiver;
                    this.$future = $future;
                    super(1);
                }

                @NotNull
                public final Pair<String, String> invoke(boolean it) {
                    return MicrosoftUserAuthentication.access$acquireXSTSToken(this.this$0, this.$future, it);
                }
            });
        }
        JsonObject response2 = jsonObject;
        String token = response2.get("Token").getAsString();
        Instant expires = Instant.parse(response2.get("NotAfter").getAsString());
        String uhs = response2.get("DisplayClaims").getAsJsonObject().get("xui").getAsJsonArray().get(0).getAsJsonObject().get("uhs").getAsString();
        Intrinsics.checkNotNull((Object)token);
        Intrinsics.checkNotNull((Object)expires);
        this.xstsToken = new Token(token, expires);
        this.uhs = uhs;
        return new Pair((Object)token, (Object)uhs);
    }

    static /* synthetic */ Pair acquireXSTSToken$default(MicrosoftUserAuthentication microsoftUserAuthentication, CompletableFuture completableFuture, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return microsoftUserAuthentication.acquireXSTSToken(completableFuture, bl);
    }

    private final String acquireMCToken(CompletableFuture<URI> future2, boolean retry) {
        MicrosoftUserAuthentication microsoftUserAuthentication = this;
        Token $this$ifValid$iv = this.mcToken;
        boolean $i$f$ifValid = false;
        if ($this$ifValid$iv != null && !$this$ifValid$iv.getExpired()) {
            String it = $this$ifValid$iv.getValue();
            boolean bl = false;
            return it;
        }
        microsoftUserAuthentication = MicrosoftUserAuthentication.acquireXSTSToken$default(this, future2, false, 2, null);
        String xstsToken = (String)microsoftUserAuthentication.component1();
        String uhs = (String)microsoftUserAuthentication.component2();
        JsonObject jsonObject = this.post(URL_MINECRAFT, MapsKt.mapOf((Pair)TuplesKt.to((Object)"identityToken", (Object)("XBL3.0 x=" + uhs + ";" + xstsToken))));
        if (jsonObject == null) {
            return (String)this.attempt(retry, (KMutableProperty0)new MutablePropertyReference0Impl(this){

                @Nullable
                public Object get() {
                    return MicrosoftUserAuthentication.access$getXstsToken$p((MicrosoftUserAuthentication)this.receiver);
                }

                public void set(@Nullable Object value) {
                    MicrosoftUserAuthentication.access$setXstsToken$p((MicrosoftUserAuthentication)this.receiver, (Token)value);
                }
            }, (Function1)new Function1<Boolean, String>(this, future2){
                final /* synthetic */ MicrosoftUserAuthentication this$0;
                final /* synthetic */ CompletableFuture<URI> $future;
                {
                    this.this$0 = $receiver;
                    this.$future = $future;
                    super(1);
                }

                @NotNull
                public final String invoke(boolean it) {
                    return MicrosoftUserAuthentication.access$acquireMCToken(this.this$0, this.$future, it);
                }
            });
        }
        JsonObject response2 = jsonObject;
        String token = response2.get("access_token").getAsString();
        long expiresIn = response2.get("expires_in").getAsLong();
        Intrinsics.checkNotNull((Object)token);
        Instant instant = Instant.now().plus(Duration.ofSeconds(expiresIn));
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
        this.mcToken = new Token(token, instant);
        this.profile = null;
        return token;
    }

    static /* synthetic */ String acquireMCToken$default(MicrosoftUserAuthentication microsoftUserAuthentication, CompletableFuture completableFuture, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return microsoftUserAuthentication.acquireMCToken(completableFuture, bl);
    }

    private final GameProfile acquireGameProfile(CompletableFuture<URI> future2) {
        GameProfile profile2;
        String it2;
        String token = MicrosoftUserAuthentication.acquireMCToken$default(this, future2, false, 2, null);
        GameProfile gameProfile2 = this.profile;
        if (gameProfile2 != null) {
            GameProfile it2 = gameProfile2;
            boolean bl = false;
            return it2;
        }
        Request request2 = new Request.Builder().url(URL_PROFILE).header("Authorization", "Bearer " + token).get().build();
        Intrinsics.checkNotNullExpressionValue((Object)request2, (String)"build(...)");
        JsonObject jsonObject = this.execute(request2);
        if (jsonObject == null) {
            throw new InvalidCredentialsException();
        }
        JsonObject response2 = jsonObject;
        JsonElement jsonElement = response2.get("error");
        if (jsonElement != null && (it2 = jsonElement.getAsString()) != null) {
            String it3 = it2;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it3, (Object)"NOT_FOUND")) {
                throw new InvalidCredentialsException("This account does not own Minecraft");
            }
            System.out.println((Object)new Gson().toJson(response2));
            throw new IOException(response2.get("errorMessage").getAsString());
        }
        UUID uuid = UUIDUtil.formatWithDashes(response2.get("id").getAsString());
        String name2 = response2.get("name").getAsString();
        this.profile = profile2 = new GameProfile(uuid, name2);
        return profile2;
    }

    private final JsonObject post(String uri, Object content) {
        Request request2 = new Request.Builder().url(uri).post(RequestBody.create(JSON, new Gson().toJson(content))).build();
        Intrinsics.checkNotNull((Object)request2);
        return this.execute(request2);
    }

    private final JsonObject execute(Request $this$execute) {
        JsonObject json2;
        Response response2 = HttpUtils.getHttpClient().join().newCall($this$execute.newBuilder().header("Accept", "application/json").build()).execute();
        int status2 = response2.code();
        ResponseBody responseBody = response2.body();
        Intrinsics.checkNotNull((Object)responseBody);
        String content = responseBody.string();
        if (status2 >= 300) {
            System.out.println((Object)(status2 + ": " + content));
        }
        if ((json2 = new Gson().fromJson(content, JsonObject.class)).has("error")) {
            System.out.println((Object)new GsonBuilder().setPrettyPrinting().create().toJson(json2));
        }
        return switch (status2) {
            case 400, 401, 429 -> null;
            default -> json2;
        };
    }

    private final String urlEncode(String $this$urlEncode) {
        return URLEncoder.encode($this$urlEncode, "utf-8");
    }

    private final <P, T> T attempt(boolean $this$attempt, KMutableProperty0<P> invalidToken, Function1<? super Boolean, ? extends T> func) {
        if (!$this$attempt) {
            throw new AuthenticationUnavailableException();
        }
        invalidToken.set(null);
        return (T)func.invoke((Object)false);
    }

    private final void ifValid(Token $this$ifValid, Function1<? super String, Unit> block) {
        boolean $i$f$ifValid = false;
        if ($this$ifValid != null && !$this$ifValid.getExpired()) {
            block.invoke((Object)$this$ifValid.getValue());
        }
    }

    public static final /* synthetic */ Token access$getAccessToken$p(MicrosoftUserAuthentication $this) {
        return $this.accessToken;
    }

    public static final /* synthetic */ void access$setAccessToken$p(MicrosoftUserAuthentication $this, Token token) {
        $this.accessToken = token;
    }

    public static final /* synthetic */ String access$acquireXBLToken(MicrosoftUserAuthentication $this, CompletableFuture future2, boolean retry) {
        return $this.acquireXBLToken(future2, retry);
    }

    public static final /* synthetic */ Token access$getXblToken$p(MicrosoftUserAuthentication $this) {
        return $this.xblToken;
    }

    public static final /* synthetic */ void access$setXblToken$p(MicrosoftUserAuthentication $this, Token token) {
        $this.xblToken = token;
    }

    public static final /* synthetic */ Pair access$acquireXSTSToken(MicrosoftUserAuthentication $this, CompletableFuture future2, boolean retry) {
        return $this.acquireXSTSToken(future2, retry);
    }

    public static final /* synthetic */ Token access$getXstsToken$p(MicrosoftUserAuthentication $this) {
        return $this.xstsToken;
    }

    public static final /* synthetic */ void access$setXstsToken$p(MicrosoftUserAuthentication $this, Token token) {
        $this.xstsToken = token;
    }

    public static final /* synthetic */ String access$acquireMCToken(MicrosoftUserAuthentication $this, CompletableFuture future2, boolean retry) {
        return $this.acquireMCToken(future2, retry);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0006R\u0014\u0010\u000e\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0006R\u0014\u0010\u0010\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0006R\u0014\u0010\u0012\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lgg/essential/gui/account/MicrosoftUserAuthentication$Companion;", "", "<init>", "()V", "", "CLIENT_ID", "Ljava/lang/String;", "", "DEBUG", "Z", "Lgg/essential/lib/okhttp3/MediaType;", "JSON", "Lgg/essential/lib/okhttp3/MediaType;", "SCOPE", "URL_MINECRAFT", "URL_OAUTH_START", "URL_OAUTH_TOKEN", "URL_PROFILE", "URL_XBL", "URL_XSTS", "Essential 1.21.7-fabric"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lgg/essential/gui/account/MicrosoftUserAuthentication$LegacyTokenSerializer;", "Lgg/essential/lib/gson/JsonSerializer;", "Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;", "Lgg/essential/lib/gson/JsonDeserializer;", "<init>", "()V", "Lgg/essential/lib/gson/JsonElement;", "json", "Ljava/lang/reflect/Type;", "typeOfT", "Lgg/essential/lib/gson/JsonDeserializationContext;", "context", "deserialize", "(Lgg/essential/lib/gson/JsonElement;Ljava/lang/reflect/Type;Lgg/essential/lib/gson/JsonDeserializationContext;)Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;", "src", "typeOfSrc", "Lgg/essential/lib/gson/JsonSerializationContext;", "serialize", "(Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;Ljava/lang/reflect/Type;Lgg/essential/lib/gson/JsonSerializationContext;)Lgg/essential/lib/gson/JsonElement;", "Essential 1.21.7-fabric"})
    private static final class LegacyTokenSerializer
    implements JsonSerializer<Token>,
    JsonDeserializer<Token> {
        @Override
        @NotNull
        public Token deserialize(@NotNull JsonElement json2, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
            Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (json2 instanceof JsonPrimitive) {
                String string = ((JsonPrimitive)json2).getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
                Instant instant = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
                token = new Token(string, instant);
            } else {
                Object t = context.deserialize(json2, (Type)((Object)Token.class));
                Intrinsics.checkNotNullExpressionValue(t, (String)"deserialize(...)");
                token = (Token)t;
            }
            return token;
        }

        @Override
        @NotNull
        public JsonElement serialize(@NotNull Token src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            JsonElement jsonElement = context.serialize(src);
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"serialize(...)");
            return jsonElement;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\tR\u0011\u0010\u0018\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001a\u0010\u000bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\t\u00a8\u0006\u001d"}, d2={"Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;", "", "", "value", "Ljava/time/Instant;", "expires", "<init>", "(Ljava/lang/String;Ljava/time/Instant;)V", "component1", "()Ljava/lang/String;", "component2", "()Ljava/time/Instant;", "copy", "(Ljava/lang/String;Ljava/time/Instant;)Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "getExpired", "()Z", "expired", "Ljava/time/Instant;", "getExpires", "Ljava/lang/String;", "getValue", "Essential 1.21.7-fabric"})
    public static final class Token {
        @NotNull
        private final String value;
        @NotNull
        private final Instant expires;

        public Token(@NotNull String value, @NotNull Instant expires) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)expires, (String)"expires");
            this.value = value;
            this.expires = expires;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final Instant getExpires() {
            return this.expires;
        }

        public final boolean getExpired() {
            return this.expires.isBefore(Instant.now());
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @NotNull
        public final Instant component2() {
            return this.expires;
        }

        @NotNull
        public final Token copy(@NotNull String value, @NotNull Instant expires) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)expires, (String)"expires");
            return new Token(value, expires);
        }

        public static /* synthetic */ Token copy$default(Token token, String string, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                string = token.value;
            }
            if ((n & 2) != 0) {
                instant = token.expires;
            }
            return token.copy(string, instant);
        }

        @NotNull
        public String toString() {
            return "Token(value=" + this.value + ", expires=" + this.expires + ")";
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = result * 31 + this.expires.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            Token token = (Token)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)token.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.expires, (Object)token.expires);
        }
    }
}

