/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2.jij;

import gg.essential.loader.stage2.data.FabricModJson;
import gg.essential.loader.stage2.jij.SyntheticModJar;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JarInJarDependenciesHandler {
    private static final Logger LOGGER;
    private static final String SYNTHETIC_MOD_ID = "essential-dependencies";
    private static final String SYNTHETIC_MOD_NAME = "Essential Dependencies";
    private static final String SYNTHETIC_MOD_FILE_NAME = "Essential Dependencies.jar";
    private static final boolean NEED_TO_DISABLE_USER_MODS;
    private final Map<String, Path> updates = new HashMap<String, Path>();
    private final List<String> updatedModNames = new ArrayList<String>();
    private final List<Path> modsToDisable = new ArrayList<Path>();
    private final Path extractedJarsRoot;

    public JarInJarDependenciesHandler(Path extractedJarsRoot) {
        this.extractedJarsRoot = extractedJarsRoot;
    }

    public List<Path> loadMod(Path path) {
        ArrayList<Path> jarsToLoad = new ArrayList<Path>();
        if (this.loadMod(path, false, jarsToLoad)) {
            return jarsToLoad;
        }
        return Collections.emptyList();
    }

    private boolean loadMod(Path path, boolean isDeeplyNestedJar, List<Path> jarsToLoad) {
        boolean loadedIsUpToDate;
        List<Path> innerJars;
        String modName;
        Version modVersion;
        String modId;
        FabricModJson modJson;
        try {
            modJson = FabricModJson.readFromJar(path);
            modId = modJson.getId();
            modVersion = Version.parse((String)modJson.getVersion());
            modName = modJson.getName();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read fabric.mod.json of " + path, e);
        }
        try {
            innerJars = this.extractInnerJars(path, modJson);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to extract inner jars from " + path, e);
        }
        for (Path innerJar : innerJars) {
            if (this.loadMod(innerJar, true, jarsToLoad)) continue;
            LOGGER.debug("An inner mod of {} needs updating, skipping up-to-date checks for the outer mod", (Object)modId);
            if (!isDeeplyNestedJar) {
                this.updates.put(modId, path);
                this.updatedModNames.add(modName != null ? modName : modId);
            }
            return false;
        }
        if (FabricLoader.getInstance().isDevelopmentEnvironment() && this.isAlreadyOnClasspath(modId)) {
            LOGGER.debug("Detected Kotlin already on the classpath, cannot load bundled {}", (Object)modId);
            return true;
        }
        ModContainer loadedMod = FabricLoader.getInstance().getModContainer(modId).orElse(null);
        if (loadedMod == null) {
            LOGGER.debug("Mod {} is not loaded, injecting directly", (Object)modId);
            jarsToLoad.add(path);
            return true;
        }
        Version loadedVersion = loadedMod.getMetadata().getVersion();
        if (loadedVersion instanceof SemanticVersion && modVersion instanceof SemanticVersion) {
            loadedIsUpToDate = ((SemanticVersion)loadedVersion).compareTo((SemanticVersion)modVersion) >= 0;
        } else {
            loadedIsUpToDate = false;
            LOGGER.debug("Mod {} is loaded but has non-semantic version, assuming outdated.", (Object)modId);
        }
        if (loadedIsUpToDate) {
            LOGGER.debug("A newer version ({}) of mod {} ({}) is already loaded, skipping.", (Object)loadedVersion, (Object)modId, (Object)modVersion);
            return true;
        }
        LOGGER.info("An older version ({}) of mod {} ({}) is already loaded, updating..", (Object)loadedVersion, (Object)modId, (Object)modVersion);
        if (!isDeeplyNestedJar) {
            this.updates.put(modId, path);
            this.updatedModNames.add(modName != null ? modName : modId);
        }
        return false;
    }

    private boolean isAlreadyOnClasspath(String modId) {
        String cls = null;
        switch (modId) {
            case "org_jetbrains_kotlin_kotlin-stdlib": {
                cls = "kotlin/Unit.class";
                break;
            }
            case "org_jetbrains_kotlin_kotlin-stdlib-jdk7": {
                cls = "kotlin/jdk7/AutoCloseableKt.class";
                break;
            }
            case "org_jetbrains_kotlin_kotlin-stdlib-jdk8": {
                cls = "kotlin/jvm/jdk8/JvmRepeatableKt.class";
                break;
            }
            case "org_jetbrains_kotlin_kotlin-reflect": {
                cls = "kotlin/reflect/jvm/KTypesJvm.class";
                break;
            }
            case "org_jetbrains_kotlinx_kotlinx-coroutines-core-jvm": {
                cls = "kotlinx/coroutines/Job.class";
                break;
            }
            case "org_jetbrains_kotlinx_kotlinx-coroutines-jdk8": {
                cls = "kotlinx/coroutines/future/FutureKt.class";
                break;
            }
            case "org_jetbrains_kotlinx_kotlinx-serialization-core-jvm": {
                cls = "kotlinx/serialization/Serializer.class";
                break;
            }
            case "org_jetbrains_kotlinx_kotlinx-serialization-json-jvm": {
                cls = "kotlinx/serialization/json/Json.class";
                break;
            }
            case "org_jetbrains_kotlinx_kotlinx-serialization-cbor-jvm": {
                cls = "kotlinx/serialization/cbor/Cbor.class";
            }
        }
        return cls != null && this.getClass().getClassLoader().getResource(cls) != null;
    }

    private List<Path> extractInnerJars(Path outerJar, FabricModJson fabricModJson) throws IOException {
        if (fabricModJson.getJars().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Path> extractedJars = new ArrayList<Path>();
        try (FileSystem fileSystem = FileSystems.newFileSystem(outerJar, (ClassLoader)null);){
            for (FabricModJson.Jar jarInfo : fabricModJson.getJars()) {
                Path innerJar = fileSystem.getPath(jarInfo.getFile(), new String[0]);
                Path extractedJar = this.extractedJarsRoot.resolve(innerJar.getFileName().toString());
                if (Files.exists(extractedJar, new LinkOption[0])) {
                    LOGGER.debug("Already extracted: {}", (Object)innerJar);
                } else {
                    LOGGER.debug("Extracting {} from {} to {}", (Object)innerJar, (Object)outerJar, (Object)extractedJar);
                    Path tmpJar = Files.createTempFile(this.extractedJarsRoot, "tmp", ".jar", new FileAttribute[0]);
                    Files.copy(innerJar, tmpJar, StandardCopyOption.REPLACE_EXISTING);
                    Files.move(tmpJar, extractedJar, StandardCopyOption.ATOMIC_MOVE);
                }
                extractedJars.add(extractedJar);
            }
        }
        return extractedJars;
    }

    public boolean complete() {
        if (this.updates.isEmpty()) {
            return true;
        }
        try {
            this.updateSyntheticMod();
        }
        catch (IOException e) {
            throw new RuntimeException("Error updating Essential Dependencies mod", e);
        }
        return false;
    }

    public List<Path> getModsToDisable() {
        return this.modsToDisable;
    }

    public List<String> getUpdatedModNames() {
        return this.updatedModNames;
    }

    private void updateSyntheticMod() throws IOException {
        FabricLoader fabricLoader = FabricLoader.getInstance();
        Path modsFolder = fabricLoader.getGameDir().resolve("mods").toRealPath(new LinkOption[0]);
        Path syntheticModPath = modsFolder.resolve(SYNTHETIC_MOD_FILE_NAME);
        LOGGER.debug("Updating synthetic essential-dependencies mod at {}", (Object)syntheticModPath);
        if (Files.notExists(syntheticModPath, new LinkOption[0])) {
            JarInJarDependenciesHandler.createEmptyJar(syntheticModPath);
        }
        try (SyntheticModJar syntheticModJar = new SyntheticModJar(syntheticModPath, SYNTHETIC_MOD_ID, SYNTHETIC_MOD_NAME);){
            String modId;
            for (SyntheticModJar.InnerJar innerJar : syntheticModJar.getInnerJars()) {
                SemanticVersion modVersion;
                modId = innerJar.getId();
                try {
                    modVersion = SemanticVersion.parse((String)innerJar.getVersion());
                }
                catch (VersionParsingException e) {
                    LOGGER.error("Failed to parse version of \"" + innerJar + "\" in " + syntheticModPath, (Throwable)e);
                    syntheticModJar.removeInnerJar(innerJar);
                    continue;
                }
                if (this.updates.containsKey(modId)) {
                    LOGGER.debug("Removing {}, update scheduled", (Object)innerJar);
                    syntheticModJar.removeInnerJar(innerJar);
                    continue;
                }
                ModContainer loadedMod = fabricLoader.getModContainer(modId).orElse(null);
                if (loadedMod == null) {
                    LOGGER.warn("Found {} in synthetic dependencies jar but it was not loaded?", (Object)innerJar);
                    syntheticModJar.removeInnerJar(innerJar);
                    continue;
                }
                Version loadedVersion = loadedMod.getMetadata().getVersion();
                if (!loadedVersion.equals(modVersion)) {
                    LOGGER.debug("Removing {}, appears to be unused", (Object)innerJar);
                    continue;
                }
                LOGGER.debug("Keeping {}, currently in use", (Object)innerJar);
            }
            for (Map.Entry entry : this.updates.entrySet()) {
                modId = (String)entry.getKey();
                Path sourcePath = (Path)entry.getValue();
                if (NEED_TO_DISABLE_USER_MODS) {
                    fabricLoader.getModContainer(modId).ifPresent(mod -> {
                        Path path = mod.getRootPath();
                        try {
                            if (path.isAbsolute() && path.getParent() == null && "zipfs".equals(Files.getFileStore(path).type())) {
                                path = FileSystems.getDefault().getPath(path.getFileSystem().toString(), new String[0]);
                            }
                        }
                        catch (IOException e) {
                            LOGGER.error("Failed to resolve origin of " + mod.getMetadata().getId(), (Throwable)e);
                            return;
                        }
                        if (!Files.isRegularFile(path, new LinkOption[0])) {
                            LOGGER.error("Origin of {} is not a regular file: {}", (Object)mod.getMetadata().getId(), (Object)path);
                            return;
                        }
                        LOGGER.info("Disabling outdated {} at {}", (Object)modId, (Object)path);
                        this.modsToDisable.add(path);
                    });
                }
                LOGGER.debug("Adding {} from {}", (Object)modId, (Object)sourcePath);
                syntheticModJar.addInnerJar(sourcePath);
            }
        }
        LOGGER.debug("Synthetic essential-dependencies jar updated.");
    }

    private static void createEmptyJar(Path path) throws IOException {
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            new ZipOutputStream(out).close();
        }
    }

    static {
        boolean isOldLoader;
        LOGGER = LogManager.getLogger();
        try {
            Class.forName("net.fabricmc.loader.discovery.ModCandidateSet");
            isOldLoader = true;
        }
        catch (ClassNotFoundException e) {
            isOldLoader = false;
        }
        NEED_TO_DISABLE_USER_MODS = isOldLoader;
    }
}

