/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2;

public interface LoaderUI {
    public void start();

    public void setDownloadSize(int var1);

    public void setDownloaded(int var1);

    public void complete();

    public static LoaderUI all(final LoaderUI ... uis) {
        return new LoaderUI(){

            @Override
            public void start() {
                for (LoaderUI ui : uis) {
                    ui.start();
                }
            }

            @Override
            public void setDownloadSize(int bytes) {
                for (LoaderUI ui : uis) {
                    ui.setDownloadSize(bytes);
                }
            }

            @Override
            public void setDownloaded(int bytes) {
                for (LoaderUI ui : uis) {
                    ui.setDownloaded(bytes);
                }
            }

            @Override
            public void complete() {
                for (LoaderUI ui : uis) {
                    ui.complete();
                }
            }
        };
    }

    default public LoaderUI updatesEveryMillis(final int msPerUpdate) {
        return new Adapter(this){
            private long lastUpdate;
            private int lastSize;
            {
                super(inner);
                this.lastUpdate = 0L;
            }

            @Override
            public void setDownloaded(int bytes) {
                this.lastSize = bytes;
                long now = System.currentTimeMillis();
                if (now - this.lastUpdate <= (long)msPerUpdate) {
                    return;
                }
                this.lastUpdate = now;
                super.setDownloaded(bytes);
            }

            @Override
            public void complete() {
                if (this.lastSize > 0) {
                    super.setDownloaded(this.lastSize);
                }
                super.complete();
            }
        };
    }

    public static class Adapter
    implements LoaderUI {
        private final LoaderUI inner;

        public Adapter(LoaderUI inner) {
            this.inner = inner;
        }

        @Override
        public void start() {
            this.inner.start();
        }

        @Override
        public void setDownloadSize(int bytes) {
            this.inner.setDownloadSize(bytes);
        }

        @Override
        public void setDownloaded(int bytes) {
            this.inner.setDownloaded(bytes);
        }

        @Override
        public void complete() {
            this.inner.complete();
        }
    }
}

