/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.SkyblockerMod;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonData<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonData.class);
    @NotNull
    private final Path file;
    @NotNull
    private final Codec<T> codec;
    private final boolean compressed;
    private final boolean loadAsync;
    private final boolean saveAsync;
    @NotNull
    private T data;
    @Nullable
    private CompletableFuture<Void> loaded;

    public JsonData(@NotNull Path file, @NotNull Codec<T> codec, @NotNull T defaultValue) {
        this(file, codec, defaultValue, false);
    }

    public JsonData(@NotNull Path file, @NotNull Codec<T> codec, @NotNull T defaultValue, boolean loadAsync, boolean saveAsync) {
        this(file, codec, defaultValue, false, loadAsync, saveAsync);
    }

    public JsonData(@NotNull Path file, @NotNull Codec<T> codec, @NotNull T defaultValue, boolean compressed) {
        this(file, codec, defaultValue, compressed, true, false);
    }

    public JsonData(@NotNull Path file, @NotNull Codec<T> codec, @NotNull T defaultValue, boolean compressed, boolean loadAsync, boolean saveAsync) {
        this.file = file;
        this.codec = codec;
        this.data = defaultValue;
        this.compressed = compressed;
        this.loadAsync = loadAsync;
        this.saveAsync = saveAsync;
    }

    public CompletableFuture<Void> init() {
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> this.save().join());
        return this.load();
    }

    public CompletableFuture<Void> load() {
        if (this.loadAsync) {
            this.loaded = CompletableFuture.runAsync(this::loadInternal);
        } else {
            this.loadInternal();
            this.loaded = CompletableFuture.completedFuture(null);
        }
        return this.loaded;
    }

    private void loadInternal() {
        try (BufferedReader reader2 = Files.newBufferedReader(this.file);){
            this.data = this.codec.parse((DynamicOps)(this.compressed ? JsonOps.COMPRESSED : JsonOps.INSTANCE), (Object)((JsonElement)SkyblockerMod.GSON.fromJson((Reader)reader2, JsonObject.class))).getOrThrow();
        }
        catch (NoSuchFileException reader2) {
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Json Data] Failed to load data from file: `{}`", (Object)this.file, (Object)e);
        }
    }

    public CompletableFuture<Void> save() {
        if (this.saveAsync) {
            return CompletableFuture.runAsync(this::saveInternal);
        }
        this.saveInternal();
        return CompletableFuture.completedFuture(null);
    }

    private void saveInternal() {
        if (this.loaded == null) {
            LOGGER.error("[Skyblocker Json Data] Save data called when loading has not started for file `{}`. This will override the contents of the file with the default value.", (Object)this.file);
        } else if (!this.isLoaded()) {
            LOGGER.warn("[Skyblocker Json Data] Save data called when loading has not finished for file `{}`. Blocking until data is loaded.", (Object)this.file);
            this.loaded.join();
        }
        try {
            Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Json Data] Failed to create directories for file: `{}`", (Object)this.file, (Object)e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.file, new OpenOption[0]);){
            SkyblockerMod.GSON.toJson((JsonElement)this.codec.encodeStart((DynamicOps)(this.compressed ? JsonOps.COMPRESSED : JsonOps.INSTANCE), this.data).getOrThrow(), (Appendable)writer);
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Json Data] Failed to save data to file: `{}`", (Object)this.file, (Object)e);
        }
    }

    @Deprecated(forRemoval=true)
    public boolean isEmpty() {
        return !this.isLoaded();
    }

    public boolean isLoaded() {
        return this.loaded != null && this.loaded.isDone();
    }

    @NotNull
    public T getData() {
        if (this.loaded == null) {
            LOGGER.error("[Skyblocker Json Data] Get data called when loading has not started for file `{}`. Returning default value.", (Object)this.file);
        } else if (!this.isLoaded()) {
            LOGGER.warn("[Skyblocker Json Data] Get data called when loading has not finished for file `{}`. Blocking until data is loaded.", (Object)this.file);
            this.loaded.join();
        }
        return this.data;
    }

    @NotNull
    public T setData(@NotNull T data) {
        T oldData = this.data;
        this.data = data;
        return oldData;
    }
}

