/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.chat;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.skyblock.barn.HungryHiker;
import de.hysky.skyblocker.skyblock.barn.TreasureHunter;
import de.hysky.skyblocker.skyblock.chat.filters.AbilityFilter;
import de.hysky.skyblocker.skyblock.chat.filters.AdFilter;
import de.hysky.skyblocker.skyblock.chat.filters.AoteFilter;
import de.hysky.skyblocker.skyblock.chat.filters.AutopetFilter;
import de.hysky.skyblocker.skyblock.chat.filters.ComboFilter;
import de.hysky.skyblocker.skyblock.chat.filters.DeathFilter;
import de.hysky.skyblocker.skyblock.chat.filters.DicerFilter;
import de.hysky.skyblocker.skyblock.chat.filters.DungeonBreakerFilter;
import de.hysky.skyblocker.skyblock.chat.filters.HealFilter;
import de.hysky.skyblocker.skyblock.chat.filters.ImplosionFilter;
import de.hysky.skyblocker.skyblock.chat.filters.LotteryFilter;
import de.hysky.skyblocker.skyblock.chat.filters.MimicFilter;
import de.hysky.skyblocker.skyblock.chat.filters.MoltenWaveFilter;
import de.hysky.skyblocker.skyblock.chat.filters.ShowOffFilter;
import de.hysky.skyblocker.skyblock.chat.filters.SkyMallFilter;
import de.hysky.skyblocker.skyblock.chat.filters.TeleportPadFilter;
import de.hysky.skyblocker.skyblock.dungeon.Reparty;
import de.hysky.skyblocker.skyblock.dungeon.puzzle.Trivia;
import de.hysky.skyblocker.skyblock.dwarven.Fetchur;
import de.hysky.skyblocker.skyblock.dwarven.Puzzler;
import de.hysky.skyblocker.skyblock.galatea.SweepDetailsListener;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.chat.ChatFilterResult;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

@FunctionalInterface
public interface ChatMessageListener {
    public static final Event<ChatMessageListener> EVENT = EventFactory.createArrayBacked(ChatMessageListener.class, listeners -> (message, asString) -> {
        for (ChatMessageListener listener : listeners) {
            ChatFilterResult result = listener.onMessage(message, asString);
            if (result == ChatFilterResult.PASS) continue;
            return result;
        }
        return ChatFilterResult.PASS;
    });

    @Init
    public static void init() {
        ChatMessageListener[] listeners;
        for (ChatMessageListener listener : listeners = new ChatMessageListener[]{new Fetchur(), new Puzzler(), new Reparty(), new Trivia(), new TreasureHunter(), new HungryHiker(), new SweepDetailsListener(), new AbilityFilter(), new AdFilter(), new AoteFilter(), new ComboFilter(), new HealFilter(), new ImplosionFilter(), new MoltenWaveFilter(), new TeleportPadFilter(), new AutopetFilter(), new ShowOffFilter(), new SkyMallFilter(), new LotteryFilter(), new MimicFilter(), new DeathFilter(), new DicerFilter(), new DungeonBreakerFilter()}) {
            EVENT.register((Object)listener);
        }
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, overlay) -> {
            if (!Utils.isOnSkyblock()) {
                return true;
            }
            ChatFilterResult result = ((ChatMessageListener)EVENT.invoker()).onMessage(message, class_124.method_539((String)message.getString()));
            switch (result) {
                case ACTION_BAR: {
                    if (overlay) {
                        return true;
                    }
                    class_746 player = class_310.method_1551().field_1724;
                    if (player == null) break;
                    player.method_7353(message, true);
                    return false;
                }
                case FILTER: {
                    return false;
                }
            }
            return true;
        });
    }

    public ChatFilterResult onMessage(class_2561 var1, String var2);
}

