/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils;

public class OkLabColor {
    private static Lab linearSRGB2OkLab(float r, float g, float b) {
        float l = Math.fma(0.41222146f, r, Math.fma(0.53633255f, g, 0.051445995f * b));
        float m = Math.fma(0.2119035f, r, Math.fma(0.6806995f, g, 0.10739696f * b));
        float s = Math.fma(0.08830246f, r, Math.fma(0.28171885f, g, 0.6299787f * b));
        float l_ = (float)Math.cbrt(l);
        float m_ = (float)Math.cbrt(m);
        float s_ = (float)Math.cbrt(s);
        float L = Math.fma(0.21045426f, l_, Math.fma(0.7936178f, m_, -0.004072047f * s_));
        float A = Math.fma(1.9779985f, l_, Math.fma(-2.4285922f, m_, 0.4505937f * s_));
        float B = Math.fma(0.025904037f, l_, Math.fma(0.78277177f, m_, -0.80867577f * s_));
        return new Lab(L, A, B);
    }

    private static RGB okLab2LinearSRGB(float L, float A, float B) {
        float l_ = L + 0.39633778f * A + 0.21580376f * B;
        float m_ = L - 0.105561346f * A - 0.06385417f * B;
        float s_ = L - 0.08948418f * A - 1.2914855f * B;
        float l = l_ * l_ * l_;
        float m = m_ * m_ * m_;
        float s = s_ * s_ * s_;
        float r = Math.fma(4.0767417f, l, Math.fma(-3.3077116f, m, 0.23096994f * s));
        float g = Math.fma(-1.268438f, l, Math.fma(2.6097574f, m, -0.34131938f * s));
        float b = Math.fma(-0.0041960864f, l, Math.fma(-0.7034186f, m, 1.7076147f * s));
        return new RGB(r, g, b);
    }

    private static float linearize(float channel) {
        return channel <= 0.04045f ? channel / 12.92f : (float)Math.pow((channel + 0.055f) / 1.055f, 2.4f);
    }

    private static float delinearize(float channel) {
        return channel <= 0.0031308f ? channel * 12.92f : Math.fma(1.055f, (float)Math.pow(channel, 0.4166666567325592), -0.055f);
    }

    public static int interpolate(int firstColor, int secondColor, float progress) {
        float normalizedR1 = (float)(firstColor >> 16 & 0xFF) / 255.0f;
        float normalizedG1 = (float)(firstColor >> 8 & 0xFF) / 255.0f;
        float normalizedB1 = (float)(firstColor & 0xFF) / 255.0f;
        float normalizedR2 = (float)(secondColor >> 16 & 0xFF) / 255.0f;
        float normalizedG2 = (float)(secondColor >> 8 & 0xFF) / 255.0f;
        float normalizedB2 = (float)(secondColor & 0xFF) / 255.0f;
        Lab lab1 = OkLabColor.linearSRGB2OkLab(OkLabColor.linearize(normalizedR1), OkLabColor.linearize(normalizedG1), OkLabColor.linearize(normalizedB1));
        Lab lab2 = OkLabColor.linearSRGB2OkLab(OkLabColor.linearize(normalizedR2), OkLabColor.linearize(normalizedG2), OkLabColor.linearize(normalizedB2));
        float L = Math.fma(progress, lab2.l - lab1.l, lab1.l);
        float A = Math.fma(progress, lab2.a - lab1.a, lab1.a);
        float B = Math.fma(progress, lab2.b - lab1.b, lab1.b);
        RGB rgb = OkLabColor.okLab2LinearSRGB(L, A, B);
        int r = Math.clamp((long)((int)(OkLabColor.delinearize(rgb.r) * 255.0f)), 0, 255);
        int g = Math.clamp((long)((int)(OkLabColor.delinearize(rgb.g) * 255.0f)), 0, 255);
        int b = Math.clamp((long)((int)(OkLabColor.delinearize(rgb.b) * 255.0f)), 0, 255);
        return r << 16 | g << 8 | b;
    }

    private record Lab(float l, float a, float b) {
    }

    private record RGB(float r, float g, float b) {
    }
}

