/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils;

import de.hysky.skyblocker.utils.Utils;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Calculator {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("(\\d+\\.?\\d*)([sekmbt]?)");
    private static final Object2LongMap<String> MAGNITUDE_VALUES = Object2LongMaps.unmodifiable((Object2LongMap)new Object2LongOpenHashMap(Map.of("s", 64L, "e", 160L, "k", 1000L, "m", 1000000L, "b", 1000000000L, "t", 1000000000000L)));

    private static List<Token> lex(String input) {
        Token token;
        ArrayList<Token> tokens = new ArrayList<Token>();
        input = input.replace(" ", "").toLowerCase().replace("x", "*");
        for (int i = 0; i < input.length(); i += token.tokenLength) {
            token = new Token();
            switch (input.charAt(i)) {
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case '^': {
                    token.type = TokenType.OPERATOR;
                    token.value = String.valueOf(input.charAt(i));
                    token.tokenLength = 1;
                    if (tokens.isEmpty() || ((Token)tokens.getLast()).type != TokenType.OPERATOR) break;
                    throw new UnsupportedOperationException("skyblocker.config.uiAndVisuals.inputCalculator.duplicateOperatorError");
                }
                case '(': {
                    TokenType lastType;
                    token.type = TokenType.L_PARENTHESIS;
                    token.value = String.valueOf(input.charAt(i));
                    token.tokenLength = 1;
                    if (tokens.isEmpty() || (lastType = ((Token)tokens.getLast()).type) != TokenType.R_PARENTHESIS && lastType != TokenType.NUMBER) break;
                    Token mutliplyToken = new Token();
                    mutliplyToken.type = TokenType.OPERATOR;
                    mutliplyToken.value = "*";
                    tokens.add(mutliplyToken);
                    break;
                }
                case ')': {
                    token.type = TokenType.R_PARENTHESIS;
                    token.value = String.valueOf(input.charAt(i));
                    token.tokenLength = 1;
                    break;
                }
                default: {
                    token.type = TokenType.NUMBER;
                    Matcher numberMatcher = NUMBER_PATTERN.matcher(input.substring(i));
                    if (!numberMatcher.find()) {
                        throw new UnsupportedOperationException("skyblocker.config.uiAndVisuals.inputCalculator.invalidCharacterError");
                    }
                    int end = numberMatcher.end();
                    token.value = input.substring(i, i + end);
                    token.tokenLength = end;
                }
            }
            tokens.add(token);
        }
        return tokens;
    }

    private static List<Token> shunt(List<Token> tokens) {
        ArrayDeque<Token> operatorStack = new ArrayDeque<Token>();
        ArrayList<Token> outputQueue = new ArrayList<Token>();
        for (Token shuntingToken : tokens) {
            block0 : switch (shuntingToken.type.ordinal()) {
                case 0: {
                    outputQueue.add(shuntingToken);
                    break;
                }
                case 1: {
                    int precedence = Calculator.getPrecedence(shuntingToken.value);
                    while (!operatorStack.isEmpty()) {
                        Token leftToken = (Token)operatorStack.peek();
                        if (leftToken.type == TokenType.L_PARENTHESIS) break;
                        assert (leftToken.type == TokenType.OPERATOR);
                        int leftPrecedence = Calculator.getPrecedence(leftToken.value);
                        if (leftPrecedence < precedence) break;
                        outputQueue.add((Token)operatorStack.pop());
                    }
                    operatorStack.push(shuntingToken);
                    break;
                }
                case 2: {
                    operatorStack.push(shuntingToken);
                    break;
                }
                case 3: {
                    while (true) {
                        if (operatorStack.isEmpty()) {
                            throw new UnsupportedOperationException("skyblocker.config.uiAndVisuals.inputCalculator.unbalancedParenthesisError");
                        }
                        Token leftToken = (Token)operatorStack.pop();
                        if (leftToken.type == TokenType.L_PARENTHESIS) break block0;
                        outputQueue.add(leftToken);
                    }
                }
            }
        }
        while (!operatorStack.isEmpty()) {
            Token leftToken = (Token)operatorStack.pop();
            if (leftToken.type == TokenType.L_PARENTHESIS) continue;
            outputQueue.add(leftToken);
        }
        return outputQueue.stream().toList();
    }

    private static int getPrecedence(String operator) {
        switch (operator) {
            case "+": 
            case "-": {
                return 0;
            }
            case "*": 
            case "/": {
                return 1;
            }
            case "^": {
                return 2;
            }
        }
        throw new UnsupportedOperationException("skyblocker.config.uiAndVisuals.inputCalculator.invalidOperatorError");
    }

    private static double evaluate(List<Token> tokens) {
        ArrayDeque<Double> values = new ArrayDeque<Double>();
        for (Token token : tokens) {
            block0 : switch (token.type.ordinal()) {
                case 0: {
                    values.push(Calculator.calculateValue(token.value));
                    break;
                }
                case 1: {
                    Double right = (Double)values.pollFirst();
                    Double left = (Double)values.pollFirst();
                    if (left == null || right == null) {
                        throw new UnsupportedOperationException("skyblocker.config.uiAndVisuals.inputCalculator.missingValueError");
                    }
                    switch (token.value) {
                        case "+": {
                            values.push(left + right);
                            break block0;
                        }
                        case "-": {
                            values.push(left - right);
                            break block0;
                        }
                        case "/": {
                            if (right == 0.0) {
                                throw new UnsupportedOperationException("skyblocker.config.uiAndVisuals.inputCalculator.divisionByZeroError");
                            }
                            values.push(left / right);
                            break block0;
                        }
                        case "*": {
                            values.push(left * right);
                            break block0;
                        }
                        case "^": {
                            values.push(Math.pow(left, right));
                        }
                    }
                    break;
                }
                case 2: 
                case 3: {
                    throw new UnsupportedOperationException("skyblocker.config.uiAndVisuals.inputCalculator.badEquationNotation");
                }
            }
        }
        if (values.isEmpty()) {
            throw new UnsupportedOperationException("skyblocker.config.uiAndVisuals.inputCalculator.emptyEquationError");
        }
        return (Double)values.pop();
    }

    private static double calculateValue(String value) {
        Matcher numberMatcher = NUMBER_PATTERN.matcher(value.toLowerCase());
        if (!numberMatcher.matches()) {
            throw new UnsupportedOperationException("skyblocker.config.uiAndVisuals.inputCalculator.invalidNumberError");
        }
        double number = Double.parseDouble(numberMatcher.group(1));
        String magnitude = numberMatcher.group(2);
        if (!magnitude.isEmpty()) {
            if (!MAGNITUDE_VALUES.containsKey((Object)magnitude)) {
                throw new UnsupportedOperationException("skyblocker.config.uiAndVisuals.inputCalculator.invalidMagnitudeError");
            }
            number *= (double)MAGNITUDE_VALUES.getLong((Object)magnitude);
        }
        return number;
    }

    public static double calculate(String equation) {
        equation = equation.toLowerCase().replaceAll("p(urse)?", String.valueOf((long)Utils.getPurse()));
        return Calculator.evaluate(Calculator.shunt(Calculator.lex(equation)));
    }

    public static class Token {
        public TokenType type;
        String value;
        int tokenLength;
    }

    public static enum TokenType {
        NUMBER,
        OPERATOR,
        L_PARENTHESIS,
        R_PARENTHESIS;

    }
}

