/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.waypoint;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.waypoint.WaypointsScreen;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import de.hysky.skyblocker.utils.waypoint.WaypointGroup;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3542;
import net.minecraft.class_370;
import net.minecraft.class_7157;
import net.minecraft.class_7485;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Waypoints {
    public static final Logger LOGGER = LoggerFactory.getLogger(Waypoints.class);
    private static final Codec<List<WaypointGroup>> CODEC = WaypointGroup.CODEC.listOf();
    private static final Codec<List<WaypointGroup>> SKYTILS_CODEC = WaypointGroup.SKYTILS_CODEC.listOf();
    private static final Codec<Collection<WaypointGroup>> SKYBLOCKER_LEGACY_ORDERED_CODEC = Codec.unboundedMap((Codec)Codec.STRING, WaypointGroup.SKYBLOCKER_LEGACY_ORDERED_CODEC).xmap(Map::values, groups -> groups.stream().collect(Collectors.toMap(WaypointGroup::name, Function.identity())));
    private static final String PREFIX = "[Skyblocker-Waypoint-Data-V1]";
    private static final String SKYBLOCKER_LEGACY_ORDERED = "[Skyblocker::OrderedWaypoints::v1]";
    protected static final class_370.class_9037 WAYPOINTS_TOAST_TYPE = new class_370.class_9037();
    private static final Path WAYPOINTS_FILE = SkyblockerMod.CONFIG_DIR.resolve("waypoints.json");
    private static final Path SKYBLOCKER_LEGACY_ORDERED_FILE = SkyblockerMod.CONFIG_DIR.resolve("ordered_waypoints.json");
    private static final Multimap<Location, WaypointGroup> waypoints = MultimapBuilder.enumKeys(Location.class).arrayListValues().build();

    @Init
    public static void init() {
        Waypoints.loadWaypoints();
        ClientLifecycleEvents.CLIENT_STOPPING.register(Waypoints::saveWaypoints);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(Waypoints::render);
        ClientCommandRegistrationCallback.EVENT.register(Waypoints::registerCommands);
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _client) -> Waypoints.reset());
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 access) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"waypoints").executes(Scheduler.queueOpenScreenCommand(() -> new WaypointsScreen(class_310.method_1551().field_1755)))).then(ClientCommandManager.literal((String)"ordered").then(ClientCommandManager.argument((String)"action", (ArgumentType)OrderedAction.ArgumentType.orderedAction()).executes(Waypoints::executeOrderedWaypointAction)))));
    }

    private static int executeOrderedWaypointAction(CommandContext<FabricClientCommandSource> context) {
        Optional<WaypointGroup> groupOptional = waypoints.get((Object)Utils.getLocation()).stream().filter(group -> group.ordered() && !group.waypoints().isEmpty() && group.waypoints().stream().allMatch(Waypoint::isEnabled)).findFirst();
        if (groupOptional.isEmpty()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"No ordered group enabled here! (make sure all waypoints in the group are enabled)")));
            return 1;
        }
        WaypointGroup group2 = groupOptional.get();
        OrderedAction action = OrderedAction.ArgumentType.getOrderedAction(context, "action");
        int index = group2.currentIndex();
        int waypointCount = group2.waypoints().size();
        switch (action.ordinal()) {
            case 2: 
            case 3: {
                group2.resetCurrentIndex();
                break;
            }
            case 0: {
                group2.setCurrentIndex((index + 1) % waypointCount);
                break;
            }
            case 1: {
                group2.setCurrentIndex((index - 1 + waypointCount) % waypointCount);
            }
        }
        return 1;
    }

    public static void loadWaypoints() {
        Collection waypointGroups;
        BufferedReader reader;
        waypoints.clear();
        try {
            reader = Files.newBufferedReader(WAYPOINTS_FILE);
            try {
                waypointGroups = (List)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)SkyblockerMod.GSON.fromJson((Reader)reader, JsonArray.class))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow();
                waypointGroups.forEach(Waypoints::putWaypointGroup);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Waypoints] Encountered exception while loading waypoints", (Throwable)e);
        }
        try {
            reader = Files.newBufferedReader(SKYBLOCKER_LEGACY_ORDERED_FILE);
            try {
                waypointGroups = (Collection)SKYBLOCKER_LEGACY_ORDERED_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)SkyblockerMod.GSON.fromJson((Reader)reader, JsonObject.class))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow();
                for (WaypointGroup group : waypointGroups) {
                    Waypoints.putWaypointGroup(group.withIsland(Location.DWARVEN_MINES).deepCopy());
                    Waypoints.putWaypointGroup(group.withIsland(Location.CRYSTAL_HOLLOWS).deepCopy());
                }
                Files.move(SKYBLOCKER_LEGACY_ORDERED_FILE, SkyblockerMod.CONFIG_DIR.resolve("legacy_ordered_waypoints.json"), new CopyOption[0]);
                LOGGER.info("[Skyblocker Waypoints] Successfully migrated {} ordered waypoints from {} groups to waypoints!", (Object)waypointGroups.stream().map(WaypointGroup::waypoints).mapToInt(List::size).sum(), (Object)waypointGroups.size());
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (FileAlreadyExistsException | NoSuchFileException reader2) {
        }
        catch (IOException e) {
            LOGGER.error("[Skyblocker Waypoints] Encountered exception while loading legacy ordered waypoints", (Throwable)e);
        }
    }

    public static void saveWaypoints(class_310 client) {
        try (BufferedWriter writer = Files.newBufferedWriter(WAYPOINTS_FILE, new OpenOption[0]);){
            JsonElement waypointsJson = (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, List.copyOf(waypoints.values())).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow();
            SkyblockerMod.GSON.toJson(waypointsJson, (Appendable)writer);
            LOGGER.info("[Skyblocker Waypoints] Saved waypoints");
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Waypoints] Encountered exception while saving waypoints", (Throwable)e);
        }
    }

    @Nullable
    public static List<WaypointGroup> fromSkyblocker(String waypointsString, Location defaultIsland) {
        if ((waypointsString = waypointsString.trim()).startsWith(PREFIX)) {
            List list;
            GZIPInputStream reader = new GZIPInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(waypointsString.replace(PREFIX, ""))));
            try {
                list = (List)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)SkyblockerMod.GSON.fromJson(new String(reader.readAllBytes()), JsonArray.class))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("[Skyblocker Waypoints] Encountered exception while parsing Skyblocker waypoint data", (Throwable)e);
                    return null;
                }
            }
            reader.close();
            return list;
        }
        if (waypointsString.startsWith(SKYBLOCKER_LEGACY_ORDERED)) {
            List<WaypointGroup> list;
            GZIPInputStream reader = new GZIPInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(waypointsString.replace(SKYBLOCKER_LEGACY_ORDERED, ""))));
            try {
                list = Waypoints.applyDefaultLocation((Collection)SKYBLOCKER_LEGACY_ORDERED_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)SkyblockerMod.GSON.fromJson(new String(reader.readAllBytes()), JsonObject.class))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow(), defaultIsland);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("[Skyblocker Waypoints] Encountered exception while parsing Skyblocker legacy ordered waypoint data", (Throwable)e);
                    return null;
                }
            }
            reader.close();
            return list;
        }
        LOGGER.error("[Skyblocker Waypoints] Unknown skyblocker waypoint data prefix");
        return null;
    }

    public static String toSkyblocker(List<WaypointGroup> waypointGroups) {
        String waypointsJson = SkyblockerMod.GSON.toJson((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, waypointGroups).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(output);){
            gzip.write(waypointsJson.getBytes());
        }
        catch (IOException e) {
            LOGGER.error("[Skyblocker Waypoints] Encountered exception while serializing Skyblocker waypoint data", (Throwable)e);
        }
        return PREFIX + new String(Base64.getEncoder().encode(output.toByteArray()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static List<WaypointGroup> fromSkytils(String waypointsString, Location defaultIsland) {
        waypointsString = waypointsString.trim();
        try {
            if (!waypointsString.startsWith("<Skytils-Waypoint-Data>(V")) return Waypoints.fromSkytilsJson(new String(Base64.getDecoder().decode(waypointsString)), defaultIsland);
            int version = Integer.parseInt(waypointsString.substring(25, waypointsString.indexOf(41)));
            waypointsString = waypointsString.substring(waypointsString.indexOf(58) + 1);
            if (version != 1) {
                LOGGER.error("[Skyblocker Waypoints] Unknown Skytils waypoint data version: {}", (Object)version);
                return Collections.emptyList();
            }
            try (GZIPInputStream reader = new GZIPInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(waypointsString)));){
                List<WaypointGroup> list = Waypoints.fromSkytilsJson(IOUtils.toString((InputStream)reader, (Charset)StandardCharsets.UTF_8), defaultIsland);
                return list;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error("[Skyblocker Waypoints] Encountered exception while parsing Skytils waypoint data version", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Waypoints] Encountered exception while decoding Skytils waypoint data", (Throwable)e);
            return null;
        }
    }

    public static List<WaypointGroup> fromSkytilsJson(String waypointGroupsString, Location defaultIsland) {
        JsonArray waypointGroupsJson;
        try {
            waypointGroupsJson = ((JsonObject)SkyblockerMod.GSON.fromJson(waypointGroupsString, JsonObject.class)).getAsJsonArray("categories");
        }
        catch (JsonSyntaxException e) {
            JsonObject waypointGroupJson = new JsonObject();
            waypointGroupJson.addProperty("name", "New Group");
            waypointGroupJson.addProperty("island", defaultIsland.id());
            waypointGroupJson.add("waypoints", (JsonElement)SkyblockerMod.GSON.fromJson(waypointGroupsString, JsonArray.class));
            waypointGroupsJson = new JsonArray();
            waypointGroupsJson.add((JsonElement)waypointGroupJson);
        }
        List waypointGroups = (List)SKYTILS_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)waypointGroupsJson).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow();
        return Waypoints.applyDefaultLocation(waypointGroups, defaultIsland);
    }

    public static String toSkytilsBase64(List<WaypointGroup> waypointGroups) {
        return Base64.getEncoder().encodeToString(Waypoints.toSkytilsJson(waypointGroups).getBytes());
    }

    public static String toSkytilsJson(List<WaypointGroup> waypointGroups) {
        JsonObject waypointGroupsJson = new JsonObject();
        waypointGroupsJson.add("categories", (JsonElement)SKYTILS_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, waypointGroups).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow());
        return SkyblockerMod.GSON_COMPACT.toJson((JsonElement)waypointGroupsJson);
    }

    public static WaypointGroup fromColeweightJson(String waypointsJson, Location defaultIsland) {
        return ((WaypointGroup)WaypointGroup.COLEWEIGHT_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)waypointsJson)).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow()).withIsland(defaultIsland);
    }

    public static List<WaypointGroup> applyDefaultLocation(Collection<WaypointGroup> waypointGroups, Location defaultIsland) {
        return waypointGroups.stream().map(waypointGroup -> waypointGroup.island() == Location.UNKNOWN ? waypointGroup.withIsland(defaultIsland) : waypointGroup).toList();
    }

    public static Collection<WaypointGroup> getWaypointGroup(Location island) {
        return waypoints.get((Object)island);
    }

    public static boolean putWaypointGroup(WaypointGroup waypointGroup) {
        return waypoints.put((Object)waypointGroup.island(), (Object)waypointGroup);
    }

    public static boolean clearAndPutAllWaypoints(Multimap<Location, WaypointGroup> newWaypoints) {
        waypoints.clear();
        return waypoints.putAll(newWaypoints);
    }

    public static boolean areWaypointsEqual(Multimap<Location, WaypointGroup> otherWaypoints) {
        return waypoints.equals(otherWaypoints);
    }

    public static Multimap<Location, WaypointGroup> waypointsDeepCopy() {
        return (Multimap)waypoints.values().stream().map(WaypointGroup::deepCopy).collect(Multimaps.toMultimap(WaypointGroup::island, Function.identity(), () -> MultimapBuilder.enumKeys(Location.class).arrayListValues().build()));
    }

    private static void render(WorldRenderContext context) {
        if (SkyblockerConfigManager.get().uiAndVisuals.waypoints.enableWaypoints) {
            for (WaypointGroup group : Waypoints.getWaypointGroup(Utils.getLocation())) {
                if (group == null) continue;
                group.render(context);
            }
            if (Utils.getLocationRaw().isEmpty()) {
                return;
            }
            for (WaypointGroup group : Waypoints.getWaypointGroup(Location.UNKNOWN)) {
                if (group == null) continue;
                group.render(context);
            }
        }
    }

    private static void reset() {
        waypoints.values().forEach(WaypointGroup::resetCurrentIndex);
    }

    private static enum OrderedAction implements class_3542
    {
        NEXT,
        PREVIOUS,
        FIRST,
        RESET;

        private static final Codec<OrderedAction> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        static {
            CODEC = class_3542.method_28140(OrderedAction::values);
        }

        static class ArgumentType
        extends class_7485<OrderedAction> {
            protected ArgumentType() {
                super(CODEC, OrderedAction::values);
            }

            static ArgumentType orderedAction() {
                return new ArgumentType();
            }

            static <S> OrderedAction getOrderedAction(CommandContext<S> context, String name) {
                return (OrderedAction)((Object)context.getArgument(name, OrderedAction.class));
            }
        }
    }
}

