/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.widget;

import de.hysky.skyblocker.skyblock.tabhud.widget.ComponentBasedWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.Component;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.TableComponent;
import java.util.List;
import net.minecraft.class_5250;

public abstract class TableWidget
extends ComponentBasedWidget {
    private final int columns;
    private final int lineColor;
    private final boolean drawLines;

    protected TableWidget(class_5250 title, int colorValue, String internalId, int columns, int lineColor, boolean drawLines) {
        super(title, colorValue, internalId);
        this.columns = columns;
        this.lineColor = lineColor;
        this.drawLines = drawLines;
    }

    protected TableWidget(class_5250 title, int colorValue, String internalId, int columns, int lineColor) {
        this(title, colorValue, internalId, columns, lineColor, true);
    }

    protected TableWidget(class_5250 title, int colorValue, String internalId, int columns, boolean drawLines) {
        this(title, colorValue, internalId, columns, -1, drawLines);
    }

    protected TableWidget(class_5250 title, int colorValue, String internalId, int columns) {
        this(title, colorValue, internalId, columns, -1, true);
    }

    protected abstract List<Row> buildRows();

    @Override
    public void updateContent() {
        List<Row> rows = this.buildRows();
        TableComponent table = new TableComponent(this.columns, rows.size(), this.lineColor, this.drawLines);
        for (int y = 0; y < rows.size(); ++y) {
            Row row = rows.get(y);
            for (int x = 0; x < Math.min(this.columns, row.cells.size()); ++x) {
                table.addToCell(x, y, row.cells.get(x));
            }
            if (row.borderColor == 0) continue;
            table.setRowBorder(y, row.borderColor);
        }
        this.addComponent(table);
    }

    public static class Row {
        public final List<Component> cells;
        public final int borderColor;

        public Row(List<Component> cells, int borderColor) {
            this.cells = cells;
            this.borderColor = borderColor;
        }
    }
}

