/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.widget;

import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.skyblock.tabhud.widget.TabHudWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.Component;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.Components;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.IcoFatTextComponent;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.PlainTextComponent;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

@RegisterWidget
public class SkillsWidget
extends TabHudWidget {
    private static final class_5250 TITLE = class_2561.method_43470((String)"Skill Info").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067});
    private static final Pattern SKILL_PATTERN = Pattern.compile("([A-Za-z]* [0-9]*): ([0-9.MAX]*)%?");

    public SkillsWidget() {
        super("Skills", TITLE, class_124.field_1054.method_532());
    }

    @Override
    public void updateContent(List<class_2561> lines) {
        for (class_2561 line : lines) {
            Component progress;
            Matcher m = SKILL_PATTERN.matcher(line.getString());
            if (m.matches()) {
                String skill = m.group(1);
                String pcntStr = m.group(2);
                if (!pcntStr.equals("MAX")) {
                    float pcnt = Float.parseFloat(pcntStr);
                    progress = Components.progressComponent(Ico.LANTERN, class_2561.method_30163((String)skill), pcnt, class_124.field_1065.method_532());
                } else {
                    progress = new IcoFatTextComponent(Ico.LANTERN, class_2561.method_30163((String)skill), (class_2561)class_2561.method_43470((String)pcntStr).method_27692(class_124.field_1061));
                }
            } else {
                progress = new PlainTextComponent(line);
            }
            this.addComponent(progress);
        }
    }
}

