/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.widget;

import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.TabHudWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.IcoTextComponent;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.PlainTextComponent;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

@RegisterWidget
public class MinionWidget
extends TabHudWidget {
    private static final class_5250 TITLE = class_2561.method_43470((String)"Minions").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067});
    private static final HashMap<String, class_1799> MIN_ICOS = new HashMap();
    public static final Pattern MINION_PATTERN;

    public MinionWidget() {
        super("Minions", TITLE, class_124.field_1062.method_532());
    }

    @Override
    public void updateContent(List<class_2561> lines) {
        this.addComponent(new PlainTextComponent((class_2561)lines.getFirst().method_27661().method_10852((class_2561)class_2561.method_43470((String)" minions"))));
        for (int i = 1; i < lines.size(); ++i) {
            String string = lines.get(i).getString();
            if (string.toLowerCase().startsWith("...")) {
                this.addComponent(new PlainTextComponent((class_2561)lines.get(i).method_27661().method_27692(class_124.field_1080)));
                continue;
            }
            this.addMinionComponent(string);
        }
    }

    public void addMinionComponent(String line) {
        Matcher m = MINION_PATTERN.matcher(line);
        if (m.matches()) {
            String min = m.group("name");
            String amount = m.group("amount");
            String lvl = m.group("level");
            String stat = m.group("status");
            class_5250 mt = class_2561.method_43470((String)(amount + "x " + min + " " + lvl)).method_10852((class_2561)class_2561.method_43470((String)": "));
            class_124 format = class_124.field_1061;
            if (stat.equals("ACTIVE")) {
                format = class_124.field_1060;
            } else if (stat.equals("SLOW")) {
                format = class_124.field_1054;
            }
            mt.method_10852((class_2561)class_2561.method_43470((String)stat).method_27692(format));
            IcoTextComponent itc = new IcoTextComponent(MIN_ICOS.get(min), (class_2561)mt);
            this.addComponent(itc);
        }
    }

    static {
        MIN_ICOS.put("Blaze", new class_1799((class_1935)class_1802.field_8894));
        MIN_ICOS.put("Cave Spider", new class_1799((class_1935)class_1802.field_8680));
        MIN_ICOS.put("Creeper", new class_1799((class_1935)class_1802.field_8054));
        MIN_ICOS.put("Enderman", new class_1799((class_1935)class_1802.field_8634));
        MIN_ICOS.put("Ghast", new class_1799((class_1935)class_1802.field_8070));
        MIN_ICOS.put("Magma Cube", new class_1799((class_1935)class_1802.field_8135));
        MIN_ICOS.put("Skeleton", new class_1799((class_1935)class_1802.field_8606));
        MIN_ICOS.put("Slime", new class_1799((class_1935)class_1802.field_8777));
        MIN_ICOS.put("Spider", new class_1799((class_1935)class_1802.field_8276));
        MIN_ICOS.put("Zombie", new class_1799((class_1935)class_1802.field_8511));
        MIN_ICOS.put("Cactus", new class_1799((class_1935)class_1802.field_17520));
        MIN_ICOS.put("Carrot", new class_1799((class_1935)class_1802.field_8179));
        MIN_ICOS.put("Chicken", new class_1799((class_1935)class_1802.field_8726));
        MIN_ICOS.put("Cocoa Beans", new class_1799((class_1935)class_1802.field_8116));
        MIN_ICOS.put("Cow", new class_1799((class_1935)class_1802.field_8046));
        MIN_ICOS.put("Melon", new class_1799((class_1935)class_1802.field_8497));
        MIN_ICOS.put("Mushroom", new class_1799((class_1935)class_1802.field_17517));
        MIN_ICOS.put("Nether Wart", new class_1799((class_1935)class_1802.field_8790));
        MIN_ICOS.put("Pig", new class_1799((class_1935)class_1802.field_8389));
        MIN_ICOS.put("Potato", new class_1799((class_1935)class_1802.field_8567));
        MIN_ICOS.put("Pumpkin", new class_1799((class_1935)class_1802.field_17518));
        MIN_ICOS.put("Rabbit", new class_1799((class_1935)class_1802.field_8504));
        MIN_ICOS.put("Sheep", new class_1799((class_1935)class_1802.field_19044));
        MIN_ICOS.put("Sugar Cane", new class_1799((class_1935)class_1802.field_17531));
        MIN_ICOS.put("Wheat", new class_1799((class_1935)class_1802.field_8861));
        MIN_ICOS.put("Clay", new class_1799((class_1935)class_1802.field_19060));
        MIN_ICOS.put("Fishing", new class_1799((class_1935)class_1802.field_8378));
        MIN_ICOS.put("Coal", new class_1799((class_1935)class_1802.field_8713));
        MIN_ICOS.put("Cobblestone", new class_1799((class_1935)class_1802.field_20412));
        MIN_ICOS.put("Diamond", new class_1799((class_1935)class_1802.field_8477));
        MIN_ICOS.put("Emerald", new class_1799((class_1935)class_1802.field_8687));
        MIN_ICOS.put("End Stone", new class_1799((class_1935)class_1802.field_20399));
        MIN_ICOS.put("Glowstone", new class_1799((class_1935)class_1802.field_8601));
        MIN_ICOS.put("Gold", new class_1799((class_1935)class_1802.field_8695));
        MIN_ICOS.put("Gravel", new class_1799((class_1935)class_1802.field_8110));
        MIN_ICOS.put("Hard Stone", new class_1799((class_1935)class_1802.field_20391));
        MIN_ICOS.put("Ice", new class_1799((class_1935)class_1802.field_8426));
        MIN_ICOS.put("Iron", new class_1799((class_1935)class_1802.field_8620));
        MIN_ICOS.put("Lapis", new class_1799((class_1935)class_1802.field_8759));
        MIN_ICOS.put("Mithril", new class_1799((class_1935)class_1802.field_8434));
        MIN_ICOS.put("Mycelium", new class_1799((class_1935)class_1802.field_8610));
        MIN_ICOS.put("Obsidian", new class_1799((class_1935)class_1802.field_8281));
        MIN_ICOS.put("Quartz", new class_1799((class_1935)class_1802.field_8155));
        MIN_ICOS.put("Red Sand", new class_1799((class_1935)class_1802.field_8200));
        MIN_ICOS.put("Redstone", new class_1799((class_1935)class_1802.field_8725));
        MIN_ICOS.put("Sand", new class_1799((class_1935)class_1802.field_8858));
        MIN_ICOS.put("Snow", new class_1799((class_1935)class_1802.field_8543));
        MIN_ICOS.put("Inferno", new class_1799((class_1935)class_1802.field_8154));
        MIN_ICOS.put("Revenant", new class_1799((class_1935)class_1802.field_8441));
        MIN_ICOS.put("Tarantula", new class_1799((class_1935)class_1802.field_8185));
        MIN_ICOS.put("Vampire", new class_1799((class_1935)class_1802.field_8725));
        MIN_ICOS.put("Voidling", new class_1799((class_1935)class_1802.field_8374));
        MIN_ICOS.put("Acacia", new class_1799((class_1935)class_1802.field_8820));
        MIN_ICOS.put("Birch", new class_1799((class_1935)class_1802.field_8170));
        MIN_ICOS.put("Dark Oak", new class_1799((class_1935)class_1802.field_8652));
        MIN_ICOS.put("Flower", new class_1799((class_1935)class_1802.field_8880));
        MIN_ICOS.put("Jungle", new class_1799((class_1935)class_1802.field_8125));
        MIN_ICOS.put("Oak", new class_1799((class_1935)class_1802.field_8583));
        MIN_ICOS.put("Spruce", new class_1799((class_1935)class_1802.field_8684));
        MINION_PATTERN = Pattern.compile("^(?<amount>\\d+)x (?<name>.*) (?<level>[XVI]*) \\[(?<status>.*)]");
    }
}

