/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.widget;

import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.skyblock.tabhud.util.PlayerListManager;
import de.hysky.skyblocker.skyblock.tabhud.widget.TabHudWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.PlainTextComponent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

@RegisterWidget
public class DungeonBuffWidget
extends TabHudWidget {
    private static final class_5250 TITLE = class_2561.method_43470((String)"Dungeon Buffs").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067});

    public DungeonBuffWidget() {
        super("Dungeon Buffs", TITLE, class_124.field_1064.method_532());
    }

    @Override
    public void updateContent(List<class_2561> ignored) {
        String footertext = PlayerListManager.getFooter();
        if (footertext == null || !footertext.contains("Dungeon Buffs")) {
            this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43470((String)"No data").method_27692(class_124.field_1080)));
            return;
        }
        String interesting = footertext.split("Dungeon Buffs")[1];
        String[] lines = interesting.split("\n");
        if (!lines[1].startsWith("Blessing")) {
            this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43470((String)"No buffs found!").method_27692(class_124.field_1080)));
            return;
        }
        lines = (String[])Arrays.stream(lines).filter(s -> s.contains("Blessing")).toArray(String[]::new);
        Arrays.sort(lines, Comparator.comparing(String::toLowerCase));
        for (String line : lines) {
            if (line.length() < 3) break;
            int color = this.getBlessingColor(line);
            this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43470((String)line).method_27694(style -> style.method_36139(color))));
        }
    }

    public int getBlessingColor(String blessing) {
        if (blessing.contains("Life")) {
            return class_124.field_1076.method_532();
        }
        if (blessing.contains("Power")) {
            return class_124.field_1061.method_532();
        }
        if (blessing.contains("Stone")) {
            return class_124.field_1060.method_532();
        }
        if (blessing.contains("Time")) {
            return 11516097;
        }
        if (blessing.contains("Wisdom")) {
            return class_124.field_1075.method_532();
        }
        return 0xFFFFFF;
    }
}

