/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.slayers;

import de.hysky.skyblocker.skyblock.slayers.SlayerManager;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1259;
import net.minecraft.class_1531;
import net.minecraft.class_2561;
import net.minecraft.class_345;

public class SlayerBossBars {
    public static final UUID UUID = java.util.UUID.randomUUID();
    private static final Pattern HEALTH_PATTERN = Pattern.compile("(\\d{1,3}(?:,\\d{3})*(?:\\.\\d+)?[kM]?)(?=\u2764)");
    private static final long UPDATE_INTERVAL = 400L;
    private static int bossMaxHealth = -1;
    private static long lastUpdateTime = 0L;
    private static class_345 bossBar;

    public static boolean shouldRenderBossBar() {
        Matcher maxHealthMatcher;
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastUpdateTime < 400L) {
            return bossBar != null;
        }
        lastUpdateTime = currentTime;
        if (!SlayerManager.isBossSpawned()) {
            bossMaxHealth = -1;
            bossBar = null;
            return false;
        }
        class_1531 bossArmorStand = SlayerManager.getSlayerBossArmorStand();
        if (bossArmorStand != null && bossMaxHealth == -1 && (maxHealthMatcher = HEALTH_PATTERN.matcher(bossArmorStand.method_5477().getString())).find()) {
            bossMaxHealth = SlayerBossBars.convertToInt(maxHealthMatcher.group(0));
        }
        return bossBar != null || bossArmorStand != null;
    }

    public static class_345 updateBossBar() {
        class_1531 slayer = SlayerManager.getSlayerBossArmorStand();
        if (bossBar == null) {
            bossBar = new class_345(UUID, slayer != null ? slayer.method_5476() : class_2561.method_30163((String)"Attempting to Locate Slayer..."), 1.0f, class_1259.class_1260.field_5783, class_1259.class_1261.field_5795, false, false, false);
        }
        if (slayer == null) {
            bossBar.method_5409(class_1259.class_1261.field_5795);
            bossBar.method_5416(class_1259.class_1260.field_5784);
            return bossBar;
        }
        Matcher healthMatcher = HEALTH_PATTERN.matcher(slayer.method_5477().getString());
        if (healthMatcher.find() && slayer.method_5805()) {
            bossBar.method_5408(bossMaxHealth == -1 ? 1.0f : (float)SlayerBossBars.convertToInt(healthMatcher.group(1)) / (float)bossMaxHealth);
            bossBar.method_5416(class_1259.class_1260.field_5788);
            bossBar.method_5413(slayer.method_5476());
            bossBar.method_5409(class_1259.class_1261.field_5791);
        } else {
            bossBar.method_5416(class_1259.class_1260.field_5784);
            bossBar.method_5409(class_1259.class_1261.field_5795);
            bossBar.method_5413(slayer.method_5476());
        }
        return bossBar;
    }

    private static int convertToInt(String value) {
        if (value == null || value.isEmpty()) {
            return 0;
        }
        value = value.replace(",", "").trim().toLowerCase(Locale.ENGLISH);
        double multiplier = 1.0;
        if (value.endsWith("m")) {
            multiplier = 1000000.0;
            value = value.substring(0, value.length() - 1);
        } else if (value.endsWith("k")) {
            multiplier = 1000.0;
            value = value.substring(0, value.length() - 1);
        }
        try {
            double numericValue = Double.parseDouble(value);
            return (int)(numericValue * multiplier);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

