/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.shortcut;

import com.demonwav.mcdev.annotations.Translatable;
import de.hysky.skyblocker.debug.Debug;
import de.hysky.skyblocker.skyblock.shortcut.ShortcutKeyBinding;
import de.hysky.skyblocker.skyblock.shortcut.Shortcuts;
import de.hysky.skyblocker.skyblock.shortcut.ShortcutsConfigScreen;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class ShortcutsConfigListWidget
extends class_4265<AbstractShortcutEntry> {
    private final ShortcutsConfigScreen screen;

    public ShortcutsConfigListWidget(class_310 minecraftClient, ShortcutsConfigScreen screen, int width, int height, int y, int itemHeight) {
        super(minecraftClient, width, height, y, itemHeight);
        this.screen = screen;
        ShortcutCategoryEntry<String> commandCategory = new ShortcutCategoryEntry<String>((Map<String, String>)Shortcuts.shortcuts.getData().commands(), x$0 -> new CommandShortcutEntry((ShortcutCategoryEntry<String>)((Object)x$0)), "skyblocker.shortcuts.command.target", "skyblocker.shortcuts.command.replacement");
        if (Shortcuts.isShortcutsLoaded()) {
            commandCategory.shortcutsMap.keySet().stream().sorted().forEach(commandTarget -> this.method_25321((class_350.class_351)new CommandShortcutEntry(commandCategory, (String)commandTarget)));
        } else {
            this.method_25321((class_350.class_351)new ShortcutLoadingEntry());
        }
        ShortcutCategoryEntry<String> commandArgCategory = new ShortcutCategoryEntry<String>((Map<String, String>)Shortcuts.shortcuts.getData().commandArgs(), (Function<ShortcutCategoryEntry<String>, ShortcutEntry<String>>)x$0 -> new CommandShortcutEntry((ShortcutCategoryEntry<String>)((Object)x$0)), "skyblocker.shortcuts.commandArg.target", "skyblocker.shortcuts.commandArg.replacement", "skyblocker.shortcuts.commandArg.tooltip");
        if (Shortcuts.isShortcutsLoaded()) {
            commandArgCategory.shortcutsMap.keySet().stream().sorted().forEach(commandArgTarget -> this.method_25321((class_350.class_351)new CommandShortcutEntry(commandArgCategory, (String)commandArgTarget)));
        } else {
            this.method_25321((class_350.class_351)new ShortcutLoadingEntry());
        }
        ShortcutCategoryEntry<ShortcutKeyBinding> keybindCategory = new ShortcutCategoryEntry<ShortcutKeyBinding>((Map<ShortcutKeyBinding, String>)Shortcuts.shortcuts.getData().keyBindings(), (Function<ShortcutCategoryEntry<ShortcutKeyBinding>, ShortcutEntry<ShortcutKeyBinding>>)x$0 -> new KeybindShortcutEntry((ShortcutCategoryEntry<ShortcutKeyBinding>)((Object)x$0)), "skyblocker.shortcuts.keyBinding.target", "skyblocker.shortcuts.keyBinding.replacement", "skyblocker.shortcuts.keyBinding.tooltip");
        if (Shortcuts.isShortcutsLoaded()) {
            keybindCategory.shortcutsMap.keySet().stream().sorted().forEach(keyBinding -> this.method_25321((class_350.class_351)new KeybindShortcutEntry(keybindCategory, (ShortcutKeyBinding)keyBinding)));
        } else {
            this.method_25321((class_350.class_351)new ShortcutLoadingEntry());
        }
    }

    public int method_25322() {
        return super.method_25322() + 100;
    }

    protected int method_65507() {
        return super.method_65507();
    }

    protected Optional<ShortcutCategoryEntry<?>> getCategory() {
        AbstractShortcutEntry abstractShortcutEntry = (AbstractShortcutEntry)this.method_25334();
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShortcutCategoryEntry.class, ShortcutEntry.class}, (Object)((Object)abstractShortcutEntry), n)) {
            case 0 -> {
                ShortcutCategoryEntry category = (ShortcutCategoryEntry)abstractShortcutEntry;
                yield Optional.of(category);
            }
            case 1 -> {
                ShortcutEntry shortcutEntry = (ShortcutEntry)abstractShortcutEntry;
                yield Optional.of(shortcutEntry.category);
            }
            default -> Optional.empty();
        };
    }

    public void setSelected(@Nullable AbstractShortcutEntry entry) {
        super.method_25313((class_350.class_351)entry);
        this.screen.updateButtons();
    }

    protected void addShortcutAfterSelected() {
        this.getCategory().ifPresent(category -> this.method_25396().add(this.method_25396().indexOf(this.method_25334()) + 1, (AbstractShortcutEntry)category.entrySupplier.get()));
    }

    protected void updatePositions() {
        for (AbstractShortcutEntry child : this.method_25396()) {
            child.updatePositions();
        }
    }

    protected void updateKeybinds() {
        this.method_25396().stream().filter(KeybindShortcutEntry.class::isInstance).map(KeybindShortcutEntry.class::cast).forEach(KeybindShortcutEntry::update);
    }

    protected boolean method_25332(int index) {
        return Debug.debugEnabled() ? Objects.equals(this.method_25334(), this.method_25396().get(index)) : super.method_25332(index);
    }

    protected boolean removeEntry(AbstractShortcutEntry entry) {
        return super.method_25330((class_350.class_351)entry);
    }

    protected boolean hasChanges() {
        ShortcutEntry[] notEmptyShortcuts = (ShortcutEntry[])this.getNotEmptyShortcuts().toArray(ShortcutEntry[]::new);
        return notEmptyShortcuts.length != Shortcuts.shortcuts.getData().size() || Arrays.stream(notEmptyShortcuts).anyMatch(ShortcutEntry::isChanged);
    }

    protected void saveShortcuts() {
        Shortcuts.shortcuts.getData().clear();
        this.getNotEmptyShortcuts().forEach(ShortcutEntry::save);
        Shortcuts.shortcuts.save();
    }

    private Stream<? extends ShortcutEntry<?>> getNotEmptyShortcuts() {
        return this.method_25396().stream().filter(ShortcutEntry.class::isInstance).map(e -> (ShortcutEntry)((Object)e)).filter(ShortcutEntry::isNotEmpty);
    }

    protected class ShortcutCategoryEntry<T>
    extends AbstractShortcutEntry {
        private final Map<T, String> shortcutsMap;
        private final Supplier<ShortcutEntry<T>> entrySupplier;
        private final class_2561 targetName;
        private final class_2561 replacementName;
        @Nullable
        private final class_2561 tooltip;

        private ShortcutCategoryEntry(Map<T, String> shortcutsMap, @Translatable Function<ShortcutCategoryEntry<T>, ShortcutEntry<T>> entryFactory, @Translatable String targetName, String replacementName) {
            this(shortcutsMap, entryFactory, targetName, replacementName, (class_2561)null);
        }

        private ShortcutCategoryEntry(Map<T, String> shortcutsMap, @Translatable Function<ShortcutCategoryEntry<T>, ShortcutEntry<T>> entryFactory, @Translatable String targetName, @Translatable String replacementName, String tooltip) {
            this(shortcutsMap, entryFactory, targetName, replacementName, (class_2561)class_2561.method_43471((String)tooltip));
        }

        private ShortcutCategoryEntry(Map<T, String> shortcutsMap, @Translatable Function<ShortcutCategoryEntry<T>, ShortcutEntry<T>> entryFactory, @Translatable String targetName, @Nullable String replacementName, class_2561 tooltip) {
            this.shortcutsMap = shortcutsMap;
            this.entrySupplier = () -> (ShortcutEntry)((Object)((Object)entryFactory.apply(this)));
            this.targetName = class_2561.method_43471((String)targetName);
            this.replacementName = class_2561.method_43471((String)replacementName);
            this.tooltip = tooltip;
            ShortcutsConfigListWidget.this.method_25321((class_350.class_351)this);
        }

        public List<? extends class_364> method_25396() {
            return List.of();
        }

        public List<? extends class_6379> method_37025() {
            return List.of(new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 builder) {
                    builder.method_37035(class_6381.field_33788, new class_2561[]{ShortcutCategoryEntry.this.targetName, ShortcutCategoryEntry.this.replacementName});
                }
            });
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            context.method_27534(((ShortcutsConfigListWidget)ShortcutsConfigListWidget.this).field_22740.field_1772, this.targetName, ShortcutsConfigListWidget.this.field_22758 / 2 - 85, y + 5, -1);
            context.method_27534(((ShortcutsConfigListWidget)ShortcutsConfigListWidget.this).field_22740.field_1772, this.replacementName, ShortcutsConfigListWidget.this.field_22758 / 2 + 85, y + 5, -1);
            if (this.tooltip != null && this.method_25405(mouseX, mouseY)) {
                context.method_71276(this.tooltip, mouseX, mouseY);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            return true;
        }
    }

    private class ShortcutLoadingEntry
    extends AbstractShortcutEntry {
        private final class_2561 text = class_2561.method_43471((String)"skyblocker.shortcuts.notLoaded");

        private ShortcutLoadingEntry() {
        }

        public List<? extends class_364> method_25396() {
            return List.of();
        }

        public List<? extends class_6379> method_37025() {
            return List.of(new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 builder) {
                    builder.method_37034(class_6381.field_33788, ShortcutLoadingEntry.this.text);
                }
            });
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            context.method_27534(((ShortcutsConfigListWidget)ShortcutsConfigListWidget.this).field_22740.field_1772, this.text, ShortcutsConfigListWidget.this.field_22758 / 2, y + 5, -1);
        }
    }

    public static abstract class AbstractShortcutEntry
    extends class_4265.class_4266<AbstractShortcutEntry> {
        protected void updatePositions() {
        }
    }

    protected abstract class ShortcutEntry<T>
    extends AbstractShortcutEntry {
        protected final ShortcutCategoryEntry<T> category;
        protected final class_342 replacement;

        private ShortcutEntry(ShortcutCategoryEntry<T> category, T targetKey) {
            this.category = category;
            this.replacement = new class_342(class_310.method_1551().field_1772, ShortcutsConfigListWidget.this.field_22758 / 2 + 10, 5, 150, 20, category.replacementName);
            this.replacement.method_1880(48);
            this.replacement.method_1852(category.shortcutsMap.getOrDefault(targetKey, ""));
        }

        protected abstract boolean isNotEmpty();

        protected abstract boolean isChanged();

        protected abstract void save();

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.replacement.method_46419(y);
            this.replacement.method_25394(context, mouseX, mouseY, tickDelta);
            context.method_25300(((ShortcutsConfigListWidget)ShortcutsConfigListWidget.this).field_22740.field_1772, "\u2192", ShortcutsConfigListWidget.this.field_22758 / 2, y + 5, -1);
        }

        @Override
        protected void updatePositions() {
            super.updatePositions();
            this.replacement.method_46421(ShortcutsConfigListWidget.this.field_22758 / 2 + 10);
        }
    }

    protected class KeybindShortcutEntry
    extends ShortcutEntry<ShortcutKeyBinding> {
        private final List<class_339> children;
        private final ShortcutKeyBinding keyBinding;
        private final class_4185 keybindButton;
        private boolean duplicate;

        private KeybindShortcutEntry(ShortcutCategoryEntry<ShortcutKeyBinding> category) {
            this(category, new ShortcutKeyBinding(class_3675.field_16237));
        }

        private KeybindShortcutEntry(ShortcutCategoryEntry<ShortcutKeyBinding> category, ShortcutKeyBinding keyBinding) {
            super(category, keyBinding);
            this.duplicate = false;
            this.keyBinding = keyBinding;
            this.keybindButton = class_4185.method_46430((class_2561)keyBinding.getBoundKey().method_27445(), button -> {
                ShortcutsConfigListWidget.this.screen.selectedKeyBinding = keyBinding;
                ShortcutsConfigListWidget.this.updateKeybinds();
            }).method_46434(ShortcutsConfigListWidget.this.field_22758 / 2 - 160, 5, 150, 20).method_46435(textSupplier -> keyBinding.isUnbound() ? class_2561.method_43469((String)"narrator.controls.unbound", (Object[])new Object[]{this.replacement.method_1882()}) : class_2561.method_43469((String)"narrator.controls.bound", (Object[])new Object[]{this.replacement.method_1882(), textSupplier.get()})).method_46431();
            this.replacement.method_1863(command -> ShortcutsConfigListWidget.this.updateKeybinds());
            this.children = List.of(this.keybindButton, this.replacement);
            this.update();
        }

        public String toString() {
            return this.keyBinding.getBoundKey().method_27445().getString() + " \u2192 " + this.replacement.method_1882();
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        @Override
        protected boolean isNotEmpty() {
            return !this.keyBinding.isUnbound() && !this.replacement.method_1882().isEmpty();
        }

        @Override
        protected boolean isChanged() {
            return !this.category.shortcutsMap.containsKey(this.keyBinding) || !this.category.shortcutsMap.get(this.keyBinding).equals(this.replacement.method_1882());
        }

        @Override
        protected void save() {
            this.category.shortcutsMap.put(this.keyBinding, this.replacement.method_1882());
        }

        @Override
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            super.method_25343(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            this.keybindButton.method_46419(y);
            this.keybindButton.method_25394(context, mouseX, mouseY, tickDelta);
            if (this.duplicate) {
                context.method_25294(this.keybindButton.method_46426() - 6, y - 1, this.keybindButton.method_46426() - 3, y + entryHeight, -65536);
            }
        }

        @Override
        protected void updatePositions() {
            super.updatePositions();
            this.keybindButton.method_46421(ShortcutsConfigListWidget.this.field_22758 / 2 - 160);
        }

        protected void update() {
            this.keybindButton.method_25355(this.keyBinding.getBoundKey().method_27445());
            this.duplicate = false;
            class_5250 text = class_2561.method_43473();
            if (!this.keyBinding.isUnbound()) {
                for (class_304 otherKeyBinding : ((ShortcutsConfigListWidget)ShortcutsConfigListWidget.this).field_22740.field_1690.field_1839) {
                    if (!this.keyBinding.getBoundKey().method_1441().equals(otherKeyBinding.method_1428())) continue;
                    if (this.duplicate) {
                        text.method_27693(", ");
                    }
                    this.duplicate = true;
                    text.method_10852((class_2561)class_2561.method_43471((String)otherKeyBinding.method_1431()));
                }
                for (AbstractShortcutEntry shortcut : ShortcutsConfigListWidget.this.method_25396()) {
                    if (!(shortcut instanceof KeybindShortcutEntry)) continue;
                    KeybindShortcutEntry keyBindingShortcut = (KeybindShortcutEntry)shortcut;
                    if (this.keyBinding == keyBindingShortcut.keyBinding || !this.keyBinding.equals(keyBindingShortcut.keyBinding)) continue;
                    if (this.duplicate) {
                        text.method_27693(", ");
                    }
                    this.duplicate = true;
                    text.method_27693(keyBindingShortcut.replacement.method_1882());
                }
            }
            if (this.duplicate) {
                this.keybindButton.method_25355((class_2561)class_2561.method_43470((String)"[ ").method_10852((class_2561)this.keybindButton.method_25369().method_27661().method_27692(class_124.field_1068)).method_27693(" ]").method_27692(class_124.field_1061));
                this.keybindButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43469((String)"controls.keybinds.duplicateKeybinds", (Object[])new Object[]{text})));
            } else {
                this.keybindButton.method_47400(null);
            }
            if (ShortcutsConfigListWidget.this.screen.selectedKeyBinding == this.keyBinding) {
                this.keybindButton.method_25355((class_2561)class_2561.method_43470((String)"> ").method_10852((class_2561)this.keybindButton.method_25369().method_27661().method_27695(new class_124[]{class_124.field_1068, class_124.field_1073})).method_27693(" <").method_27692(class_124.field_1054));
            }
        }
    }

    protected class CommandShortcutEntry
    extends ShortcutEntry<String> {
        private final List<class_342> children;
        private final class_342 target;

        private CommandShortcutEntry(ShortcutCategoryEntry<String> category) {
            this(category, "");
        }

        private CommandShortcutEntry(ShortcutCategoryEntry<String> category, String targetString) {
            super(category, targetString);
            this.target = new class_342(class_310.method_1551().field_1772, ShortcutsConfigListWidget.this.field_22758 / 2 - 160, 5, 150, 20, category.targetName);
            this.target.method_1880(48);
            this.target.method_1852(targetString);
            this.children = List.of(this.target, this.replacement);
        }

        public String toString() {
            return this.target.method_1882() + " \u2192 " + this.replacement.method_1882();
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        @Override
        protected boolean isNotEmpty() {
            return !this.target.method_1882().isEmpty() && !this.replacement.method_1882().isEmpty();
        }

        @Override
        protected boolean isChanged() {
            return !this.category.shortcutsMap.containsKey(this.target.method_1882()) || !this.category.shortcutsMap.get(this.target.method_1882()).equals(this.replacement.method_1882());
        }

        @Override
        protected void save() {
            this.category.shortcutsMap.put(this.target.method_1882(), this.replacement.method_1882());
        }

        @Override
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            super.method_25343(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            this.target.method_46419(y);
            this.target.method_25394(context, mouseX, mouseY, tickDelta);
        }

        @Override
        protected void updatePositions() {
            super.updatePositions();
            this.target.method_46421(ShortcutsConfigListWidget.this.field_22758 / 2 - 160);
        }
    }
}

