/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.rift;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.OtherLocationsConfig;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.PosUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.waypoint.ProfileAwareWaypoint;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnigmaSouls {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnigmaSouls.class);
    private static final Supplier<Waypoint.Type> TYPE_SUPPLIER = () -> SkyblockerConfigManager.get().uiAndVisuals.waypoints.waypointType;
    private static final class_2960 WAYPOINTS_JSON = class_2960.method_60655((String)"skyblocker", (String)"rift/enigma_soul_waypoints.json");
    private static final Map<class_2338, ProfileAwareWaypoint> SOUL_WAYPOINTS = new HashMap<class_2338, ProfileAwareWaypoint>(42);
    private static final Path FOUND_SOULS_FILE = SkyblockerMod.CONFIG_DIR.resolve("found_enigma_souls.json");
    private static final float[] GREEN = ColorUtils.getFloatComponents(class_1767.field_7942);
    private static final float[] RED = ColorUtils.getFloatComponents(class_1767.field_7964);
    private static CompletableFuture<Void> soulsLoaded;

    static void load(class_310 client) {
        soulsLoaded = CompletableFuture.runAsync(() -> {
            BufferedReader reader;
            try {
                reader = client.method_1478().openAsReader(WAYPOINTS_JSON);
                try {
                    JsonObject file = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    JsonArray waypoints = file.get("waypoints").getAsJsonArray();
                    for (int i = 0; i < waypoints.size(); ++i) {
                        JsonObject waypoint = waypoints.get(i).getAsJsonObject();
                        class_2338 pos = new class_2338(waypoint.get("x").getAsInt(), waypoint.get("y").getAsInt(), waypoint.get("z").getAsInt());
                        SOUL_WAYPOINTS.put(pos, new EnigmaSoul(pos, TYPE_SUPPLIER, GREEN, RED));
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("[Skyblocker] There was an error while loading enigma soul waypoints!", (Throwable)e);
            }
            try {
                reader = Files.newBufferedReader(FOUND_SOULS_FILE);
                try {
                    for (Map.Entry profile : JsonParser.parseReader((Reader)reader).getAsJsonObject().asMap().entrySet()) {
                        for (JsonElement foundSoul : ((JsonElement)profile.getValue()).getAsJsonArray().asList()) {
                            SOUL_WAYPOINTS.get(PosUtils.parsePosString(foundSoul.getAsString())).setFound((String)profile.getKey());
                        }
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (NoSuchFileException reader2) {
            }
            catch (IOException e) {
                LOGGER.error("[Skyblocker] There was an error while loading found enigma souls!", (Throwable)e);
            }
        });
    }

    static void save(class_310 client) {
        HashMap<String, Set> foundSouls = new HashMap<String, Set>();
        for (ProfileAwareWaypoint profileAwareWaypoint : SOUL_WAYPOINTS.values()) {
            for (String profile : profileAwareWaypoint.foundProfiles) {
                foundSouls.computeIfAbsent(profile, profile_ -> new HashSet());
                ((Set)foundSouls.get(profile)).add(profileAwareWaypoint.pos);
            }
        }
        JsonObject json = new JsonObject();
        for (Map.Entry entry : foundSouls.entrySet()) {
            JsonArray foundSoulsJson = new JsonArray();
            for (class_2338 foundSoul : (Set)entry.getValue()) {
                foundSoulsJson.add(PosUtils.getPosString(foundSoul));
            }
            json.add((String)entry.getKey(), (JsonElement)foundSoulsJson);
        }
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(FOUND_SOULS_FILE, new OpenOption[0]);){
            SkyblockerMod.GSON.toJson((JsonElement)json, (Appendable)bufferedWriter);
        }
        catch (IOException iOException) {
            LOGGER.error("[Skyblocker] There was an error while saving found enigma souls!", (Throwable)iOException);
        }
    }

    static void render(WorldRenderContext context) {
        OtherLocationsConfig.Rift config = SkyblockerConfigManager.get().otherLocations.rift;
        if (Utils.isInTheRift() && config.enigmaSoulWaypoints && soulsLoaded.isDone()) {
            for (Waypoint waypoint : SOUL_WAYPOINTS.values()) {
                if (!waypoint.shouldRender() && !config.highlightFoundEnigmaSouls) continue;
                waypoint.render(context);
            }
        }
    }

    static boolean onMessage(class_2561 text, boolean overlay) {
        String message;
        if (Utils.isInTheRift() && !overlay && ((message = text.getString()).equals("You have already found that Enigma Soul!") || class_124.method_539((String)message).equals("SOUL! You unlocked an Enigma Soul!"))) {
            EnigmaSouls.markClosestSoulAsFound();
        }
        return true;
    }

    static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"rift").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"enigmaSouls").then(ClientCommandManager.literal((String)"markAllFound").executes(context -> {
            SOUL_WAYPOINTS.values().forEach(Waypoint::setFound);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.rift.enigmaSouls.markAllFound")));
            return 1;
        }))).then(ClientCommandManager.literal((String)"markAllMissing").executes(context -> {
            SOUL_WAYPOINTS.values().forEach(Waypoint::setMissing);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.rift.enigmaSouls.markAllMissing")));
            return 1;
        })))));
    }

    private static void markClosestSoulAsFound() {
        class_746 player = class_310.method_1551().field_1724;
        if (!soulsLoaded.isDone() || player == null) {
            return;
        }
        SOUL_WAYPOINTS.values().stream().filter(Waypoint::shouldRender).min(Comparator.comparingDouble(soul -> soul.pos.method_19770((class_2374)player.method_19538()))).filter(soul -> soul.pos.method_19770((class_2374)player.method_19538()) <= 16.0).ifPresent(Waypoint::setFound);
    }

    private static class EnigmaSoul
    extends ProfileAwareWaypoint {
        private EnigmaSoul(class_2338 pos, Supplier<Waypoint.Type> typeSupplier, float[] missingColor, float[] foundColor) {
            super(pos, typeSupplier, missingColor, foundColor);
        }

        @Override
        public boolean shouldRender() {
            return super.shouldRender() || SkyblockerConfigManager.get().otherLocations.rift.highlightFoundEnigmaSouls;
        }
    }
}

