/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer.slayers;

import com.google.gson.JsonObject;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerPage;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerScreen;
import de.hysky.skyblocker.skyblock.profileviewer.slayers.SlayerWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_332;

public class SlayersPage
implements ProfileViewerPage {
    private static final String[] SLAYERS = new String[]{"Zombie", "Spider", "Wolf", "Enderman", "Vampire", "Blaze"};
    private static final int ROW_GAP = 28;
    private final List<SlayerWidget> slayerWidgets = new ArrayList<SlayerWidget>();

    public SlayersPage(JsonObject pProfile) {
        try {
            for (String slayer : SLAYERS) {
                this.slayerWidgets.add(new SlayerWidget(slayer, this.getSlayerXP(slayer.toLowerCase(), pProfile), pProfile));
            }
        }
        catch (Exception e) {
            ProfileViewerScreen.LOGGER.error("[Skyblocker Profile Viewer] Error creating slayer widgets", (Throwable)e);
        }
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta, int rootX, int rootY) {
        for (int i = 0; i < this.slayerWidgets.size(); ++i) {
            this.slayerWidgets.get(i).render(context, mouseX, mouseY, rootX, rootY + i * 28);
        }
    }

    private long getSlayerXP(String slayer, JsonObject pProfile) {
        try {
            return pProfile.getAsJsonObject("slayer").getAsJsonObject("slayer_bosses").getAsJsonObject(slayer).get("xp").getAsLong();
        }
        catch (Exception e) {
            return 0L;
        }
    }
}

