/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer.skills;

import com.google.gson.JsonObject;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerPage;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerScreen;
import de.hysky.skyblocker.skyblock.profileviewer.skills.SkillWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class SkillsPage
implements ProfileViewerPage {
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"skyblocker", (String)"textures/gui/profile_viewer/icon_data_widget.png");
    private static final String[] SKILLS = new String[]{"Combat", "Mining", "Farming", "Foraging", "Fishing", "Enchanting", "Alchemy", "Taming", "Carpentry", "Catacombs", "Runecraft", "Social"};
    private static final int ROW_GAP = 28;
    private final JsonObject HYPIXEL_PROFILE;
    private final JsonObject PLAYER_PROFILE;
    private final List<SkillWidget> skillWidgets = new ArrayList<SkillWidget>();
    private JsonObject skills;

    public SkillsPage(JsonObject hProfile, JsonObject pProfile) {
        this.HYPIXEL_PROFILE = hProfile;
        this.PLAYER_PROFILE = pProfile;
        try {
            this.skills = this.PLAYER_PROFILE.getAsJsonObject("player_data").getAsJsonObject("experience");
            for (String skill : SKILLS) {
                this.skillWidgets.add(new SkillWidget(skill, this.getSkillXP("SKILL_" + skill.toUpperCase()), this.getSkillCap(skill)));
            }
        }
        catch (Exception e) {
            ProfileViewerScreen.LOGGER.error("[Skyblocker Profile Viewer] Error creating widgets.", (Throwable)e);
        }
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta, int rootX, int rootY) {
        int column2 = rootX + 113;
        for (int i = 0; i < this.skillWidgets.size(); ++i) {
            int x = i < 6 ? rootX : column2;
            int y = rootY + i % 6 * 28;
            context.method_25290(class_10799.field_56883, TEXTURE, x, y, 0.0f, 0.0f, 109, 26, 109, 26);
            this.skillWidgets.get(i).render(context, mouseX, mouseY, x, y + 3);
        }
    }

    private int getSkillCap(String skill) {
        try {
            return switch (skill) {
                case "Farming" -> this.PLAYER_PROFILE.getAsJsonObject("jacobs_contest").getAsJsonObject("perks").get("farming_level_cap").getAsInt();
                case "Taming" -> this.PLAYER_PROFILE.getAsJsonObject("pets_data").getAsJsonObject("pet_care").getAsJsonArray("pet_types_sacrificed").size();
                default -> -1;
            };
        }
        catch (Exception e) {
            return 0;
        }
    }

    private long getSkillXP(String skill) {
        try {
            return switch (skill) {
                case "SKILL_CATACOMBS" -> this.getCatacombsXP();
                case "SKILL_SOCIAL" -> this.getCoopSocialXP();
                case "SKILL_RUNECRAFT" -> this.skills.get("SKILL_RUNECRAFTING").getAsLong();
                default -> this.skills.get(skill).getAsLong();
            };
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private long getCatacombsXP() {
        try {
            JsonObject dungeonSkills = this.PLAYER_PROFILE.getAsJsonObject("dungeons").getAsJsonObject("dungeon_types");
            return dungeonSkills.getAsJsonObject("catacombs").get("experience").getAsLong();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private long getCoopSocialXP() {
        long socialXP = 0L;
        JsonObject members = this.HYPIXEL_PROFILE.getAsJsonObject("members");
        for (String memberId : members.keySet()) {
            try {
                socialXP += members.getAsJsonObject(memberId).getAsJsonObject("player_data").getAsJsonObject("experience").get("SKILL_SOCIAL").getAsLong();
            }
            catch (Exception e) {
                ProfileViewerScreen.LOGGER.warn("[Skyblocker Profile Viewer] Error calculating co-op social xp", (Throwable)e);
            }
        }
        return socialXP;
    }
}

