/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer.dungeons;

import com.google.gson.JsonObject;
import de.hysky.skyblocker.skyblock.profileviewer.utils.LevelFinder;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.render.HudHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;

public class DungeonClassWidget {
    private final String className;
    private LevelFinder.LevelInfo classLevel;
    private static final int CLASS_CAP = 50;
    private JsonObject classData;
    private final class_1799 stack;
    private boolean active = false;
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"skyblocker", (String)"textures/gui/profile_viewer/icon_data_widget.png");
    private static final class_2960 ACTIVE_TEXTURE = class_2960.method_60655((String)"skyblocker", (String)"textures/gui/item_protection.png");
    private static final class_2960 BAR_FILL = class_2960.method_60655((String)"skyblocker", (String)"bars/bar_fill");
    private static final class_2960 BAR_BACK = class_2960.method_60655((String)"skyblocker", (String)"bars/bar_back");
    private static final class_327 textRenderer = class_310.method_1551().field_1772;
    private static final Map<String, class_1799> CLASS_ICON = Map.ofEntries(Map.entry("Healer", Ico.S_POTION), Map.entry("Mage", Ico.B_ROD), Map.entry("Berserk", Ico.IRON_SWORD), Map.entry("Archer", Ico.BOW), Map.entry("Tank", Ico.CHESTPLATE));

    public DungeonClassWidget(String className, JsonObject playerProfile) {
        this.className = className;
        this.stack = CLASS_ICON.getOrDefault(className, Ico.BARRIER);
        try {
            this.classData = playerProfile.getAsJsonObject("dungeons").getAsJsonObject("player_classes").getAsJsonObject(this.className.toLowerCase());
            this.classLevel = LevelFinder.getLevelInfo("Catacombs", this.classData.get("experience").getAsLong());
            this.active = playerProfile.getAsJsonObject("dungeons").get("selected_dungeon_class").getAsString().equals(className.toLowerCase());
        }
        catch (Exception ignored) {
            this.classLevel = LevelFinder.getLevelInfo("", 0L);
        }
    }

    public void render(class_332 context, int mouseX, int mouseY, int x, int y) {
        context.method_25290(class_10799.field_56883, TEXTURE, x, y, 0.0f, 0.0f, 109, 26, 109, 26);
        context.method_51427(this.stack, x + 3, y + 5);
        if (this.active) {
            context.method_25290(class_10799.field_56883, ACTIVE_TEXTURE, x + 3, y + 5, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        context.method_51433(textRenderer, this.className + " " + this.classLevel.level, x + 31, y + 5, Color.WHITE.getRGB(), false);
        Color fillColor = this.classLevel.level >= 50 ? Color.MAGENTA : Color.GREEN;
        context.method_52706(class_10799.field_56883, BAR_BACK, x + 30, y + 15, 75, 6);
        HudHelper.renderNineSliceColored(context, BAR_FILL, x + 30, y + 15, (int)(75.0 * this.classLevel.fill), 6, fillColor);
        if (mouseX > x + 30 && mouseX < x + 105 && mouseY > y + 12 && mouseY < y + 22) {
            ArrayList<class_5250> tooltipText = new ArrayList<class_5250>();
            tooltipText.add(class_2561.method_43470((String)this.className).method_27692(class_124.field_1060));
            tooltipText.add(class_2561.method_43470((String)("XP: " + Formatters.INTEGER_NUMBERS.format(this.classLevel.xp))).method_27692(class_124.field_1065));
            context.method_51434(textRenderer, tooltipText, mouseX, mouseY);
        }
    }
}

