/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.tooltip.adders;

import de.hysky.skyblocker.skyblock.item.tooltip.ItemTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.SimpleTooltipAdder;
import de.hysky.skyblocker.skyblock.item.tooltip.info.TooltipInfoType;
import de.hysky.skyblocker.utils.BazaarProduct;
import de.hysky.skyblocker.utils.ItemUtils;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class BazaarPriceTooltip
extends SimpleTooltipAdder {
    public BazaarPriceTooltip(int priority) {
        super(priority);
    }

    @Override
    public void addToTooltip(@Nullable class_1735 focusedSlot, class_1799 stack, List<class_2561> lines) {
        String skyblockApiId = stack.getSkyblockApiId();
        if (TooltipInfoType.BAZAAR.hasOrNullWarning(skyblockApiId)) {
            int count = Math.max(ItemUtils.getItemCountInSack(stack, lines).orElse(ItemUtils.getItemCountInStash(lines.getFirst()).orElse(stack.method_7947())), 1);
            BazaarProduct product = (BazaarProduct)TooltipInfoType.BAZAAR.getData().get((Object)skyblockApiId);
            lines.add((class_2561)class_2561.method_43470((String)String.format("%-18s", "Bazaar Buy Price:")).method_27692(class_124.field_1065).method_10852((class_2561)(product.buyPrice().isEmpty() ? class_2561.method_43470((String)"No data").method_27692(class_124.field_1061) : ItemTooltip.getCoinsMessage(product.buyPrice().getAsDouble(), count))));
            lines.add((class_2561)class_2561.method_43470((String)String.format("%-19s", "Bazaar Sell Price:")).method_27692(class_124.field_1065).method_10852((class_2561)(product.sellPrice().isEmpty() ? class_2561.method_43470((String)"No data").method_27692(class_124.field_1061) : ItemTooltip.getCoinsMessage(product.sellPrice().getAsDouble(), count))));
        }
    }

    @Override
    public boolean isEnabled() {
        return TooltipInfoType.BAZAAR.isTooltipEnabled();
    }
}

