/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.slottext.adders;

import de.hysky.skyblocker.skyblock.item.slottext.SimpleSlotTextAdder;
import de.hysky.skyblocker.skyblock.item.slottext.SlotText;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.container.SlotTextAdder;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YourEssenceAdder
extends SimpleSlotTextAdder {
    private static final Pattern YOUR_ESSENCE = Pattern.compile("You currently own (?<essence>[\\d,]+)");
    private static final Pattern ESSENCE_GUIDE = Pattern.compile("Your \\w+ Essence: (?<essence>[\\d,]+)");
    private static final SlotTextAdder.ConfigInformation CONFIG_INFORMATION = new SlotTextAdder.ConfigInformation("your_essence", "skyblocker.config.uiAndVisuals.slotText.yourEssence");

    public YourEssenceAdder() {
        super("^(?:Your Essence|Essence Guide)", CONFIG_INFORMATION);
    }

    @Override
    @NotNull
    public List<SlotText> getText(@Nullable class_1735 slot, @NotNull class_1799 stack, int slotId) {
        if (stack.method_7964().getString().contains("Essence")) {
            return this.essenceAmountMatcher(ItemUtils.getLore(stack)).map(essenceAmountMatcher -> {
                String essenceAmount = essenceAmountMatcher.group("essence").replace(",", "");
                if (!essenceAmount.matches("-?\\d+")) {
                    return List.of();
                }
                return SlotText.bottomRightList((class_2561)class_2561.method_43470((String)Formatters.SHORT_FLOAT_NUMBERS.format(Integer.parseInt(essenceAmount))).method_54663(16768449));
            }).orElse(List.of());
        }
        return List.of();
    }

    @NotNull
    private Optional<Matcher> essenceAmountMatcher(List<class_2561> lore) {
        if (lore.isEmpty()) {
            return Optional.empty();
        }
        Matcher essenceAmountMatcher = YOUR_ESSENCE.matcher(lore.getFirst().getString());
        if (essenceAmountMatcher.find()) {
            return Optional.of(essenceAmountMatcher);
        }
        if (lore.size() < 3) {
            return Optional.empty();
        }
        essenceAmountMatcher = ESSENCE_GUIDE.matcher(lore.get(lore.size() - 3).getString());
        if (essenceAmountMatcher.find()) {
            return Optional.of(essenceAmountMatcher);
        }
        return Optional.empty();
    }
}

