/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.slottext.adders;

import de.hysky.skyblocker.skyblock.item.slottext.SimpleSlotTextAdder;
import de.hysky.skyblocker.skyblock.item.slottext.SlotText;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.RegexUtils;
import de.hysky.skyblocker.utils.container.SlotTextAdder;
import java.util.List;
import java.util.OptionalDouble;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvolvingItemAdder
extends SimpleSlotTextAdder {
    private static final Pattern BONUS_PATTERN = Pattern.compile("\\+?([\\d.]+)");
    private static final SlotTextAdder.ConfigInformation CONFIG_INFORMATION = new SlotTextAdder.ConfigInformation("evolving_items", "skyblocker.config.uiAndVisuals.slotText.evolvingItems", "skyblocker.config.uiAndVisuals.slotText.evolvingItems.@Tooltip");

    public EvolvingItemAdder() {
        super(CONFIG_INFORMATION);
    }

    @Override
    @NotNull
    public List<SlotText> getText(@Nullable class_1735 slot, @NotNull class_1799 stack, int slotId) {
        switch (stack.getSkyblockId()) {
            case "NEW_BOTTLE_OF_JYRRE": 
            case "DARK_CACAO_TRUFFLE": 
            case "DISCRITE": 
            case "MOBY_DUCK": {
                return this.actualLogic(stack, "Current Bonus: ");
            }
            case "TRAINING_WEIGHTS": {
                return this.actualLogic(stack, "Strength Gain: ");
            }
            case "BOTTLE_OF_JYRRE": {
                return this.actualLogic(stack, "Intelligence Bonus: ");
            }
        }
        return List.of();
    }

    private List<SlotText> actualLogic(class_1799 stack, String equal) {
        List<class_2561> lore = ItemUtils.getLore(stack);
        if (lore.isEmpty()) {
            return List.of();
        }
        for (class_2561 line : lore) {
            class_2561 bonus;
            Matcher matcher;
            OptionalDouble result;
            List siblings = line.method_10855();
            if (siblings.size() < 2 || !((class_2561)siblings.getFirst()).getString().equals(equal) || !(result = RegexUtils.findDoubleFromMatcher(matcher = BONUS_PATTERN.matcher((bonus = (class_2561)siblings.get(1)).getString()))).isPresent()) continue;
            return SlotText.bottomLeftList((class_2561)class_2561.method_43470((String)Formatters.DOUBLE_NUMBERS.format(result.getAsDouble())).method_10862(bonus.method_10866()));
        }
        return List.of();
    }
}

