/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.custom;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.command.argumenttypes.color.ColorArgumentType;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3489;
import net.minecraft.class_7157;
import net.minecraft.class_9322;

public class CustomArmorDyeColors {
    @Init
    public static void init() {
        ClientCommandRegistrationCallback.EVENT.register(CustomArmorDyeColors::registerCommands);
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"custom").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"dyeColor").executes(context -> CustomArmorDyeColors.customizeDyeColor((FabricClientCommandSource)context.getSource(), Integer.MIN_VALUE))).then(ClientCommandManager.argument((String)"hexCode", (ArgumentType)ColorArgumentType.hex()).executes(context -> CustomArmorDyeColors.customizeDyeColor((FabricClientCommandSource)context.getSource(), ColorArgumentType.getIntFromHex((CommandContext<FabricClientCommandSource>)context, "hexCode")))))));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int customizeDyeColor(FabricClientCommandSource source, int color) {
        class_1799 heldItem = source.getPlayer().method_6047();
        if (Utils.isOnSkyblock() && heldItem != null) {
            if (!heldItem.method_31573(class_3489.field_48803)) {
                source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customDyeColors.notDyeable")));
                return 1;
            }
            String itemUuid = ItemUtils.getItemUuid((class_9322)heldItem);
            if (itemUuid.isEmpty()) {
                source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customDyeColors.noItemUuid")));
                return 1;
            }
            Object2IntOpenHashMap<String> customDyeColors = SkyblockerConfigManager.get().general.customDyeColors;
            if (color != Integer.MIN_VALUE) {
                SkyblockerConfigManager.update(config -> config.general.customDyeColors.put((Object)itemUuid, color));
                source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customDyeColors.added")));
                return 1;
            }
            if (customDyeColors.containsKey((Object)itemUuid)) {
                SkyblockerConfigManager.update(config -> config.general.customDyeColors.removeInt((Object)itemUuid));
                source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customDyeColors.removed")));
                return 1;
            }
            source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customDyeColors.neverHad")));
            return 1;
        }
        source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customDyeColors.unableToSetColor")));
        return 1;
    }
}

