/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.ItemUtils;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_9322;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiLookup {
    private static final Logger LOGGER = LoggerFactory.getLogger(WikiLookup.class);
    public static class_304 officialWikiLookup;
    public static class_304 fandomWikiLookup;

    @Init
    public static void init() {
        officialWikiLookup = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.wikiLookup.official", class_3675.class_307.field_1668, 293, "key.categories.skyblocker"));
        fandomWikiLookup = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.wikiLookup.fandom", class_3675.class_307.field_1668, 290, "key.categories.skyblocker"));
    }

    public static String getKeysText() {
        String fandom;
        String official = officialWikiLookup.method_1415() ? null : officialWikiLookup.method_16007().getString();
        String string = fandom = fandomWikiLookup.method_1415() ? null : fandomWikiLookup.method_16007().getString();
        if (official == null && fandom == null) {
            return "";
        }
        if (official == null) {
            return fandom.toUpperCase(Locale.ENGLISH);
        }
        if (fandom == null) {
            return official.toUpperCase(Locale.ENGLISH);
        }
        return (official + "/" + fandom).toUpperCase(Locale.ENGLISH);
    }

    public static boolean handleWikiLookup(class_1799 stack, class_1657 player, boolean itemName, int keyCode, int scanCode) {
        boolean officialWikiLookup;
        if (SkyblockerConfigManager.get().general.wikiLookup.enableWikiLookup && ((officialWikiLookup = WikiLookup.officialWikiLookup.method_1417(keyCode, scanCode)) || fandomWikiLookup.method_1417(keyCode, scanCode))) {
            if (itemName) {
                WikiLookup.openWikiItemName(stack.method_7964().getString(), player, officialWikiLookup);
            } else {
                WikiLookup.openWiki(stack, player, officialWikiLookup);
            }
            return true;
        }
        return false;
    }

    public static void openWiki(class_1799 stack, class_1657 player, boolean useOfficial) {
        ItemUtils.getItemIdOptional((class_9322)stack).map(neuId -> ItemRepository.getWikiLink(neuId, useOfficial)).ifPresentOrElse(wikiLink -> WikiLookup.openWikiLink(wikiLink, player), () -> player.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)(useOfficial ? class_2561.method_43471((String)"skyblocker.wikiLookup.noArticleFound.official") : class_2561.method_43471((String)"skyblocker.wikiLookup.noArticleFound.fandom"))), false));
    }

    public static void openWikiItemName(String itemName, class_1657 player, boolean useOfficial) {
        itemName = itemName.replace(" ", "_");
        itemName = itemName.replace("?", URLEncoder.encode("?", StandardCharsets.UTF_8));
        String wikiLink = ItemRepository.getWikiLink(useOfficial) + "/" + itemName;
        WikiLookup.openWikiLink(wikiLink, player);
    }

    private static void openWikiLink(String wikiLink, class_1657 player) {
        CompletableFuture.runAsync(() -> class_156.method_668().method_670(wikiLink)).exceptionally(e -> {
            LOGGER.error("[Skyblocker] Error while retrieving wiki article...", e);
            player.method_7353((class_2561)Constants.PREFIX.get().method_27693("Error while retrieving wiki article, see logs..."), false);
            return null;
        });
    }
}

