/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.compatibility.ResourcePackCompatibility;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.mixins.accessors.HandledScreenAccessor;
import de.hysky.skyblocker.mixins.accessors.ScreenAccessor;
import de.hysky.skyblocker.mixins.accessors.SlotAccessor;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_10799;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_490;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkyblockInventoryScreen
extends class_490 {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Equipment");
    private static final Supplier<class_1799[]> EMPTY_EQUIPMENT = () -> new class_1799[]{class_1799.field_8037, class_1799.field_8037, class_1799.field_8037, class_1799.field_8037};
    public static final class_1799[] equipment = EMPTY_EQUIPMENT.get();
    public static final class_1799[] equipment_rift = EMPTY_EQUIPMENT.get();
    private static final Codec<class_1799[]> CODEC = ItemUtils.EMPTY_ALLOWING_ITEMSTACK_CODEC.listOf(4, 8).xmap(itemStacks -> (class_1799[])itemStacks.toArray(class_1799[]::new), List::of).fieldOf("items").codec();
    private static final class_2960 SLOT_TEXTURE = class_2960.method_60656((String)"container/slot");
    private static final class_2960 EMPTY_SLOT = class_2960.method_60655((String)"skyblocker", (String)"equipment/empty_icon");
    private static final Path FOLDER = SkyblockerMod.CONFIG_DIR.resolve("equipment");
    private final class_1735[] equipmentSlots = new class_1735[4];

    private static void save(String profileId) {
        try {
            Files.createDirectories(FOLDER, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("[Skyblocker] Failed to create folder for equipment!", (Throwable)e);
        }
        Path resolve = FOLDER.resolve(profileId + ".nbt");
        try {
            class_2507.method_55324((class_2520)((class_2520)CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)((class_1799[])ArrayUtils.addAll((Object[])equipment, (Object[])equipment_rift))).getOrThrow()), (DataOutput)new DataOutputStream(Files.newOutputStream(resolve, new OpenOption[0])));
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker] Failed to save Equipment data", (Throwable)e);
        }
    }

    private static void load(String profileId) {
        Path resolve = FOLDER.resolve(profileId + ".nbt");
        CompletableFuture.supplyAsync(() -> {
            try {
                return (class_1799[])CODEC.parse((DynamicOps)class_2509.field_11560, (Object)class_2507.method_10633((Path)resolve)).getOrThrow();
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker] Failed to load Equipment data", (Throwable)e);
            }
            return EMPTY_EQUIPMENT.get();
        }).thenAccept(itemStacks -> class_310.method_1551().execute(() -> {
            System.arraycopy(itemStacks, 0, equipment, 0, Math.min(((class_1799[])itemStacks).length, 4));
            if (((class_1799[])itemStacks).length <= 4) {
                return;
            }
            System.arraycopy(itemStacks, 4, equipment_rift, 0, Math.clamp((long)(((class_1799[])itemStacks).length - 4), 0, 4));
        }));
    }

    public void method_49589() {
        class_1735 slot = (class_1735)((class_1723)this.field_2797).field_7761.get(45);
        ((SlotAccessor)slot).setX(slot.field_7873 + 21);
    }

    @Init
    public static void initEquipment() {
        SkyblockEvents.PROFILE_CHANGE.register((prevProfileId, profileId) -> {
            if (!prevProfileId.isEmpty()) {
                CompletableFuture.runAsync(() -> SkyblockInventoryScreen.save(prevProfileId)).thenRun(() -> SkyblockInventoryScreen.load(profileId));
            } else {
                SkyblockInventoryScreen.load(profileId);
            }
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(client1 -> {
            String profileId = Utils.getProfileId();
            if (!profileId.isBlank()) {
                CompletableFuture.runAsync(() -> SkyblockInventoryScreen.save(profileId));
            }
        });
    }

    public SkyblockInventoryScreen(class_1657 player) {
        super(player);
        if (ResourcePackCompatibility.options.renameInventoryScreen().orElse(false).booleanValue()) {
            ((ScreenAccessor)((Object)this)).setTitle((class_2561)class_2561.method_43470((String)(SkyblockerConfigManager.get().quickNav.enableQuickNav ? "InventoryScreenEquipmentQuickNavSkyblocker" : "InventoryScreenEquipmentSkyblocker")));
        }
        class_1277 inventory = new class_1277(Utils.isInTheRift() ? equipment_rift : equipment);
        for (int i = 0; i < 4; ++i) {
            this.equipmentSlots[i] = new EquipmentSlot((class_1263)inventory, i, 77, 8 + i * 18);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (class_1735 equipmentSlot : this.equipmentSlots) {
            if (!this.method_2378(equipmentSlot.field_7873, equipmentSlot.field_7872, 16, 16, mouseX, mouseY)) continue;
            MessageScheduler.INSTANCE.sendMessageAfterCooldown("/equipment", true);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        for (class_1735 equipmentSlot : this.equipmentSlots) {
            boolean hovered = this.method_2378(equipmentSlot.field_7873, equipmentSlot.field_7872, 16, 16, mouseX, mouseY);
            if (hovered) {
                context.method_52706(class_10799.field_56883, HandledScreenAccessor.getSLOT_HIGHLIGHT_BACK_TEXTURE(), equipmentSlot.field_7873 - 4, equipmentSlot.field_7872 - 4, 24, 24);
            }
            this.method_2385(context, equipmentSlot);
            if (!hovered) continue;
            context.method_52706(class_10799.field_56883, HandledScreenAccessor.getSLOT_HIGHLIGHT_FRONT_TEXTURE(), equipmentSlot.field_7873 - 4, equipmentSlot.field_7872 - 4, 24, 24);
        }
        super.method_2388(context, mouseX, mouseY);
    }

    protected void method_2380(class_332 context, int x, int y) {
        super.method_2380(context, x, y);
        if (!((class_1723)this.field_2797).method_34255().method_7960()) {
            return;
        }
        for (class_1735 equipmentSlot : this.equipmentSlots) {
            if (!this.method_2378(equipmentSlot.field_7873, equipmentSlot.field_7872, 16, 16, x, y) || !equipmentSlot.method_7681()) continue;
            class_1799 itemStack = equipmentSlot.method_7677();
            context.method_64038(this.field_22793, this.method_51454(itemStack), itemStack.method_32347(), x, y);
        }
    }

    public void method_25432() {
        super.method_25432();
        class_1735 slot = (class_1735)((class_1723)this.field_2797).field_7761.get(45);
        ((SlotAccessor)slot).setX(slot.field_7873 - 21);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        super.method_2389(context, delta, mouseX, mouseY);
        for (int i = 0; i < 3; ++i) {
            context.method_52706(class_10799.field_56883, SLOT_TEXTURE, this.field_2776 + 76, this.field_2800 + 7 + i * 18, 18, 18);
        }
        class_1735 slot = (class_1735)((class_1723)this.field_2797).field_7761.get(45);
        context.method_52706(class_10799.field_56883, SLOT_TEXTURE, this.field_2776 + slot.field_7873 - 1, this.field_2800 + slot.field_7872 - 1, 18, 18);
    }

    protected void method_2385(class_332 context, class_1735 slot) {
        super.method_2385(context, slot);
        if (slot instanceof EquipmentSlot && !slot.method_7681()) {
            context.method_52706(class_10799.field_56883, EMPTY_SLOT, slot.field_7873, slot.field_7872, 16, 16);
        }
    }

    private static class EquipmentSlot
    extends class_1735 {
        private EquipmentSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean method_7674(class_1657 playerEntity) {
            return false;
        }

        public boolean method_7680(class_1799 stack) {
            return false;
        }
    }
}

