/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.hunting;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.container.ContainerSolver;
import de.hysky.skyblocker.utils.container.SimpleContainerSolver;
import de.hysky.skyblocker.utils.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuntingBoxHelper
extends SimpleContainerSolver {
    private static final Pattern OWNED_PATTERN = Pattern.compile("Owned: (\\d+) Shards?");
    private static final Pattern SYPHON_PATTERN = Pattern.compile("Syphon (\\d+) more to level up!");
    private static final Logger LOGGER = LoggerFactory.getLogger(HuntingBoxHelper.class);

    public HuntingBoxHelper() {
        super("^Hunting Box$");
    }

    @Override
    public List<ColorHighlight> getColors(Int2ObjectMap<class_1799> slots) {
        ArrayList<ColorHighlight> highlights = new ArrayList<ColorHighlight>();
        ContainerSolver.trimEdges(slots, 6);
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            List<class_2561> lore;
            class_1799 stack = (class_1799)entry.getValue();
            if (stack.method_7960() || (lore = ItemUtils.getLore(stack)).isEmpty()) continue;
            String owned = null;
            String syphon = null;
            for (class_2561 line : lore) {
                Matcher matcher;
                String text = line.getString();
                if (owned == null) {
                    matcher = OWNED_PATTERN.matcher(text);
                    if (!matcher.matches()) continue;
                    owned = matcher.group(1);
                    continue;
                }
                matcher = SYPHON_PATTERN.matcher(text);
                if (!matcher.matches()) break;
                syphon = matcher.group(1);
                break;
            }
            if (owned == null || syphon == null) continue;
            int ownedCount = NumberUtils.toInt(owned, (int)-1);
            int syphonCount = NumberUtils.toInt(syphon, (int)-1);
            if (ownedCount < 0 || syphonCount < 0) {
                LOGGER.warn("Invalid owned or syphon count in Hunting Box: owned={}, syphon={}.", owned, syphon);
                continue;
            }
            if (ownedCount < syphonCount) continue;
            boolean enoughButNotUnlocked = lore.getLast().getString().startsWith("Requires");
            highlights.add(enoughButNotUnlocked ? ColorHighlight.yellow(entry.getIntKey()) : ColorHighlight.green(entry.getIntKey()));
        }
        return highlights;
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().hunting.huntingBox.enabled;
    }
}

