/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.hunting;

import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.skyblock.hunting.Attribute;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_9322;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class Attributes {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2960 ATTRIBUTES_FILE = class_2960.method_60655((String)"skyblocker", (String)"hunting/attributes.json");
    private static List<Attribute> attributes = List.of();

    @Init
    public static void init() {
        ClientLifecycleEvents.CLIENT_STARTED.register(Attributes::loadShards);
    }

    private static void loadShards(class_310 client) {
        CompletableFuture.runAsync(() -> {
            try (BufferedReader reader = client.method_1478().openAsReader(ATTRIBUTES_FILE);){
                attributes = (List)Attribute.LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).getOrThrow();
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker Attributes] Failed to load attributes.", (Throwable)e);
            }
        });
    }

    @Nullable
    public static Attribute getAttributeFromItemName(class_9322 stack) {
        if (!stack.method_57826(class_9334.field_49631)) {
            return null;
        }
        String name = ((class_2561)stack.method_58694(class_9334.field_49631)).getString();
        name = name.replace(" Shard", "");
        name = name.replace("BUY ", "").replace("SELL ", "");
        for (Attribute attribute : attributes) {
            if (!attribute.shardName().equals(name)) continue;
            return attribute;
        }
        return null;
    }
}

