/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.galatea;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.Area;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_124;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;

public class TerracottaPuzzle {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final class_2338 WALL_TOP_LEFT = new class_2338(-633, 66, 85);
    private static final class_2338 WALL_BOTTOM_RIGHT = new class_2338(-640, 65, 85);
    private static final class_2338 FLOOR_TOP_LEFT = new class_2338(-633, 59, 76);
    private static final class_2338 FLOOR_BOTTOM_LEFT = new class_2338(-633, 59, 75);
    private static final Map<class_2350, class_2350> DIRECTION_MAPPINGS = Map.ofEntries(Map.entry(class_2350.field_11043, class_2350.field_11039), Map.entry(class_2350.field_11034, class_2350.field_11035), Map.entry(class_2350.field_11035, class_2350.field_11034), Map.entry(class_2350.field_11039, class_2350.field_11043));

    @Init
    public static void init() {
        WorldRenderEvents.AFTER_TRANSLUCENT.register(TerracottaPuzzle::render);
    }

    private static List<class_2350> solve() {
        if (TerracottaPuzzle.CLIENT.field_1687 == null) {
            return List.of();
        }
        ArrayList<class_2350> solutions = new ArrayList<class_2350>();
        for (int x = WALL_TOP_LEFT.method_10263(); x >= WALL_BOTTOM_RIGHT.method_10263(); --x) {
            for (int y = WALL_TOP_LEFT.method_10264(); y >= WALL_BOTTOM_RIGHT.method_10264(); --y) {
                class_2338 pos = new class_2338(x, y, WALL_TOP_LEFT.method_10260());
                class_2680 state = TerracottaPuzzle.CLIENT.field_1687.method_8320(pos);
                if (!state.method_27852(class_2246.field_10280) || !state.method_28498((class_2769)class_2741.field_12481)) continue;
                class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
                solutions.add(DIRECTION_MAPPINGS.get(facing));
            }
        }
        return solutions;
    }

    private static void render(WorldRenderContext context) {
        if (!SkyblockerConfigManager.get().foraging.galatea.solveForestTemplePuzzle || !Utils.isInGalatea() || Utils.getArea() != Area.FOREST_TEMPLE || TerracottaPuzzle.CLIENT.field_1687 == null) {
            return;
        }
        List<class_2350> solutions = TerracottaPuzzle.solve();
        for (int i = 0; i < solutions.size(); ++i) {
            class_2350 correctDirection = solutions.get(i);
            class_2338 pos = TerracottaPuzzle.getFloorBlock(i);
            class_2680 state = TerracottaPuzzle.CLIENT.field_1687.method_8320(pos);
            if (!state.method_27852(class_2246.field_10280) || !state.method_28498((class_2769)class_2741.field_12481)) continue;
            class_2350 floorDirection = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
            int clockwiseRotations = 0;
            class_2350 lastClockwiseRotation = floorDirection;
            int counterclockwiseRotations = 0;
            class_2350 lastCounterclockwiseRotation = floorDirection;
            int rotationsNeeded = 0;
            for (int j = 0; j < 4 && floorDirection != correctDirection; ++j) {
                ++clockwiseRotations;
                if ((lastClockwiseRotation = lastClockwiseRotation.method_10170()) == correctDirection) {
                    rotationsNeeded = clockwiseRotations;
                    break;
                }
                ++counterclockwiseRotations;
                if ((lastCounterclockwiseRotation = lastCounterclockwiseRotation.method_10160()) != correctDirection) continue;
                rotationsNeeded = -counterclockwiseRotations;
                break;
            }
            if (clockwiseRotations == 0) continue;
            RenderHelper.renderText(context, (class_2561)class_2561.method_43470((String)String.valueOf(rotationsNeeded)).method_27692(class_124.field_1058), class_243.method_24953((class_2382)pos).method_1031(0.0, 1.0, 0.0), false);
        }
    }

    private static class_2338 getFloorBlock(int index) {
        int rowIndex = index / 2;
        return index % 2 == 0 ? FLOOR_TOP_LEFT.method_10069(-rowIndex, 0, 0) : FLOOR_BOTTOM_LEFT.method_10069(-rowIndex, 0, 0);
    }
}

