/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.galatea;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.ParticleEvents;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2675;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_8113;

public class ForestNodes {
    private static final class_310 client = class_310.method_1551();
    private static final Map<class_2338, ForestNode> forestNodes = new HashMap<class_2338, ForestNode>();

    @Init
    public static void init() {
        Scheduler.INSTANCE.scheduleCyclic(ForestNodes::update, 20);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(ForestNodes::render);
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            if (!ForestNodes.shouldProcess()) {
                return class_1269.field_5811;
            }
            forestNodes.remove(pos);
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (!ForestNodes.shouldProcess()) {
                return class_1269.field_5811;
            }
            class_2338 pos = hitResult.method_17777();
            forestNodes.remove(pos);
            return class_1269.field_5811;
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> ForestNodes.reset());
        ParticleEvents.FROM_SERVER.register(ForestNodes::onParticle);
    }

    private static void onParticle(class_2675 packet) {
        int stringItemCount;
        if (!ForestNodes.shouldProcess()) {
            return;
        }
        class_2396 particleType = packet.method_11551().method_10295();
        if (!class_2398.field_11211.method_29140().equals(particleType)) {
            return;
        }
        double x = packet.method_11544();
        double y = packet.method_11547() - 1.0;
        double z = packet.method_11546();
        class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
        if (ForestNodes.client.field_1687 != null && (stringItemCount = ForestNodes.countStringItemDisplays(pos)) == 3) {
            forestNodes.computeIfAbsent(pos, ForestNode::new);
        }
    }

    private static int countStringItemDisplays(class_2338 pos) {
        class_638 world = ForestNodes.client.field_1687;
        if (world == null) {
            return 0;
        }
        List entities = world.method_8390(class_8113.class_8122.class, class_238.method_30048((class_243)pos.method_46558(), (double)1.0, (double)1.0, (double)1.0), entity -> true);
        return (int)entities.stream().filter(entity -> {
            class_1799 stack = entity.method_48900();
            return !stack.method_7960() && stack.method_7909().equals(class_1802.field_8276);
        }).count();
    }

    private static void update() {
        if (!ForestNodes.shouldProcess()) {
            return;
        }
        Iterator<Map.Entry<class_2338, ForestNode>> iterator = forestNodes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_2338, ForestNode> entry = iterator.next();
            ForestNode forestNode = entry.getValue();
            forestNode.updateWaypoint();
            if (forestNode.shouldRender()) continue;
            iterator.remove();
        }
    }

    private static void render(WorldRenderContext context) {
        if (!ForestNodes.shouldProcess()) {
            return;
        }
        for (ForestNode forestNode : forestNodes.values()) {
            if (!forestNode.shouldRender()) continue;
            forestNode.render(context);
        }
    }

    private static boolean shouldProcess() {
        return SkyblockerConfigManager.get().foraging.galatea.enableForestNodeHelper && Utils.isInGalatea();
    }

    private static void reset() {
        forestNodes.clear();
    }

    public static class ForestNode
    extends Waypoint {
        private long lastConfirmed = System.currentTimeMillis();

        private ForestNode(class_2338 pos) {
            super(pos, () -> Waypoint.Type.HIGHLIGHT, ColorUtils.getFloatComponents(class_1767.field_7946), 0.5f, 5.0f, false);
        }

        private void updateWaypoint() {
            long currentTimeMillis = System.currentTimeMillis();
            if (this.lastConfirmed + 2000L > currentTimeMillis || ForestNodes.client.field_1687 == null) {
                return;
            }
            int stringItemCount = ForestNodes.countStringItemDisplays(this.pos);
            if (stringItemCount == 3) {
                this.lastConfirmed = System.currentTimeMillis();
            }
        }

        @Override
        public boolean shouldRender() {
            return super.shouldRender() && this.lastConfirmed + 5000L > System.currentTimeMillis();
        }
    }
}

