/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.entity.glow.adder;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.entity.MobGlowAdder;
import de.hysky.skyblocker.skyblock.garden.CurrentJacobCrop;
import de.hysky.skyblocker.skyblock.garden.GardenConstants;
import de.hysky.skyblocker.skyblock.item.HeadTextures;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import org.apache.commons.lang3.StringUtils;

public class GardenGlowAdder
extends MobGlowAdder {
    private static final GardenGlowAdder INSTANCE = new GardenGlowAdder();
    private static final int PEST_COLOUR = 11939584;
    private static final Pattern CURRENT_CROP_PATTERN = Pattern.compile("^ [\u25cb\u2618] (?<crop>.+) .+$");

    @Init
    public static void init() {
        Scheduler.INSTANCE.scheduleCyclic(GardenGlowAdder::update, 20);
    }

    @Override
    public int computeColour(class_1297 entity) {
        int n;
        class_1297 class_12972 = entity;
        Objects.requireNonNull(class_12972);
        class_1297 class_12973 = class_12972;
        int n2 = 0;
        block3: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1531.class}, (Object)class_12973, n2)) {
                case 0: {
                    class_1531 as = (class_1531)class_12973;
                    if (!GardenGlowAdder.isPestHead(as)) {
                        n2 = 1;
                        continue block3;
                    }
                    if (GardenGlowAdder.doesPestMatchCurrentContest(as)) {
                        n = class_124.field_1060.method_532();
                        break block3;
                    }
                    n = 11939584;
                    break block3;
                }
                default: {
                    n = 0;
                    break block3;
                }
            }
            break;
        }
        return n;
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().farming.garden.pestHighlighter && Utils.isInGarden();
    }

    private static boolean isPestHead(class_1531 entity) {
        return entity.method_6084(class_1304.field_6169) && HeadTextures.PEST_HEADS.contains(ItemUtils.getHeadTexture(entity.method_6118(class_1304.field_6169)));
    }

    private static void update() {
        if (!INSTANCE.isEnabled() || Utils.STRING_SCOREBOARD.stream().noneMatch(s -> s.contains("Jacob's Contest"))) {
            CurrentJacobCrop.CURRENT_CROP_CONTEST = null;
            return;
        }
        for (String line : Utils.STRING_SCOREBOARD) {
            String crop;
            Matcher matcher = CURRENT_CROP_PATTERN.matcher(line);
            if (!matcher.matches() || Objects.equals(CurrentJacobCrop.CURRENT_CROP_CONTEST, crop = matcher.group("crop").trim())) continue;
            CurrentJacobCrop.CURRENT_CROP_CONTEST = crop;
        }
    }

    public static boolean doesPestMatchCurrentContest(class_1531 entity) {
        if (StringUtils.isEmpty((CharSequence)CurrentJacobCrop.CURRENT_CROP_CONTEST)) {
            return false;
        }
        return entity.method_6084(class_1304.field_6169) && GardenConstants.PEST_HEAD_BY_CROP.get((Object)CurrentJacobCrop.CURRENT_CROP_CONTEST).contains(ItemUtils.getHeadTexture(entity.method_6118(class_1304.field_6169)));
    }
}

