/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.entity;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.skyblock.entity.MobGlowAdder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1531;
import net.minecraft.class_1937;
import net.minecraft.class_238;

public class MobGlow {
    public static final int NO_GLOW = 0;
    private static final List<MobGlowAdder> ADDERS = new ArrayList<MobGlowAdder>();
    private static final Object2IntMap<class_1297> CACHE = new Object2IntOpenHashMap();

    @Init
    public static void init() {
        ClientTickEvents.END_WORLD_TICK.register(client -> MobGlow.clearCache());
    }

    public static boolean atLeastOneMobHasCustomGlow() {
        return !CACHE.isEmpty();
    }

    protected static void registerGlowAdder(MobGlowAdder adder) {
        ADDERS.add(adder);
    }

    public static boolean hasOrComputeMobGlow(class_1297 entity) {
        if (CACHE.containsKey((Object)entity)) {
            return true;
        }
        int color = MobGlow.computeMobGlow(entity);
        if (color != 0) {
            CACHE.put((Object)entity, color);
            return true;
        }
        return false;
    }

    public static int getMobGlow(class_1297 entity) {
        return CACHE.getInt((Object)entity);
    }

    public static int getMobGlowOrDefault(class_1297 entity, int defaultColor) {
        return CACHE.getOrDefault((Object)entity, defaultColor);
    }

    public static void clearCache() {
        CACHE.clear();
    }

    private static int computeMobGlow(class_1297 entity) {
        for (MobGlowAdder adder : ADDERS) {
            int glowColour;
            if (!adder.isEnabled() || (glowColour = adder.computeColour(entity)) == 0) continue;
            return glowColour;
        }
        return 0;
    }

    public static String getArmorStandName(class_1297 entity) {
        List<class_1531> armorStands = MobGlow.getArmorStands(entity);
        if (armorStands.isEmpty()) {
            return "";
        }
        return armorStands.getFirst().method_5477().getString();
    }

    public static List<class_1531> getArmorStands(class_1297 entity) {
        return MobGlow.getArmorStands(entity.method_37908(), entity.method_5829());
    }

    public static List<class_1531> getArmorStands(class_1937 world, class_238 box) {
        return world.method_8390(class_1531.class, box.method_1009(0.0, 2.0, 0.0), class_1301.field_6153);
    }
}

