/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven.profittrackers.corpse;

import de.hysky.skyblocker.skyblock.dwarven.CorpseType;
import de.hysky.skyblocker.skyblock.dwarven.profittrackers.corpse.CorpseList;
import de.hysky.skyblocker.skyblock.dwarven.profittrackers.corpse.CorpseLoot;
import de.hysky.skyblocker.skyblock.dwarven.profittrackers.corpse.CorpseProfitTracker;
import de.hysky.skyblocker.skyblock.dwarven.profittrackers.corpse.Reward;
import it.unimi.dsi.fastutil.objects.AbstractReference2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import org.apache.commons.text.WordUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewardList
extends class_4265<AbstractEntry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RewardList.class);
    private static final int BORDER_COLOR = -9670522;
    private static final int INNER_MARGIN = 2;

    public RewardList(class_310 client, int width, int height, int y, int entryHeight, List<CorpseLoot> lootList) {
        super(client, width, height, y, entryHeight);
        if (lootList.isEmpty()) {
            this.addEmptyEntry();
            this.addEmptyEntry();
            this.addEmptyEntry();
            this.method_25321((class_350.class_351)new SingleEntry((class_2561)class_2561.method_43471((String)"skyblocker.corpseTracker.emptyHistory").method_27692(class_124.field_1061), false));
            return;
        }
        List rewards = (List)lootList.stream().flatMap(loot -> loot.rewards().stream()).collect(ObjectArrayList::new, (list, entry) -> {
            if (list.stream().anyMatch(reward -> reward.itemId().equals(entry.itemId()))) {
                list.stream().filter(reward -> reward.itemId().equals(entry.itemId())).findFirst().ifPresent(reward -> reward.amount(reward.amount() + entry.amount()));
            } else {
                list.add((Object)new Reward(entry.amount(), entry.itemId(), entry.pricePerUnit()));
            }
        }, ObjectList::addAll);
        rewards.sort(Comparator.comparingInt(RewardList::comparePriority).thenComparing(Reward::itemId));
        Reference2IntArrayMap keyAmounts = lootList.stream().collect(Reference2IntArrayMap::new, (map, loot) -> map.mergeInt((Object)loot.corpseType(), 1, Integer::sum), AbstractReference2IntMap::putAll);
        double profit = lootList.stream().mapToDouble(CorpseLoot::profit).sum();
        for (Reward reward : rewards) {
            class_2561 itemName = CorpseList.getItemName(reward.itemId());
            if (CorpseProfitTracker.PRICELESS_ITEMS.contains(reward.itemId())) {
                this.method_25321((class_350.class_351)new MultiEntry(itemName, reward.amount()));
                continue;
            }
            this.method_25321((class_350.class_351)new MultiEntry(itemName, reward.amount(), reward.pricePerUnit()));
        }
        this.method_25321((class_350.class_351)new SingleEntry((class_2561)class_2561.method_43473()));
        for (Reference2IntMap.Entry entry2 : keyAmounts.reference2IntEntrySet()) {
            this.method_25321((class_350.class_351)new MultiEntry((CorpseType)((Object)entry2.getKey()), entry2.getIntValue()));
        }
        this.method_25321((class_350.class_351)new SingleEntry((class_2561)class_2561.method_43473()));
        this.method_25321((class_350.class_351)new MultiEntry(profit));
    }

    private static int comparePriority(Reward reward) {
        ObjectIterator ids = CorpseProfitTracker.getName2IdMap().values().iterator();
        int i = 0;
        while (ids.hasNext()) {
            if (((String)ids.next()).equals(reward.itemId())) {
                return i;
            }
            ++i;
        }
        LOGGER.warn("Item ID `{}` not found in NAME2ID map", (Object)reward.itemId());
        return Integer.MAX_VALUE;
    }

    private void addEmptyEntry() {
        this.method_25321((class_350.class_351)new EmptyEntry());
    }

    public int method_25322() {
        return 500;
    }

    public int method_25337(int index) {
        return this.method_46427() - (int)this.method_44387() + index * this.field_22741 + this.field_22748;
    }

    protected void method_25311(class_332 context, int mouseX, int mouseY, float delta) {
        int i = this.method_25342();
        int j = this.method_25322();
        int l = this.method_25340();
        for (int m = 0; m < l; ++m) {
            int n = this.method_25337(m);
            int o = this.method_25319(m);
            if (o < this.method_46427() || n > this.method_55443()) continue;
            this.method_44397(context, mouseX, mouseY, delta, m, i, n, j, this.field_22741);
        }
    }

    private static class SingleEntry
    extends AbstractEntry {
        private boolean drawBorder = true;

        private SingleEntry(class_2561 text) {
            this.children = List.of(new class_7842(text, class_310.method_1551().field_1772).method_48597());
        }

        private SingleEntry(class_2561 text, boolean drawBorder) {
            this(text);
            this.drawBorder = drawBorder;
        }

        @Override
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (this.drawBorder) {
                context.method_49601(x, y, entryWidth, entryHeight + 1, -9670522);
            }
            for (class_339 child : this.children) {
                child.method_46421(x + 2);
                child.method_46419(y + 2);
                child.method_25358(entryWidth - 4);
                child.method_25394(context, mouseX, mouseY, tickDelta);
            }
        }
    }

    private static class MultiEntry
    extends AbstractEntry {
        @Nullable
        protected class_7842 itemName;
        @Nullable
        protected class_7842 amount;
        @Nullable
        protected class_7842 totalPrice;
        @Nullable
        protected class_7842 pricePerUnit = null;

        private MultiEntry(class_2561 itemName, int amount, double pricePerUnit) {
            this.itemName = new class_7842(itemName, class_310.method_1551().field_1772).method_48596();
            this.amount = new class_7842((class_2561)class_2561.method_43470((String)("x" + amount)).method_27692(class_124.field_1075), class_310.method_1551().field_1772).method_48597();
            this.totalPrice = new class_7842((class_2561)class_2561.method_43470((String)(NumberFormat.getInstance().format((double)amount * pricePerUnit) + " Coins")).method_27692(class_124.field_1065), class_310.method_1551().field_1772);
            if (amount > 1) {
                this.pricePerUnit = new class_7842((class_2561)class_2561.method_43470((String)(NumberFormat.getInstance().format(pricePerUnit) + " each")).method_27692(class_124.field_1080), class_310.method_1551().field_1772);
                this.children = List.of(this.itemName, this.amount, this.totalPrice, this.pricePerUnit);
            } else {
                this.children = List.of(this.itemName, this.amount, this.totalPrice);
            }
        }

        private MultiEntry(class_2561 itemName, int amount) {
            this.itemName = new class_7842(itemName, class_310.method_1551().field_1772).method_48596();
            this.amount = new class_7842((class_2561)class_2561.method_43470((String)("x" + amount)).method_27692(class_124.field_1075), class_310.method_1551().field_1772).method_48597();
            this.children = List.of(this.itemName, this.amount);
        }

        private MultiEntry(double profit) {
            this.itemName = new class_7842((class_2561)class_2561.method_43470((String)"Total Profit").method_27695(new class_124[]{class_124.field_1067, class_124.field_1065}), class_310.method_1551().field_1772).method_48596();
            this.totalPrice = new class_7842((class_2561)class_2561.method_43470((String)(NumberFormat.getInstance().format(profit) + " Coins")).method_27692(profit > 0.0 ? class_124.field_1060 : class_124.field_1061), class_310.method_1551().field_1772);
            this.children = List.of(this.itemName, this.totalPrice);
        }

        private MultiEntry(CorpseType corpseType, int amount) {
            this.itemName = new class_7842((class_2561)class_2561.method_43470((String)(WordUtils.capitalizeFully((String)corpseType.name()) + " Corpse Key Cost")).method_27692(corpseType.color), class_310.method_1551().field_1772).method_48596();
            this.amount = new class_7842((class_2561)class_2561.method_43470((String)("x" + amount)).method_27692(class_124.field_1075), class_310.method_1551().field_1772).method_48597();
            double pricePerKey = corpseType.getKeyPrice();
            String priceString = String.valueOf(pricePerKey > 0.0 ? "-" + NumberFormat.getInstance().format(pricePerKey * (double)amount) : Integer.valueOf(0)) + " Coins";
            class_5250 priceText = class_2561.method_43470((String)priceString).method_27692(pricePerKey > 0.0 ? class_124.field_1061 : class_124.field_1065);
            this.totalPrice = new class_7842((class_2561)priceText, class_310.method_1551().field_1772);
            if (amount > 1) {
                this.pricePerUnit = new class_7842((class_2561)class_2561.method_43470((String)(NumberFormat.getInstance().format(pricePerKey) + " each")).method_27692(class_124.field_1080), class_310.method_1551().field_1772);
                this.children = List.of(this.itemName, this.amount, this.totalPrice, this.pricePerUnit);
            } else {
                this.children = List.of(this.itemName, this.amount, this.totalPrice);
            }
        }

        @Override
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            context.method_49601(x, y, entryWidth, entryHeight + 1, -9670522);
            context.method_49601(x + entryWidth / 3, y, entryWidth / 6 + 2, entryHeight + 1, -9670522);
            context.method_49601(x + entryWidth / 2, y, entryWidth / 4, entryHeight + 1, -9670522);
            int entryY = y + 2;
            if (this.itemName != null) {
                this.itemName.method_46421(x + 2);
                this.itemName.method_46419(entryY);
                this.itemName.method_25358(entryWidth / 3 - 4);
                this.itemName.method_25394(context, mouseX, mouseY, tickDelta);
            }
            if (this.amount != null) {
                this.amount.method_46421(x + entryWidth / 3 + 2);
                this.amount.method_46419(entryY);
                this.amount.method_25358(entryWidth / 6 - 4);
                this.amount.method_25394(context, mouseX, mouseY, tickDelta);
            }
            if (this.totalPrice != null) {
                this.totalPrice.method_46421(x + entryWidth / 2 + 2);
                this.totalPrice.method_46419(entryY);
                this.totalPrice.method_25358(entryWidth / 4 - 4);
                this.totalPrice.method_25394(context, mouseX, mouseY, tickDelta);
            }
            if (this.pricePerUnit != null) {
                this.pricePerUnit.method_46421(x + 3 * entryWidth / 4 + 2);
                this.pricePerUnit.method_46419(entryY);
                this.pricePerUnit.method_25358(entryWidth / 4 - 4);
                this.pricePerUnit.method_25394(context, mouseX, mouseY, tickDelta);
            }
        }
    }

    private static class EmptyEntry
    extends AbstractEntry {
        private EmptyEntry() {
            this.children = List.of();
        }
    }

    static abstract class AbstractEntry
    extends class_4265.class_4266<AbstractEntry> {
        protected List<class_339> children;

        AbstractEntry() {
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }
    }
}

